/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.RaisedMarginBorder;
import org.eclipse.epf.authoring.gef.edit.policies.RoleTaskFlowLayoutEditPolicy;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class RoleTaskCompositeEditPart
extends NodeContainerEditPart {
    private static Color BG_COLOR;

    public RoleTaskCompositeEditPart(RoleTaskComposite model) {
        super((NodeContainer)model);
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        FlowLayout layout = new FlowLayout();
        layout.setMinorSpacing(20);
        figure.setLayoutManager((LayoutManager)layout);
        figure.setBorder((Border)new RaisedMarginBorder());
        figure.setBackgroundColor(this.getBackgroundColor());
        figure.setOpaque(true);
        return figure;
    }

    protected void handlePropertyChanged(Notification msg) {
        switch (msg.getFeatureID(NodeContainer.class)) {
            case 7: {
                this.refreshChildren();
                EditPart diagramEditPart = this.getParent();
                diagramEditPart.refresh();
                return;
            }
        }
        super.handlePropertyChanged(msg);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new RoleTaskFlowLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", null);
    }

    protected Color getBackgroundColor() {
        String colorString;
        if (BG_COLOR != null) {
            return BG_COLOR;
        }
        if (BG_COLOR == null && (colorString = AuthoringUIPlugin.getDefault().getPreferenceStore().getString("ADD_ROLE_TASKS_BOX_BG_COLOR_RGB")) != null && colorString.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(colorString, ",");
            int r = Integer.parseInt(tokenizer.nextToken());
            int g = Integer.parseInt(tokenizer.nextToken());
            int b = Integer.parseInt(tokenizer.nextToken());
            BG_COLOR = new Color(null, r, g, b);
            return BG_COLOR;
        }
        if (BG_COLOR == null) {
            BG_COLOR = new Color((Device)Display.getCurrent(), 255, 255, 156);
        }
        return BG_COLOR;
    }
}

