/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.filters.ProcessGuidanceFilter;
import org.eclipse.epf.diagram.model.util.DiagramInfo;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class UserDefinedDiagramDialog
extends Dialog {
    private Button assignADImageButton;
    private Button assignADDImageButton;
    private Button assignWPDImageButton;
    private Button clearADImageButton;
    private Button clearADDImageButton;
    private Button clearWPDImageButton;
    private Button useADImageButton;
    private Button useADDImageButton;
    private Button useWPDImageButton;
    private Text adImageText;
    private Text addImageText;
    private Text wpdImageText;
    private IEditorPart editor;
    private Activity activity;
    private Composite area;
    private final String tabName = FilterConstants.GUIDANCE;
    private IFilter filter;
    private SupportingMaterial activityDiagram;
    private SupportingMaterial activityDetailDiagram;
    private SupportingMaterial wpdDiagram;
    private static final int buttonWidthHint = 60;
    private Set existingList;
    private boolean isWrapped = false;

    public UserDefinedDiagramDialog(Shell parent, IEditorPart editor, Activity activity, MethodConfiguration config, boolean isWrapped) {
        super(parent);
        this.editor = editor;
        this.isWrapped = isWrapped;
        this.activity = activity;
        this.filter = new ProcessGuidanceFilter(config, null, this.tabName){

            public boolean childAccept(Object obj) {
                if (super.childAccept(obj)) {
                    return true;
                }
                if (obj instanceof GuidanceItemProvider) {
                    String name = ((GuidanceItemProvider)obj).getText(obj);
                    return name.equalsIgnoreCase(FilterConstants.SUPPORTING_MATERIALS) && !((GuidanceItemProvider)obj).getChildren(obj).isEmpty();
                }
                return obj instanceof SupportingMaterial;
            }
        };
        this.existingList = new HashSet();
    }

    protected Control createDialogArea(Composite parent) {
        this.area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(4, false);
        this.area.setLayout((Layout)gridLayout);
        Label blankLabel = new Label(this.area, 0);
        blankLabel.setText("");
        this.useADImageButton = new Button(this.area, 32);
        this.useADImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_useADImage);
        GridData buttonGD = new GridData(1);
        buttonGD.horizontalSpan = 3;
        this.useADImageButton.setLayoutData((Object)buttonGD);
        Label aLabel = new Label(this.area, 0);
        aLabel.setText(AuthoringUIResources.UserDefinedDiagramDialog_adImage);
        this.adImageText = new Text(this.area, 2056);
        GridData gd = new GridData(769);
        gd.widthHint = 300;
        this.adImageText.setLayoutData((Object)gd);
        this.assignADImageButton = new Button(this.area, 0);
        this.assignADImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_assignButton);
        GridData buttonGridData = new GridData(769);
        buttonGridData.widthHint = 60;
        this.assignADImageButton.setLayoutData((Object)buttonGridData);
        this.clearADImageButton = new Button(this.area, 0);
        this.clearADImageButton.setText(AuthoringUIResources.clearButton_text);
        this.clearADImageButton.setLayoutData((Object)buttonGridData);
        blankLabel = new Label(this.area, 0);
        blankLabel.setText("");
        this.useADDImageButton = new Button(this.area, 32);
        this.useADDImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_useADDImage);
        buttonGD = new GridData(1);
        buttonGD.horizontalSpan = 3;
        this.useADDImageButton.setLayoutData((Object)buttonGD);
        aLabel = new Label(this.area, 0);
        aLabel.setText(AuthoringUIResources.UserDefinedDiagramDialog_addImage);
        this.addImageText = new Text(this.area, 2056);
        this.addImageText.setLayoutData((Object)gd);
        this.assignADDImageButton = new Button(this.area, 0);
        this.assignADDImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_assignButton);
        this.assignADDImageButton.setLayoutData((Object)buttonGridData);
        this.clearADDImageButton = new Button(this.area, 0);
        this.clearADDImageButton.setText(AuthoringUIResources.clearButton_text);
        this.clearADDImageButton.setLayoutData((Object)buttonGridData);
        blankLabel = new Label(this.area, 0);
        blankLabel.setText("");
        this.useWPDImageButton = new Button(this.area, 32);
        this.useWPDImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_useWPDImage);
        buttonGD = new GridData(1);
        buttonGD.horizontalSpan = 3;
        this.useWPDImageButton.setLayoutData((Object)buttonGD);
        aLabel = new Label(this.area, 0);
        aLabel.setText(AuthoringUIResources.UserDefinedDiagramDialog_wpdImage);
        this.wpdImageText = new Text(this.area, 2056);
        this.wpdImageText.setLayoutData((Object)gd);
        this.assignWPDImageButton = new Button(this.area, 0);
        this.assignWPDImageButton.setText(AuthoringUIResources.UserDefinedDiagramDialog_assignButton);
        this.assignWPDImageButton.setLayoutData((Object)buttonGridData);
        this.clearWPDImageButton = new Button(this.area, 0);
        this.clearWPDImageButton.setText(AuthoringUIResources.clearButton_text);
        this.clearWPDImageButton.setLayoutData((Object)buttonGridData);
        this.loadData();
        if (TngUtil.isLocked((EObject)this.activity) || this.isWrapped) {
            this.disableControls();
        }
        this.addListeners();
        super.getShell().setText(AuthoringUIResources.UserDefinedDiagramDialog_title);
        return this.area;
    }

    private void disableControls() {
        this.useADImageButton.setEnabled(false);
        this.useADDImageButton.setEnabled(false);
        this.useWPDImageButton.setEnabled(false);
        this.assignADImageButton.setEnabled(false);
        this.assignADDImageButton.setEnabled(false);
        this.assignWPDImageButton.setEnabled(false);
        this.clearADImageButton.setEnabled(false);
        this.clearADDImageButton.setEnabled(false);
        this.clearWPDImageButton.setEnabled(false);
    }

    private void loadData() {
        this.existingList.addAll(this.activity.getSupportingMaterials());
        DiagramInfo info = new DiagramInfo(this.activity);
        if (info.getActivityDiagram() != null) {
            this.adImageText.setText(TngUtil.getLabelWithPath((Object)info.getActivityDiagram()));
            this.activityDiagram = info.getActivityDiagram();
            this.existingList.add(this.activityDiagram);
        }
        if (info.getActivityDetailDiagram() != null) {
            this.addImageText.setText(TngUtil.getLabelWithPath((Object)info.getActivityDetailDiagram()));
            this.activityDetailDiagram = info.getActivityDetailDiagram();
            this.existingList.add(this.activityDetailDiagram);
        }
        if (info.getWPDDiagram() != null) {
            this.wpdImageText.setText(TngUtil.getLabelWithPath((Object)info.getWPDDiagram()));
            this.wpdDiagram = info.getWPDDiagram();
            this.existingList.add(this.wpdDiagram);
        }
        this.useADImageButton.setSelection(info.canPublishADImage());
        this.useADDImageButton.setSelection(info.canPublishADDImage());
        this.useWPDImageButton.setSelection(info.canPublishWPDImage());
    }

    private void addListeners() {
        this.assignADImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SupportingMaterial sm = UserDefinedDiagramDialog.this.openFilterDialog();
                    if (sm != null) {
                        UserDefinedDiagramDialog.this.activityDiagram = sm;
                        UserDefinedDiagramDialog.this.adImageText.setText(TngUtil.getLabelWithPath((Object)sm));
                        UserDefinedDiagramDialog.this.existingList.add(UserDefinedDiagramDialog.this.activityDiagram);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.assignADDImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SupportingMaterial sm = UserDefinedDiagramDialog.this.openFilterDialog();
                    if (sm != null) {
                        UserDefinedDiagramDialog.this.activityDetailDiagram = sm;
                        UserDefinedDiagramDialog.this.addImageText.setText(TngUtil.getLabelWithPath((Object)sm));
                        UserDefinedDiagramDialog.this.existingList.add(UserDefinedDiagramDialog.this.activityDetailDiagram);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.assignWPDImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SupportingMaterial sm = UserDefinedDiagramDialog.this.openFilterDialog();
                    if (sm != null) {
                        UserDefinedDiagramDialog.this.wpdDiagram = sm;
                        UserDefinedDiagramDialog.this.wpdImageText.setText(TngUtil.getLabelWithPath((Object)sm));
                        UserDefinedDiagramDialog.this.existingList.add(UserDefinedDiagramDialog.this.wpdDiagram);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.clearADImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserDefinedDiagramDialog.this.existingList.remove(UserDefinedDiagramDialog.this.activityDiagram);
                UserDefinedDiagramDialog.this.adImageText.setText("");
                UserDefinedDiagramDialog.this.activityDiagram = null;
            }
        });
        this.clearADDImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserDefinedDiagramDialog.this.existingList.remove(UserDefinedDiagramDialog.this.activityDetailDiagram);
                UserDefinedDiagramDialog.this.addImageText.setText("");
                UserDefinedDiagramDialog.this.activityDetailDiagram = null;
            }
        });
        this.clearWPDImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserDefinedDiagramDialog.this.existingList.remove(UserDefinedDiagramDialog.this.wpdDiagram);
                UserDefinedDiagramDialog.this.wpdImageText.setText("");
                UserDefinedDiagramDialog.this.wpdDiagram = null;
            }
        });
    }

    private SupportingMaterial openFilterDialog() {
        Object obj;
        ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.filter, this.activity, FilterConstants.SUPPORTING_MATERIALS, Arrays.asList(this.existingList.toArray()));
        fd.setTitle(FilterConstants.SUPPORTING_MATERIALS);
        fd.setViewerSelectionSingle(true);
        fd.setInput(UmaUtil.getMethodLibrary((EObject)this.activity));
        fd.setBlockOnOpen(true);
        fd.open();
        ArrayList list = fd.getSelectedItems();
        if (list != null && !list.isEmpty() && (obj = list.get(0)) instanceof SupportingMaterial) {
            return (SupportingMaterial)obj;
        }
        return null;
    }

    protected void okPressed() {
        if (TngUtil.isLocked((EObject)this.activity) || this.isWrapped) {
            super.okPressed();
        }
        boolean editorDirty = false;
        DiagramInfo info = new DiagramInfo(this.activity);
        if (this.activityDiagram != info.getActivityDiagram()) {
            editorDirty = true;
        }
        info.setActivityDiagram(this.activityDiagram);
        if (!editorDirty && this.activityDetailDiagram != info.getActivityDetailDiagram()) {
            editorDirty = true;
        }
        info.setActivityDetailDiagram(this.activityDetailDiagram);
        if (!editorDirty && this.wpdDiagram != info.getWPDDiagram()) {
            editorDirty = true;
        }
        info.setWPDDiagram(this.wpdDiagram);
        boolean oldCanPublishFlag = info.canPublishADImage();
        boolean newCanPublishFlag = this.useADImageButton.getSelection();
        if (!editorDirty && oldCanPublishFlag != newCanPublishFlag) {
            editorDirty = true;
        }
        info.setPublishADImage(this.useADImageButton.getSelection());
        oldCanPublishFlag = info.canPublishADDImage();
        newCanPublishFlag = this.useADDImageButton.getSelection();
        if (!editorDirty && oldCanPublishFlag != newCanPublishFlag) {
            editorDirty = true;
        }
        info.setPublishADDImage(this.useADDImageButton.getSelection());
        oldCanPublishFlag = info.canPublishWPDImage();
        newCanPublishFlag = this.useWPDImageButton.getSelection();
        if (!editorDirty && oldCanPublishFlag != newCanPublishFlag) {
            editorDirty = true;
        }
        info.setPublishWPDImage(this.useWPDImageButton.getSelection());
        if (editorDirty && !this.promptSaveActiveEditor()) {
            return;
        }
        this.saveActiveEditor();
        super.okPressed();
    }

    private boolean promptSaveActiveEditor() {
        String title = AuthoringUIResources.processFormEditorSaveDialog_title;
        String message = AuthoringUIResources.processFormEditorSaveDialog_message2;
        return AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(title, message);
    }

    private void saveActiveEditor() {
        BusyIndicator.showWhile((Display)this.editor.getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ((ProcessEditor)((UserDefinedDiagramDialog)UserDefinedDiagramDialog.this).editor).resourcesToSave.add(((ProcessComponent)((MethodElementEditorInput)UserDefinedDiagramDialog.this.editor.getEditorInput()).getMethodElement()).getProcess().eResource());
                UserDefinedDiagramDialog.this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        });
    }
}

