/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.providers.CategoryContentProvider;
import org.eclipse.epf.authoring.ui.providers.CategoryLabelProvider;
import org.eclipse.epf.authoring.ui.providers.ConfigPackageContentProvider;
import org.eclipse.epf.authoring.ui.providers.ConfigPackageLabelProvider;
import org.eclipse.epf.authoring.ui.providers.HideUncheckedViewerFilter;
import org.eclipse.epf.authoring.ui.util.AuthoringAccessibleListener;
import org.eclipse.epf.authoring.ui.util.ConfigurationMarkerHelper;
import org.eclipse.epf.authoring.ui.views.MethodContainerCheckedTreeViewer;
import org.eclipse.epf.authoring.ui.views.MethodContainerCheckedTreeViewer2;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationData;
import org.eclipse.epf.library.configuration.ConfigurationProperties;
import org.eclipse.epf.library.configuration.closure.ClosureListener;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.configuration.closure.IConfigurationError;
import org.eclipse.epf.library.edit.IPluginUIPackageContextChangedListener;
import org.eclipse.epf.library.edit.PluginUIPackageContext;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MethodElementSetPropertyCommand;
import org.eclipse.epf.library.edit.navigator.ConfigPageCategoriesItemProvider;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPackagesItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ConfigurationUtil;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.ui.util.SWTUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.ide.IGotoMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPage
extends FormPage
implements IGotoMarker {
    public static final String TOUCHED_BY_CONFIG_EDITOR = "TouchedByConfigEditor";
    private String formPrefix = AuthoringUIResources.ConfigurationPage_FormPrefix;
    private MethodConfiguration config = null;
    private ConfigurationClosure closure = null;
    private MethodContainerCheckedTreeViewer configViewer;
    private ConfigPackageContentProvider contProvider;
    private ConfigPackageLabelProvider labelProvider;
    private MethodContainerCheckedTreeViewer2 addCategoryViewer;
    private MethodContainerCheckedTreeViewer2 subCategoryViewer;
    private HideUncheckedViewerFilter configViewerHideUncheckedFilter;
    private HideUncheckedViewerFilter addCategoryHideUncheckedFilter;
    private HideUncheckedViewerFilter subCategoryHideUncheckedFilter;
    private ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.createConfigPage_LibraryComposedAdapterFactory();
    private ILibraryChangeListener libListener = null;
    private static final ConfigurationMarkerHelper markerHelper = ConfigurationMarkerHelper.INSTANCE;
    boolean isDirty = false;
    protected ISelection currentSelection = StructuredSelection.EMPTY;
    private IActionManager actionMgr;
    ScrolledForm form = null;
    private Button updateOnClick;
    private Button noUpdateOnClick;
    private Button closureButton;
    private Button fixWarningButton;
    private Button refreshButton;
    private Button hideButton;
    private Text elemDespContentText;
    private ConfigurationProperties configProperties;
    private Button hideErrorButton;
    private Button hideWarnButton;
    private Button hideInfoButton;
    private ShowErrorJob showErrorJob = new ShowErrorJob(AuthoringUIResources.Configuration_Problem_Refresh);
    protected ISelectionChangedListener treeSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(final SelectionChangedEvent event) {
            BusyIndicator.showWhile((Display)ConfigurationPage.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object selectedElement = selection.getFirstElement();
                    if ((selectedElement = TngUtil.unwrap((Object)selectedElement)) == null) {
                        return;
                    }
                    if (ConfigurationPage.this.elemDespContentText != null && selectedElement instanceof MethodElement) {
                        String briefDesc = ((MethodElement)selectedElement).getBriefDescription();
                        ConfigurationPage.this.elemDespContentText.setText(briefDesc != null ? briefDesc : "");
                    }
                }
            });
        }
    };
    private static final ClosureListener closureListener = new ClosureListener(){

        public void errorAdded(MethodConfiguration config, IConfigurationError error) {
            IConfigurationManager configMgr = LibraryService.getInstance().getConfigurationManager(config);
            if (configMgr.getConfigurationProperties().toHide(error)) {
                return;
            }
            markerHelper.createMarker(config, error);
        }

        public void errorRemoved(MethodConfiguration config, IConfigurationError error) {
            markerHelper.deleteMarker(config, error);
        }

        public void errorUpdated(MethodConfiguration config, IConfigurationError error) {
            markerHelper.adjustMarker(null, config, error);
        }
    };
    private IPluginUIPackageContextChangedListener layoutListener = new IPluginUIPackageContextChangedListener(){

        public void layoutChanged(boolean isFlat) {
            ConfigurationPage.this.refreshViewers();
        }
    };

    public ConfigurationPage(FormEditor editor) {
        super(editor, AuthoringUIResources.ConfigurationPage_Description1, AuthoringUIResources.ConfigurationPage_Description2);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        this.form.setText(String.valueOf(this.formPrefix) + this.config.getName());
        FormToolkit toolkit = managedForm.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        Section treeSection = toolkit.createSection(this.form.getBody(), 450);
        treeSection.setLayoutData((Object)new TableWrapData(256));
        treeSection.setText(AuthoringUIResources.ConfigurationPage_ConfigContent);
        treeSection.setDescription(AuthoringUIResources.ConfigurationPage_ConfigContentDescription);
        treeSection.setLayout((Layout)new GridLayout());
        this.createContent(toolkit, treeSection);
        this.addListeners();
        this.setInput(LibraryService.getInstance().getCurrentMethodLibrary());
        this.initializeViewersSelection();
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        ConfigurationEditorInput configInput = (ConfigurationEditorInput)input;
        this.config = configInput.getConfiguration();
        this.actionMgr = ((ConfigurationEditor)this.getEditor()).getActionManager();
        this.configProperties = LibraryService.getInstance().getConfigurationManager(this.config).getConfigurationProperties();
    }

    public void createContent(FormToolkit toolkit, Section section) {
        Composite sectionClient = toolkit.createComposite((Composite)section);
        sectionClient.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)sectionClient);
        GridLayout layout = new GridLayout(2, true);
        sectionClient.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)sectionClient.getParent(), AuthoringUIHelpContexts.CONFIGURATION_EDITOR_ALL_CONTEXT);
        Composite buttonComposite = toolkit.createComposite(sectionClient);
        GridLayout gridLayout = new GridLayout(6, false);
        buttonComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)gridData);
        Composite radioComposite = toolkit.createComposite(buttonComposite);
        gridLayout = new GridLayout();
        radioComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        radioComposite.setLayoutData((Object)gridData);
        this.updateOnClick = toolkit.createButton(radioComposite, AuthoringUIResources.ConfigurationPage_updateOnClick, 16);
        this.updateOnClick.setToolTipText(AuthoringUIResources.ConfigurationPage_updateOnClickToolTip);
        this.updateOnClick.setLayoutData((Object)new GridData(1, -1, false, false));
        this.updateOnClick.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.ConfigurationPage_updateOnClickToolTip));
        this.noUpdateOnClick = toolkit.createButton(radioComposite, AuthoringUIResources.ConfigurationPage_noUpdateOnClick, 16);
        this.noUpdateOnClick.setToolTipText(AuthoringUIResources.ConfigurationPage_noUpdateOnClickToolTip);
        this.noUpdateOnClick.setLayoutData((Object)new GridData(1, -1, false, false));
        this.noUpdateOnClick.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.ConfigurationPage_noUpdateOnClickToolTip));
        this.noUpdateOnClick.setSelection(true);
        Group group = new Group(buttonComposite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(-1, -1, false, false);
        group.setLayoutData((Object)data);
        group.setText(AuthoringUIResources.configProblemViewOptionsText);
        this.hideErrorButton = SWTUtil.createCheckbox((Composite)group, (String)AuthoringUIResources.hideErrosText);
        this.hideWarnButton = SWTUtil.createCheckbox((Composite)group, (String)AuthoringUIResources.hideWarningsText);
        this.hideInfoButton = SWTUtil.createCheckbox((Composite)group, (String)AuthoringUIResources.hideInfosText);
        this.hideErrorButton.setSelection(this.configProperties.isHideErrors());
        this.hideWarnButton.setSelection(this.configProperties.isHideWarnings());
        this.hideInfoButton.setSelection(this.configProperties.isHideInfos());
        this.hideButton = toolkit.createButton(buttonComposite, "", 136);
        this.hideButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("hideUncheckedElem.gif"));
        this.hideButton.setToolTipText(AuthoringUIResources.ConfigurationPage_hideToolTip);
        this.hideButton.setLayoutData((Object)new GridData(3));
        this.hideButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.ConfigurationPage_hideToolTip));
        this.fixWarningButton = toolkit.createButton(buttonComposite, "", 8);
        this.fixWarningButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("addref_co.gif"));
        this.fixWarningButton.setToolTipText(AuthoringUIResources.ConfigurationPage_AddMissingToolTip);
        this.fixWarningButton.setLayoutData((Object)new GridData(3));
        this.fixWarningButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.ConfigurationPage_AddMissingToolTip));
        this.closureButton = toolkit.createButton(buttonComposite, "", 8);
        this.closureButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("closure_co.gif"));
        this.closureButton.setToolTipText(AuthoringUIResources.ConfigurationPage_MakeClosureToolTip);
        this.closureButton.setLayoutData((Object)new GridData(3));
        this.closureButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.ConfigurationPage_MakeClosureToolTip));
        this.refreshButton = toolkit.createButton(buttonComposite, "", 8);
        this.refreshButton.setImage(AuthoringUIImages.IMG_REFRESH);
        this.refreshButton.setToolTipText(AuthoringUIResources.refreshButton_text);
        GridData gd = new GridData(131);
        gd.horizontalAlignment = 3;
        gd.horizontalSpan = 1;
        this.refreshButton.setLayoutData((Object)gd);
        this.refreshButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.refreshButton_text));
        this.createViewers(toolkit, sectionClient);
        Label elemDespLabel = toolkit.createLabel(sectionClient, AuthoringUIResources.ConfigurationPage_Description);
        GridData gd1 = new GridData();
        gd1.horizontalSpan = 6;
        elemDespLabel.setLayoutData((Object)gd1);
        this.elemDespContentText = toolkit.createText(sectionClient, "", 74);
        GridData gd2 = new GridData(1808);
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalSpan = 6;
        gd2.heightHint = 50;
        toolkit.paintBordersFor(sectionClient);
        toolkit.paintBordersFor(buttonComposite);
        this.elemDespContentText.setLayoutData((Object)gd2);
        this.configViewer.addSelectionChangedListener(this.treeSelectionListener);
        this.addCategoryViewer.addSelectionChangedListener(this.treeSelectionListener);
        this.subCategoryViewer.addSelectionChangedListener(this.treeSelectionListener);
        this.hideButton.setEnabled(true);
        this.hideButton.setVisible(true);
        this.refreshButton.setEnabled(true);
        this.refreshButton.setVisible(true);
        this.fixWarningButton.setEnabled(true);
        this.fixWarningButton.setVisible(true);
        this.closureButton.setEnabled(true);
        this.closureButton.setVisible(true);
    }

    private void initializeViewersSelection() {
        this.initializeConfigFactory();
        this.initConfigViewer();
        ArrayList addCats = new ArrayList(this.config.getAddedCategory());
        this.initializeViewerSelection(this.addCategoryViewer, addCats);
        ArrayList subCats = new ArrayList(this.config.getSubtractedCategory());
        this.initializeViewerSelection(this.subCategoryViewer, subCats);
    }

    private void initConfigViewer() {
        ArrayList<MethodPackage> packages = new ArrayList<MethodPackage>(this.config.getMethodPackageSelection());
        ArrayList<MethodPlugin> plugins = new ArrayList<MethodPlugin>(this.config.getMethodPluginSelection());
        this.initializeConfigViewerSelection(this.configViewer, packages, plugins);
        this.setStateForCategoriesUIFolder(this.configViewer, plugins);
    }

    private void initializeConfigViewerSelection(ContainerCheckedTreeViewer viewer, List<MethodPackage> packages, List<MethodPlugin> plugins) {
        IContentProvider contProvider;
        viewer.setCheckedElements(packages.toArray());
        viewer.setCheckedElements(new ArrayList().toArray());
        if (!packages.isEmpty()) {
            for (MethodPackage element : packages) {
                try {
                    if (this.contProvider.hasChildren(element)) continue;
                    viewer.setChecked((Object)element, true);
                }
                catch (Exception exception) {}
            }
        }
        if ((contProvider = viewer.getContentProvider()) instanceof ConfigPackageContentProvider) {
            ConfigPackageContentProvider configContProvider = (ConfigPackageContentProvider)contProvider;
            for (MethodPlugin plugin : plugins) {
                Object[] children = configContProvider.getChildren(plugin);
                this.traverse(viewer, children, configContProvider);
            }
        }
    }

    private void traverse(ContainerCheckedTreeViewer viewer, Object[] items, ConfigPackageContentProvider configContProvider) {
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            Object[] children = configContProvider.getChildren(child);
            if (child instanceof MethodPackagesItemProvider) {
                if (children.length != 0) break;
                viewer.setChecked(child, true);
                break;
            }
            if (child instanceof ContentItemProvider) {
                this.traverse(viewer, children, configContProvider);
            }
            ++n2;
        }
    }

    private void setStateForCategoriesUIFolder(ContainerCheckedTreeViewer viewer, List<MethodPlugin> plugins) {
        for (MethodPlugin plugin : plugins) {
            TreeItem[] items;
            int n;
            if (viewer.getGrayed((Object)plugin)) {
                try {
                    Object[] children;
                    Object[] objectArray = children = this.contProvider.getChildren(plugin);
                    n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (child instanceof ConfigPageCategoriesItemProvider) {
                            viewer.setChecked(child, true);
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {}
            }
            Tree t = viewer.getTree();
            TreeItem[] treeItemArray = items = t.getItems();
            int n3 = items.length;
            n = 0;
            while (n < n3) {
                TreeItem parent = treeItemArray[n];
                if (parent.getData().equals(plugin)) {
                    TreeItem[] childItems;
                    TreeItem[] treeItemArray2 = childItems = parent.getItems();
                    int n4 = childItems.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        TreeItem child = treeItemArray2[n5];
                        if (child.getData() instanceof ConfigPageCategoriesItemProvider) {
                            if (viewer.getChecked((Object)plugin)) {
                                child.setForeground(ColorConstants.gray);
                            } else {
                                child.setForeground(ColorConstants.black);
                            }
                        }
                        ++n5;
                    }
                }
                ++n;
            }
        }
    }

    private void initializeViewerSelection(ContainerCheckedTreeViewer viewer, List<? extends Object> elements) {
        if (!elements.isEmpty()) {
            viewer.setCheckedElements(elements.toArray());
        }
    }

    private void createViewers(FormToolkit toolkit, Composite sectionClient) {
        Composite configViewerLabelComposite = toolkit.createComposite(sectionClient);
        GridData gd = new GridData(4, 0x1000008, true, false);
        configViewerLabelComposite.setLayoutData((Object)gd);
        gd.horizontalSpan = 1;
        configViewerLabelComposite.setLayout((Layout)new GridLayout(3, false));
        Composite addCatsViewerLabelComposite = toolkit.createComposite(sectionClient);
        gd = new GridData(4, 0x1000008, true, false);
        addCatsViewerLabelComposite.setLayoutData((Object)gd);
        gd.horizontalSpan = 1;
        addCatsViewerLabelComposite.setLayout((Layout)new GridLayout(3, false));
        this.configViewer = new MethodContainerCheckedTreeViewer(sectionClient);
        gd = new GridData(1808);
        gd.heightHint = 200;
        gd.verticalSpan = 3;
        this.configViewer.getTree().setLayoutData((Object)gd);
        this.contProvider = new ConfigPackageContentProvider((AdapterFactory)this.adapterFactory);
        this.configViewer.setContentProvider((IContentProvider)this.contProvider);
        this.labelProvider = new ConfigPackageLabelProvider(this.contProvider);
        this.configViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.createViewerLabelAndButtons(toolkit, configViewerLabelComposite, AuthoringUIResources.ConfigurationPage_TreeTitleLabel, (TreeViewer)this.configViewer);
        this.addCategoryViewer = new MethodContainerCheckedTreeViewer2(sectionClient);
        gd = new GridData(1808);
        gd.heightHint = 200;
        this.addCategoryViewer.getTree().setLayoutData((Object)gd);
        this.addCategoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider((AdapterFactory)this.adapterFactory, this.config));
        this.addCategoryViewer.setLabelProvider((IBaseLabelProvider)new CategoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.createViewerLabelAndButtons(toolkit, addCatsViewerLabelComposite, AuthoringUIResources.ConfigurationPage_AddCategoriesTitleLabel, (TreeViewer)this.addCategoryViewer);
        Composite subCatsViewerLabelComposite = toolkit.createComposite(sectionClient);
        gd = new GridData(4, 0x1000008, true, false);
        subCatsViewerLabelComposite.setLayoutData((Object)gd);
        gd.horizontalSpan = 1;
        subCatsViewerLabelComposite.setLayout((Layout)new GridLayout(3, false));
        this.subCategoryViewer = new MethodContainerCheckedTreeViewer2(sectionClient);
        gd = new GridData(1808);
        gd.heightHint = 200;
        this.subCategoryViewer.getTree().setLayoutData((Object)gd);
        this.subCategoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider((AdapterFactory)this.adapterFactory, this.config));
        this.subCategoryViewer.setLabelProvider((IBaseLabelProvider)new CategoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.createViewerLabelAndButtons(toolkit, subCatsViewerLabelComposite, AuthoringUIResources.ConfigurationPage_SubCategoriesTitleLabel, (TreeViewer)this.subCategoryViewer);
        this.addCategoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(final CheckStateChangedEvent event) {
                BusyIndicator.showWhile((Display)ConfigurationPage.this.subCategoryViewer.getTree().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        if (event.getChecked()) {
                            ConfigurationPage.this.subCategoryViewer.setChecked(event.getElement(), false);
                        }
                    }
                });
            }
        });
        this.subCategoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(final CheckStateChangedEvent event) {
                BusyIndicator.showWhile((Display)ConfigurationPage.this.addCategoryViewer.getTree().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        if (event.getChecked()) {
                            ConfigurationPage.this.addCategoryViewer.setChecked(event.getElement(), false);
                        }
                    }
                });
            }
        });
    }

    private void createViewerLabelAndButtons(FormToolkit toolkit, Composite parent, String text, final TreeViewer viewer) {
        Label label = toolkit.createLabel(parent, text);
        GridData gd = new GridData(4, 0x1000008, true, false);
        label.setLayoutData((Object)gd);
        Button expandButton = toolkit.createButton(parent, null, 8);
        gd = new GridData(131072, 0x1000008, false, false);
        expandButton.setLayoutData((Object)gd);
        expandButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("expandall.gif"));
        expandButton.setToolTipText(AuthoringUIResources.FilterDialog_ExpandAll);
        expandButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.FilterDialog_ExpandAll));
        expandButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                viewer.expandAll();
            }
        });
        Button collapseButton = toolkit.createButton(parent, null, 8);
        gd = new GridData(131072, 0x1000008, false, false);
        collapseButton.setLayoutData((Object)gd);
        collapseButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("collapseall.gif"));
        collapseButton.setToolTipText(AuthoringUIResources.FilterDialog_CollapseAll);
        collapseButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.FilterDialog_CollapseAll));
        collapseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                viewer.collapseAll();
            }
        });
    }

    private void reInitializeConfigFactory() {
        this.createConfigurationClosure();
    }

    private void createConfigurationClosure() {
        this.closure = new ConfigurationClosure(this.actionMgr, this.config);
        this.closure.addListener(closureListener);
        if (this.labelProvider != null) {
            this.labelProvider.setClosure(this.closure);
        }
    }

    private void setInput(Object input) {
        this.configViewer.setInput(input);
        this.addCategoryViewer.setInput(input);
        this.subCategoryViewer.setInput(input);
        this.configViewer.expandAll();
        this.configViewer.collapseAll();
        this.addCategoryViewer.expandAll();
        this.addCategoryViewer.collapseAll();
        this.subCategoryViewer.expandAll();
        this.subCategoryViewer.collapseAll();
    }

    private void refreshViewers() {
        this.configViewer.refresh();
        this.addCategoryViewer.refresh();
        this.subCategoryViewer.refresh();
    }

    protected void showHideElements() {
        this.configViewerHideUncheckedFilter.toggleHideUnchecked();
        this.addCategoryHideUncheckedFilter.toggleHideUnchecked();
        this.subCategoryHideUncheckedFilter.toggleHideUnchecked();
        this.refreshViewers();
    }

    public void initializeConfigFactory() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ConfigurationPage.this.createConfigurationClosure();
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)runnable, (String)AuthoringUIResources.ConfigurationPage_LoadingMessage);
        this.configViewerHideUncheckedFilter = new HideUncheckedViewerFilter(this.configViewer);
        this.configViewer.addFilter(this.configViewerHideUncheckedFilter);
        this.addCategoryHideUncheckedFilter = new HideUncheckedViewerFilter(this.addCategoryViewer);
        this.addCategoryViewer.addFilter(this.addCategoryHideUncheckedFilter);
        this.subCategoryHideUncheckedFilter = new HideUncheckedViewerFilter(this.subCategoryViewer);
        this.subCategoryViewer.addFilter(this.subCategoryHideUncheckedFilter);
    }

    private void addListeners() {
        this.hideErrorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationPage.this.handleHidesButtonWidgetSelected(e, "hide_errors");
            }
        });
        this.hideWarnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationPage.this.handleHidesButtonWidgetSelected(e, "hide_warnings");
            }
        });
        this.hideInfoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationPage.this.handleHidesButtonWidgetSelected(e, "hide_infos");
            }
        });
        this.closureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BusyIndicator.showWhile((Display)ConfigurationPage.this.form.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ConfigurationPage.this.makeClosure();
                    }
                });
            }
        });
        this.fixWarningButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BusyIndicator.showWhile((Display)ConfigurationPage.this.form.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ConfigurationPage.this.fixWarning();
                    }
                });
            }
        });
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)ConfigurationPage.this.form.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ConfigurationPage.this.saveConfiguration();
                        ConfigurationPage.this.showErrors();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.hideButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationPage.this.showHideElements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ICheckStateListener configCheckStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent evt) {
                BusyIndicator.showWhile((Display)ConfigurationPage.this.form.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ConfigurationPage.this.saveConfiguration();
                        if (ConfigurationPage.this.updateOnClick.getSelection()) {
                            ConfigurationPage.this.showErrors();
                        }
                        ConfigurationPage.this.actionMgr.execute((IResourceAwareCommand)new MethodElementSetPropertyCommand((MethodElement)ConfigurationPage.this.config, ConfigurationPage.TOUCHED_BY_CONFIG_EDITOR, Boolean.TRUE.toString()));
                    }
                });
            }
        };
        ICheckStateListener catsCheckStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                BusyIndicator.showWhile((Display)ConfigurationPage.this.form.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ConfigurationPage.this.saveContentCategorySelectionsToConfiguration();
                        ConfigurationPage.this.showErrors();
                    }
                });
            }
        };
        this.configViewer.addCheckStateListener(configCheckStateListener);
        this.addCategoryViewer.addCheckStateListener(catsCheckStateListener);
        this.subCategoryViewer.addCheckStateListener(catsCheckStateListener);
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection<Object> changedItems) {
                Object o;
                if ((option == 16 || option == 32 || option == 32) && changedItems != null && changedItems.size() > 0 && ((o = changedItems.toArray()[0]) instanceof MethodPlugin || o instanceof ProcessComponent || o instanceof MethodPackage || o instanceof CustomCategory)) {
                    ConfigurationPage.this.reInitializeConfigFactory();
                    ConfigurationPage.this.refreshViewers();
                    ConfigurationPage.this.showErrors();
                }
            }
        };
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.addListener(this.libListener);
        }
        PluginUIPackageContext.INSTANCE.addListener(this.layoutListener);
    }

    protected void showErrors() {
        if (this.closure.isAbortCheckError()) {
            return;
        }
        if (this.showErrorJob.getState() == 4) {
            this.closure.setAbortCheckError(true);
        }
        if (!this.showErrorJob.cancel()) {
            try {
                this.showErrorJob.join();
            }
            catch (Exception exception) {}
        }
        this.closure.setAbortCheckError(false);
        this.showErrorJob.schedule();
    }

    protected void showErrors_old() {
        List invalid = this.closure.getInvalidElements();
        this.closure.checkError();
        if (this.configViewerHideUncheckedFilter.isHideUnchecked()) {
            this.configViewer.refresh();
        } else {
            invalid.addAll(this.closure.getInvalidElements());
            ConfigPackageContentProvider cp = (ConfigPackageContentProvider)this.configViewer.getContentProvider();
            invalid.addAll(cp.getUIElements());
            this.configViewer.update(invalid.toArray(), null);
        }
    }

    protected void makeClosure() {
        this.closure.fixErrors();
        this.configViewer.refresh();
        this.initConfigViewer();
    }

    protected void fixWarning() {
        this.closure.fixProblems();
        this.configViewer.refresh();
        this.initConfigViewer();
    }

    public boolean saveConfiguration() {
        ConfigurationData configData = LibraryService.getInstance().getConfigurationManager(this.config).getConfigurationData();
        configData.setEnableUpdate(false);
        boolean ret = this.doSaveConfiguration();
        configData.setEnableUpdate(true);
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doSaveConfiguration() {
        boolean oldNotify = this.config.eDeliver();
        try {
            ArrayList oldPackages = new ArrayList(this.config.getMethodPackageSelection());
            ArrayList oldPlugins = new ArrayList(this.config.getMethodPluginSelection());
            Set<MethodPackage> newPackages = this.getCheckedMethodPackages(this.configViewer.getCheckedElements());
            Set<MethodPlugin> newPlugins = this.getCheckedMethodPlugins(this.configViewer.getCheckedElements());
            ArrayList<MethodPlugin> plugins = new ArrayList<MethodPlugin>();
            plugins.addAll(newPlugins);
            plugins.addAll(oldPlugins);
            this.setStateForCategoriesUIFolder(this.configViewer, plugins);
            oldPackages.removeAll(newPackages);
            oldPlugins.removeAll(newPlugins);
            newPackages.removeAll(this.config.getMethodPackageSelection());
            newPlugins.removeAll(this.config.getMethodPluginSelection());
            if (!ConfigurationUtil.removeCollFromMethodPluginList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, oldPlugins)) {
                return false;
            }
            if (!ConfigurationUtil.removeCollFromMethodPackageList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, oldPackages)) {
                return false;
            }
            if (!ConfigurationUtil.addCollToMethodPluginList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, newPlugins)) {
                return false;
            }
            if (!ConfigurationUtil.addCollToMethodPackageList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, newPackages)) {
                return false;
            }
            LibraryUtil.validateMethodConfiguration((IActionManager)this.actionMgr, (MethodConfiguration)this.config);
            this.actionMgr.execute((IResourceAwareCommand)new MethodElementSetPropertyCommand((MethodElement)this.config, TOUCHED_BY_CONFIG_EDITOR, Boolean.TRUE.toString()));
            return true;
        }
        finally {
            this.config.eSetDeliver(oldNotify);
        }
    }

    public boolean saveContentCategorySelectionsToConfiguration() {
        ArrayList oldAddCats = new ArrayList(this.config.getAddedCategory());
        ArrayList oldSubCats = new ArrayList(this.config.getSubtractedCategory());
        Set<ContentCategory> newAddCats = this.getCheckedContentCategories(this.addCategoryViewer.getCheckButNotGrayedElements());
        Set<ContentCategory> newSubCats = this.getCheckedContentCategories(this.subCategoryViewer.getCheckButNotGrayedElements());
        oldAddCats.removeAll(newAddCats);
        oldSubCats.removeAll(newSubCats);
        newAddCats.removeAll(this.config.getAddedCategory());
        newSubCats.removeAll(this.config.getSubtractedCategory());
        if (!ConfigurationUtil.removeCollFromAddedCategoryList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, oldAddCats)) {
            return false;
        }
        if (!newAddCats.isEmpty()) {
            if (!ConfigurationUtil.addCollToAddedCategoryList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, newAddCats)) {
                return false;
            }
            Map pluginMap = MethodElementUtil.buildMap((Collection)this.config.getMethodPluginSelection());
            HashSet<MethodPlugin> newAddedPlugins = new HashSet<MethodPlugin>();
            for (ContentCategory cat : newAddCats) {
                MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)cat);
                if (pluginMap.containsKey(plugin.getGuid()) || newAddedPlugins.contains(plugin)) continue;
                newAddedPlugins.add(plugin);
            }
            if (!newAddedPlugins.isEmpty()) {
                if (!ConfigurationUtil.addCollToMethodPluginList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, newAddedPlugins)) {
                    return false;
                }
                LibraryUtil.validateMethodConfiguration((IActionManager)this.actionMgr, (MethodConfiguration)this.config);
            }
        }
        if (!ConfigurationUtil.removeCollFromSubtractedCategoryList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, oldSubCats)) {
            return false;
        }
        if (!ConfigurationUtil.addCollToSubtractedCategoryList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, newSubCats)) {
            return false;
        }
        this.actionMgr.execute((IResourceAwareCommand)new MethodElementSetPropertyCommand((MethodElement)this.config, TOUCHED_BY_CONFIG_EDITOR, Boolean.TRUE.toString()));
        return true;
    }

    protected Set<ContentCategory> getCheckedContentCategories(Object[] checkedItems) {
        HashSet<ContentCategory> result = new HashSet<ContentCategory>();
        int i = 0;
        while (i < checkedItems.length) {
            Object item = TngUtil.unwrap((Object)checkedItems[i]);
            if (item instanceof ContentCategory) {
                result.add((ContentCategory)item);
            }
            ++i;
        }
        return result;
    }

    protected Set<MethodPackage> getCheckedMethodPackages(Object[] checkedItems) {
        HashSet<MethodPackage> result = new HashSet<MethodPackage>();
        int i = 0;
        while (i < checkedItems.length) {
            Object item = TngUtil.unwrap((Object)checkedItems[i]);
            if (item instanceof MethodPackage) {
                result.add((MethodPackage)item);
            }
            ++i;
        }
        return result;
    }

    protected Set<MethodPlugin> getCheckedMethodPlugins(Object[] checkedItems) {
        HashSet<MethodPlugin> result = new HashSet<MethodPlugin>();
        int i = 0;
        while (i < checkedItems.length) {
            Object item = TngUtil.unwrap((Object)checkedItems[i]);
            if (item instanceof MethodPlugin) {
                result.add((MethodPlugin)item);
            }
            ++i;
        }
        return result;
    }

    public void dispose() {
        ILibraryManager manager;
        super.dispose();
        if (this.libListener != null && (manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            manager.removeListener(this.libListener);
        }
        if (this.layoutListener != null) {
            PluginUIPackageContext.INSTANCE.removeListener(this.layoutListener);
        }
        if (this.closure != null) {
            this.closure.dispose();
            this.closure = null;
        }
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
            this.adapterFactory = null;
        }
    }

    public void gotoMarker(IMarker marker) {
        MethodElement e = ConfigurationMarkerHelper.INSTANCE.getErrorMethodElement(marker);
        if (e != null && this.configViewer != null) {
            this.configViewer.setSelection((ISelection)new StructuredSelection((Object)LibraryUtil.getSelectable((EObject)e)), true);
        }
    }

    public void doQuickFix(IMarker marker) {
        if (marker == null) {
            return;
        }
        MethodElement element = markerHelper.getCauseMethodElement(marker);
        if (element == null) {
            return;
        }
        if (this.closure.getConfigurationManager().getConfigurationData().isElementInSubtractedCategory(element)) {
            String message = AuthoringUIResources.bind((String)AuthoringUIResources.configurationPage_QuickfixError_reason1, (Object[])new String[]{LibraryUtil.getTypeName((MethodElement)element)});
            AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AuthoringUIResources.configurationPage_quickfixError_title, message);
            return;
        }
        EObject owner = LibraryUtil.getSelectable((EObject)element);
        this.configViewer.setChecked(owner, true);
        this.saveConfiguration();
        this.showErrors();
    }

    private void handleHidesButtonWidgetSelected(SelectionEvent e, String key) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button button = (Button)obj;
            String value = button.getSelection() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
            this.actionMgr.execute((IResourceAwareCommand)new MethodElementSetPropertyCommand((MethodElement)this.config, key, value));
        }
    }

    class ShowErrorJob
    extends Job {
        public ShowErrorJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            final List invalid = ConfigurationPage.this.closure.getInvalidElements();
            ConfigurationPage.this.closure.checkError();
            if (ConfigurationPage.this.closure.isAbortCheckError()) {
                return Status.OK_STATUS;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ConfigurationPage.this.configViewerHideUncheckedFilter.isHideUnchecked()) {
                        ConfigurationPage.this.configViewer.refresh();
                    } else {
                        invalid.addAll(ConfigurationPage.this.closure.getInvalidElements());
                        ConfigPackageContentProvider cp = (ConfigPackageContentProvider)ConfigurationPage.this.configViewer.getContentProvider();
                        invalid.addAll(cp.getUIElements());
                        ConfigurationPage.this.configViewer.update(invalid.toArray(), null);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

