/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class AuthoringUIPreferences {
    public static final String ENABLE_LIBRARY_VALIDATION = "enabledLibraryValidation";
    public static final String ENABLE_UI_FIELDS = "enableUIFields";
    public static final String ADD_TASKS_PER_ROW = "ACTIVITY_DETAIL_DIAGRAM_TASKS_PER_ROW";
    private static final int DEFAULT_ADD_TASKS_PER_ROW = 10;
    private static final boolean DEFAULT_ENABLE_LIBRARY_VALIDATION = false;
    private static final boolean DEFAULT_ENABLE_UI_FIELDS = false;
    private static IPreferenceStore prefStore = AuthoringUIPlugin.getDefault().getPreferenceStore();

    static {
        prefStore.setDefault(ENABLE_LIBRARY_VALIDATION, false);
        prefStore.setDefault(ENABLE_UI_FIELDS, false);
        prefStore.setDefault(ADD_TASKS_PER_ROW, 10);
    }

    public static boolean getDefaultEnableLibraryValidation() {
        return false;
    }

    public static boolean getEnableLibraryValidation() {
        return prefStore.getBoolean(ENABLE_LIBRARY_VALIDATION);
    }

    public static void setEnableLibraryValidation(boolean value) {
        prefStore.setValue(ENABLE_LIBRARY_VALIDATION, value);
    }

    public static boolean getDefaultEnableUIFields() {
        return false;
    }

    public static boolean getEnableUIFields() {
        return prefStore.getBoolean(ENABLE_UI_FIELDS);
    }

    public static void setEnableUIFields(boolean value) {
        prefStore.setValue(ENABLE_UI_FIELDS, value);
    }

    public static int getADD_TasksPerRow() {
        int value = prefStore.getInt(ADD_TASKS_PER_ROW);
        return value > 0 ? value : 10;
    }

    public static void setADDTasksPerRow(int value) {
        prefStore.setValue(ADD_TASKS_PER_ROW, value);
    }

    public static int getDefaultADDTasksPerRow() {
        return 10;
    }
}

