/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshHandler
implements IRefreshHandler {
    private ViewPart view;

    public RefreshHandler(ViewPart view) {
        this.view = view;
    }

    private Control getControl() {
        Viewer viewer;
        if (this.view instanceof IViewerProvider && (viewer = ((IViewerProvider)this.view).getViewer()) != null) {
            return viewer.getControl();
        }
        return null;
    }

    public void refresh(IProgressMonitor monitor) {
        Control ctrl = this.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.doRefresh(this.view.getSite().getShell());
        } else {
            ctrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    RefreshHandler.this.doRefresh(null);
                }
            });
        }
    }

    private void doRefresh(Shell shell) {
        boolean refreshViews = !RefreshJob.getInstance().getReloadedBeforeRefreshResources().isEmpty() || !RefreshJob.getInstance().getAddedResources().isEmpty();
        ArrayList<Resource> removedResources = new ArrayList<Resource>(RefreshJob.getInstance().getRemovedResources());
        ArrayList<Resource> changedResources = new ArrayList<Resource>(RefreshJob.getInstance().getChangedResources());
        ArrayList<IResource> addedWsResources = new ArrayList<IResource>(RefreshJob.getInstance().getAddedWorkspaceResources());
        if (!removedResources.isEmpty() || !changedResources.isEmpty() || !addedWsResources.isEmpty() || refreshViews) {
            this.blockingRefresh(removedResources, changedResources, addedWsResources, shell);
        }
        if (!removedResources.isEmpty()) {
            RefreshJob.getInstance().getRemovedResources().removeAll(removedResources);
        }
        if (!changedResources.isEmpty()) {
            RefreshJob.getInstance().getChangedResources().removeAll(changedResources);
        }
        if (!addedWsResources.isEmpty()) {
            RefreshJob.getInstance().getAddedWorkspaceResources().removeAll(addedWsResources);
        }
        if (refreshViews) {
            RefreshJob.getInstance().getReloadedBeforeRefreshResources().clear();
            RefreshJob.getInstance().getAddedResources().clear();
        }
    }

    private void blockingRefresh(final ArrayList<Resource> removedResources, final ArrayList<Resource> changedResources, final Collection<IResource> addedWorkspaceResources, Shell shell) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", -1);
                monitor.subTask(AuthoringUIResources._UI_RefreshViewer_menu_item);
                monitor.worked(1);
                try {
                    RefreshHandler.this.doRefresh(removedResources, changedResources, addedWorkspaceResources);
                }
                finally {
                    monitor.done();
                }
            }
        };
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        try {
            this.view.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, (ISchedulingRule)new LibrarySchedulingRule(LibraryService.getInstance().getCurrentMethodLibrary()));
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            String title = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.toString(), (Throwable)e);
        }
    }

    private synchronized void doRefresh(Collection<Resource> removedResources, Collection<Resource> changedResources, Collection<IResource> addedWorkspaceResources) {
        ResourceSet resourceSet;
        ILibraryManager mgr;
        HashSet<IEditorPart> editorsToRefresh = new HashSet<IEditorPart>();
        if (!removedResources.isEmpty()) {
            this.handleRemovedResources(removedResources, editorsToRefresh);
        }
        if (!changedResources.isEmpty()) {
            this.handleChangedResources(changedResources, editorsToRefresh);
        }
        if (addedWorkspaceResources != null && !addedWorkspaceResources.isEmpty() && (mgr = LibraryService.getInstance().getCurrentLibraryManager()) != null && (resourceSet = mgr.getEditingDomain().getResourceSet()) instanceof MultiFileResourceSetImpl) {
            ((MultiFileResourceSetImpl)resourceSet).loadNewResources(addedWorkspaceResources);
            ((MultiFileResourceSetImpl)resourceSet).getUnresolvedProxyMarkerManager().validateAllMarkers();
        }
    }

    private Collection<Resource> handleChangedResources(Collection<Resource> changedResources, Collection<IEditorPart> editorsToRefresh) {
        return this.handleChangedResources(changedResources, null, editorsToRefresh);
    }

    private Collection<Resource> handleRemovedResources(Collection<Resource> removedResources, Collection<IEditorPart> editorsToRefresh) {
        IEditorPart editor;
        IEditorReference reference;
        IWorkbenchPage workbenchPage = this.view.getSite().getPage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorPart> dirtyEditorsWithConflict = new ArrayList<IEditorPart>();
        ArrayList<Resource> removedResourceList = new ArrayList<Resource>(removedResources);
        if (editorsToRefresh == null) {
            editorsToRefresh = new ArrayList<IEditorPart>();
        }
        int i = 0;
        while (i < editorReferences.length) {
            reference = editorReferences[i];
            editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && editor.isDirty()) {
                Resource resource;
                MethodElementEditorInput input = (MethodElementEditorInput)editor.getEditorInput();
                Resource resource2 = resource = input.getMethodElement() != null ? input.getMethodElement().eResource() : null;
                if (!removedResources.contains(resource)) {
                    Collection<Resource> usedResources = ((MethodElementEditor)editor).getUsedResources();
                    int j = 0;
                    while (j < removedResourceList.size()) {
                        resource = removedResourceList.get(j);
                        if (usedResources.contains(resource)) {
                            dirtyEditorsWithConflict.add(editor);
                            break;
                        }
                        ++j;
                    }
                } else {
                    editorsToRefresh.add(editor);
                }
            }
            ++i;
        }
        if (!dirtyEditorsWithConflict.isEmpty()) {
            Object[] selected = this.selectDirtyEditors(dirtyEditorsWithConflict);
            int i2 = 0;
            while (i2 < selected.length) {
                editorsToRefresh.add((IEditorPart)selected[i2]);
                ++i2;
            }
        }
        PersistenceUtil.unload(removedResources);
        i = 0;
        while (i < editorReferences.length) {
            reference = editorReferences[i];
            editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && !editor.isDirty()) {
                Collection<Resource> usedResources = ((MethodElementEditor)editor).getUsedResources();
                int j = 0;
                while (j < removedResourceList.size()) {
                    Resource resource = removedResourceList.get(j);
                    if (usedResources.contains(resource)) {
                        editorsToRefresh.add(editor);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return removedResources;
    }

    public Collection<Resource> handleChangedResources(Collection<Resource> changedResources, Collection<IEditorPart> editorsNotToRefresh, Collection<IEditorPart> editorsToRefresh) {
        ILibraryManager manager;
        Collection<Resource> usedResources;
        Object editor;
        Control ctrl = this.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return Collections.emptyList();
        }
        IWorkbenchPage workbenchPage = this.view.getSite().getPage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorPart> dirtyEditorsWithConflict = new ArrayList<IEditorPart>();
        ArrayList<Resource> changedResourceList = new ArrayList<Resource>(changedResources);
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && editor.isDirty()) {
                usedResources = ((MethodElementEditor)((Object)editor)).getUsedResources();
                int j = 0;
                while (j < changedResourceList.size()) {
                    Resource resource = changedResourceList.get(j);
                    if (usedResources.contains(resource)) {
                        dirtyEditorsWithConflict.add((IEditorPart)editor);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!dirtyEditorsWithConflict.isEmpty()) {
            Object[] result = this.selectDirtyEditors(dirtyEditorsWithConflict);
            if (result != null) {
                int i2 = 0;
                while (i2 < result.length) {
                    editor = result[i2];
                    if (!(editorsNotToRefresh != null && editorsNotToRefresh.contains(editor) || editorsToRefresh != null && editorsToRefresh.contains(editor))) {
                        dirtyEditorsWithConflict.remove(editor);
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < dirtyEditorsWithConflict.size()) {
                editor = (MethodElementEditor)dirtyEditorsWithConflict.get(i3);
                usedResources = ((MethodElementEditor)((Object)editor)).getUsedResources();
                usedResources.retainAll(changedResourceList);
                ((MethodElementEditor)((Object)editor)).updateResourceInfos(usedResources);
                ((MethodElementEditor)((Object)editor)).ovewriteResources(usedResources);
                changedResourceList.removeAll(usedResources);
                ++i3;
            }
        }
        if (!changedResourceList.isEmpty() && (manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            manager.reloadResources(changedResourceList);
        }
        return changedResourceList;
    }

    private Object[] selectDirtyEditors(ArrayList<IEditorPart> dirtyEditorsWithConflict) {
        return RefreshHandler.selectDirtyEditors(dirtyEditorsWithConflict, this.view.getSite().getShell());
    }

    public static Object[] selectDirtyEditors(List<?> dirtyEditors, Shell shell) {
        String title = AuthoringUIResources._UI_FileConflict_label;
        String msg = AuthoringUIResources.selectEditorsToDiscardConflictChanges;
        return RefreshHandler.selectEditors(dirtyEditors, title, msg, shell);
    }

    private static Object[] selectEditors(List<?> editors, String title, String msg, Shell shell) {
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
            List<?> fContents;

            public Object[] getElements(Object inputElement) {
                if (this.fContents != null && this.fContents == inputElement) {
                    return this.fContents.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.fContents = newInput instanceof List ? (List)newInput : null;
            }
        };
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IEditorPart) {
                    return ((IEditorPart)element).getTitle();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IEditorPart) {
                    return ((IEditorPart)element).getTitleImage();
                }
                return super.getImage(element);
            }
        };
        ListSelectionDialog dlg = new ListSelectionDialog(shell, editors, contentProvider, (ILabelProvider)labelProvider, msg);
        dlg.setTitle(title);
        dlg.setBlockOnOpen(true);
        dlg.open();
        return dlg.getResult();
    }
}

