/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ElementHTMLViewer {
    protected Browser browser = null;
    protected Composite parent;
    private String currentLocation = null;
    private String currentText = null;
    private HtmlBuilder htmlBuilder;
    private Cursor waitCursor = null;

    public ElementHTMLViewer(Composite parent) {
        this.parent = parent;
        this.htmlBuilder = new HtmlBuilder();
        this.createControl();
    }

    private void createControl() {
        try {
            this.browser = new Browser(this.parent, 0);
            this.browser.setLayoutData((Object)new GridData(1808));
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent e) {
                }

                public void changing(LocationEvent e) {
                    String location = ElementHTMLViewer.this.getElementUrl(e.location);
                    if (location == null || location.startsWith("javascript:")) {
                        return;
                    }
                    if (ElementHTMLViewer.this.isLocationChanged(location)) {
                        ElementHTMLViewer.this.currentLocation = location;
                        ElementHTMLViewer.this.generateHtml(ElementHTMLViewer.this.currentLocation);
                    }
                }
            });
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    String text = event.text;
                    if (text != null && text.length() > 0) {
                        ElementHTMLViewer.this.currentText = text;
                    }
                }
            });
            this.browser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    if (SWT.getPlatform().equals("win32")) {
                        return;
                    }
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                Shell shell = new Shell();
                                GridLayout layout = new GridLayout();
                                layout.marginHeight = 0;
                                layout.marginWidth = 0;
                                shell.setLayout((Layout)layout);
                                Browser popup_browser = new Browser((Composite)shell, 0);
                                popup_browser.setLayoutData((Object)new GridData(1808));
                                popup_browser.setUrl(ElementHTMLViewer.this.currentText);
                                shell.open();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            });
            this.waitCursor = this.parent.getShell().getDisplay().getSystemCursor(1);
        }
        catch (Exception e) {
            this.browser = null;
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private boolean isLocationChanged(String location) {
        if (location == null || this.currentLocation == null) {
            return false;
        }
        if (File.separatorChar != '/') {
            location = location.replace(File.separatorChar, '/');
            String oldLocation = this.getUrl(this.currentLocation);
            return oldLocation.indexOf(location) != 0;
        }
        return !location.endsWith(this.currentLocation) && !this.currentLocation.endsWith(location);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public HtmlBuilder getHtmlBuilder() {
        if (this.htmlBuilder != null) {
            BrowsingLayoutSettings.INSTANCE.update(this.htmlBuilder);
        }
        return this.htmlBuilder;
    }

    public void setHtmlBuilder(HtmlBuilder builder) {
        this.htmlBuilder = builder;
    }

    public void setLayoutManager(ElementLayoutManager layoutMgr) {
        this.htmlBuilder.setLayoutManager(layoutMgr);
    }

    public void showElementContent(Object raw_element) {
        this.startWait();
        try {
            String file_url;
            this.currentLocation = file_url = this.generateHtml(raw_element, this.getHtmlBuilder());
            this.browser.setUrl(file_url);
        }
        catch (RuntimeException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        this.endWait();
    }

    private String generateHtml(Object raw_element, HtmlBuilder htmlBuilder) {
        return ConfigurationHelper.getDelegate().generateHtml(raw_element, htmlBuilder);
    }

    private void generateHtml(String url) {
        this.startWait();
        try {
            this.getHtmlBuilder().generateHtml(url);
        }
        catch (RuntimeException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        this.endWait();
    }

    private String getElementUrl(String location) {
        if (location == null || location.length() == 0 || location.equals("about:blank") || location.toLowerCase().startsWith("javascript:")) {
            return null;
        }
        if ((location = this.getUrl(location)).indexOf("pages_not_installed/") >= 0) {
            return null;
        }
        if (ResourceHelper.getGuidFromFileName((String)location) == null) {
            return null;
        }
        return location;
    }

    private String getUrl(String location) {
        String publish_dir = this.getHtmlBuilder().getPublishDir();
        String url = this.fixPath(location);
        int index = url.toLowerCase().indexOf(this.fixPath(publish_dir).toLowerCase());
        if (index >= 0) {
            url = url.substring(index + publish_dir.length());
        }
        if ((index = url.indexOf("#")) > 0) {
            url = url.substring(0, index);
        }
        return url;
    }

    private String fixPath(String path) {
        try {
            String platform = SWT.getPlatform();
            path = "win32".equals(platform) || "wpf".equals(platform) ? URLDecoder.decode(path, "ISO-8859-1") : URLDecoder.decode(path, "UTF-8");
            if (File.separatorChar != '/') {
                return path.replace(File.separatorChar, '/');
            }
            return path;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public void print() {
        this.browser.execute("window.print();");
    }

    private void startWait() {
        this.parent.getShell().setCursor(this.waitCursor);
    }

    private void endWait() {
        this.parent.getShell().setCursor(null);
    }

    public void refresh() {
        this.generateHtml(this.currentLocation);
        this.browser.refresh();
    }
}

