/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NewConfigurationMainPage
extends BaseWizardPage {
    public static final String PAGE_NAME = NewConfigurationMainPage.class.getName();
    protected Composite composite;
    protected Text nameText;
    protected Text briefDescText;

    public NewConfigurationMainPage(String pageName) {
        super(pageName);
        this.setTitle(AuthoringUIResources.AuthoringUIPlugin_NewConfigurationMainPage_pageTitle);
        this.setDescription(AuthoringUIResources.AuthoringUIPlugin_NewConfigurationMainPage_pageDescription);
        this.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
    }

    public NewConfigurationMainPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite parent) {
        this.composite = NewConfigurationMainPage.createGridLayoutComposite((Composite)parent, (int)3);
        NewConfigurationMainPage.createVerticallyAlignedLabel((Composite)this.composite, (String)AuthoringUIText.NAME_TEXT);
        this.nameText = NewConfigurationMainPage.createEditableText((Composite)this.composite, (int)2);
        NewConfigurationMainPage.createVerticallyAlignedLabel((Composite)this.composite, (String)AuthoringUIText.DESCRIPTION_TEXT);
        this.briefDescText = NewConfigurationMainPage.createEditableText((Composite)this.composite, (int)400, (int)80, (int)2);
        this.initControls();
        this.addListeners();
        this.setControl((Control)this.composite);
    }

    protected void initControls() {
        MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        String name = "new_config";
        if (lib != null) {
            name = TngUtil.getNextAvailableName((List)lib.getPredefinedConfigurations(), (String)name);
        }
        this.nameText.setText(name);
    }

    protected void addListeners() {
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationMainPage.this.setPageComplete(NewConfigurationMainPage.this.isPageComplete());
                NewConfigurationMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public void onEnterPage(Object obj) {
        if (this.nameText != null) {
            this.nameText.setFocus();
            this.nameText.selectAll();
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        String configName = this.getConfigurationName();
        if (!this.validateConfigurationName(configName)) {
            return false;
        }
        if (this.configurationExists(configName)) {
            this.setErrorMessage(LibraryEditResources.duplicateElementNameError_simple_msg);
            return false;
        }
        this.setErrorMessage(null);
        return this.getErrorMessage() == null;
    }

    protected boolean configurationExists(String configName) {
        String[] configNames = LibraryServiceUtil.getMethodConfigurationNames((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        int i = 0;
        while (i < configNames.length) {
            if (configName.equalsIgnoreCase(configNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean validateConfigurationName(String name) {
        String errmsg = TngUtil.checkElementName((String)name, (String)LibraryUIText.TEXT_METHOD_CONFIGURATON);
        if (errmsg != null) {
            errmsg = errmsg.replaceAll("\n\n", " ");
        }
        this.setErrorMessage(errmsg);
        return errmsg == null;
    }

    public String getConfigurationName() {
        return this.nameText.getText().trim();
    }

    public String getBriefDescription() {
        return this.briefDescText.getText().trim();
    }
}

