/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.edit.parts;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.diagram.ad.custom.policies.ActivityCreationEditPolicy;
import org.eclipse.epf.diagram.ad.custom.policies.ActivityXYLayoutEditPolicy;
import org.eclipse.epf.diagram.ad.edit.policies.ActivityCanonicalEditPolicy;
import org.eclipse.epf.diagram.ad.edit.policies.ActivityItemSemanticEditPolicy;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class ActivityEditPart
extends DiagramEditPart {
    public static final String MODEL_ID = "AD";
    public static final int VISUAL_ID = 79;

    public ActivityEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ActivityItemSemanticEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new ActivityCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ActivityXYLayoutEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new ActivityCreationEditPolicy());
    }

    protected void handleNotificationEvent(Notification event) {
        if (NotationPackage.Literals.VIEW__VISIBLE.equals(event.getFeature())) {
            Object notifier = event.getNotifier();
            if (notifier == this.getModel()) {
                this.refreshVisibility();
            } else if (event.getNotifier() instanceof Node) {
                this.refreshChildren();
                DiagramEditorUtil.refreshConnectionEditParts((DiagramEditPart)this);
            }
        } else {
            super.handleNotificationEvent(event);
        }
    }

    private void refreshConnections() {
        block9: {
            org.eclipse.gef.ConnectionEditPart part;
            Diagram act = (Diagram)this.getModel();
            EList edges = act.getEdges();
            for (Edge edge : edges) {
                Object model;
                if (!edge.isVisible() || (part = this.createOrFindConnection(edge)) == null) continue;
                if (part.getSource() == null) {
                    for (EditPart element : this.getChildren()) {
                        model = element.getModel();
                        if (edge.getSource() != model || !(element instanceof GraphicalEditPart)) continue;
                        if (((GraphicalEditPart)element).getFigure().isVisible()) {
                            part.setSource(element);
                            continue;
                        }
                        part.setSource(null);
                    }
                }
                if (part.getTarget() != null) continue;
                for (EditPart element : this.getChildren()) {
                    model = element.getModel();
                    if (edge.getTarget() != model || !(element instanceof GraphicalEditPart)) continue;
                    if (((GraphicalEditPart)element).getFigure().isVisible()) {
                        part.setTarget(element);
                        continue;
                    }
                    part.setTarget(null);
                }
            }
            try {
                for (Edge edge : edges) {
                    part = (ConnectionEditPart)this.createOrFindConnection(edge);
                    if (part.getSource() != null && part.getTarget() != null || part.getFigure() == null) continue;
                    part.getFigure().setVisible(false);
                    part.getFigure().revalidate();
                    part.deactivate();
                }
            }
            catch (Exception e) {
                if (!ActivityDiagramEditorPlugin.getInstance().isDebugging()) break block9;
                ActivityDiagramEditorPlugin.getInstance().getLogger().logError("Error occured while refresh the connection: " + e);
            }
        }
    }

    public void moveFigure(int moveX, int moveY) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof GraphicalEditPart)) continue;
            GraphicalEditPart part = (GraphicalEditPart)child;
            Rectangle bounds = part.getFigure().getBounds();
            Rectangle r = new Rectangle(new Point(bounds.x + moveX, bounds.y + moveY), bounds.getSize());
            this.setLayoutConstraint((EditPart)part, part.getFigure(), r);
        }
    }
}

