/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.edit.policies;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.epf.diagram.ad.custom.commands.CreateIncomingControlFlowCommand;
import org.eclipse.epf.diagram.ad.custom.commands.CreateOutgoingControlFlowCommand;
import org.eclipse.epf.diagram.ad.edit.commands.ControlFlowReorientCommand;
import org.eclipse.epf.diagram.ad.part.UMLVisualIDRegistry;
import org.eclipse.epf.diagram.ad.providers.UMLElementTypes;
import org.eclipse.epf.diagram.core.util.DiagramCoreValidation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IEditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLBaseItemSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String VISUAL_ID_KEY = "visual_id";

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            Integer id = new Integer(UMLVisualIDRegistry.getVisualID((View)view));
            request.getExtendedData().put(VISUAL_ID_KEY, id);
        }
        return super.getCommand(request);
    }

    protected int getVisualID(IEditCommandRequest request) {
        Object id = request.getParameter(VISUAL_ID_KEY);
        return id instanceof Integer ? (Integer)id : -1;
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        TransactionalEditingDomain editingDomain;
        ICommand command;
        Command epCommand;
        IElementType elementType;
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Object editHelperContext = completedRequest.getEditHelperContext();
        if (editHelperContext instanceof View || editHelperContext instanceof IEditHelperContext && ((IEditHelperContext)editHelperContext).getEObject() instanceof View) {
            return null;
        }
        if (editHelperContext == null) {
            editHelperContext = ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
        }
        if ((elementType = ElementTypeRegistry.getInstance().getElementType(editHelperContext)) == ElementTypeRegistry.getInstance().getType("org.eclipse.gmf.runtime.emf.type.core.default")) {
            elementType = null;
        }
        if ((epCommand = this.getSemanticCommandSwitch(completedRequest)) != null) {
            CommandProxy command2 = epCommand instanceof ICommandProxy ? ((ICommandProxy)epCommand).getICommand() : new CommandProxy(epCommand);
            completedRequest.setParameter("edit policy command", (Object)command2);
        }
        ICommandProxy ehCommand = null;
        if (elementType != null && (command = elementType.getEditCommand(completedRequest)) != null) {
            if (!(command instanceof CompositeTransactionalCommand)) {
                editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                command = new CompositeTransactionalCommand(editingDomain, null).compose((IUndoableOperation)command);
            }
            ehCommand = new ICommandProxy(command);
        }
        boolean shouldProceed = true;
        if (completedRequest instanceof DestroyRequest) {
            shouldProceed = this.shouldProceed((DestroyRequest)completedRequest);
        }
        if (shouldProceed) {
            if (completedRequest instanceof DestroyRequest) {
                editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                ICommandProxy deleteViewCommand = new ICommandProxy((ICommand)new DeleteCommand(editingDomain, (View)this.getHost().getModel()));
                ehCommand = ehCommand == null ? deleteViewCommand : ehCommand.chain((Command)deleteViewCommand);
            }
            return ehCommand;
        }
        return null;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (UMLElementTypes.ControlFlow_3001 == req.getElementType()) {
            return req.getTarget() == null ? this.getCreateOutgoing(req) : this.getCreateIncomingComplete(req);
        }
        return null;
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        return null;
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return null;
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return null;
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        return null;
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        switch (this.getVisualID((IEditCommandRequest)req)) {
            case 3001: {
                ControlFlowReorientCommand cmd = new ControlFlowReorientCommand(req);
                cmd.setHost(this.getHost());
                return this.getMSLWrapper((ICommand)cmd);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getMSLWrapper(ICommand cmd) {
        return new ICommandProxy(cmd);
    }

    protected EObject getSemanticElement() {
        return ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
    }

    protected EObject getRelationshipContainer(Object uelement, EClass containerClass, IElementType relationshipType) {
        if (uelement instanceof EObject) {
            EObject element = (EObject)uelement;
            while (element != null) {
                if (containerClass.isSuperTypeOf(element.eClass())) {
                    return element;
                }
                element = element.eContainer();
            }
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected Command getDestroyElementCommand(View view, boolean confirm) {
        EditPart editPart = (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        if (editPart == null) {
            return null;
        }
        DestroyElementRequest request = new DestroyElementRequest(this.getEditingDomain(), confirm);
        return editPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)request, Collections.EMPTY_MAP));
    }

    protected CompoundCommand getDestroyEdgesCommand(boolean confirm) {
        Command destroyCmd;
        CompoundCommand cmd = new CompoundCommand();
        View view = (View)this.getHost().getModel();
        Iterator it = view.getSourceEdges().iterator();
        while (it.hasNext()) {
            destroyCmd = this.getDestroyElementCommand((View)((Edge)it.next()), confirm);
            if (destroyCmd == null) continue;
            cmd.add(destroyCmd);
        }
        it = view.getTargetEdges().iterator();
        while (it.hasNext()) {
            destroyCmd = this.getDestroyElementCommand((View)((Edge)it.next()), confirm);
            if (destroyCmd == null) continue;
            cmd.add(destroyCmd);
        }
        return cmd;
    }

    protected Command getCreateIncomingComplete(CreateRelationshipRequest req) {
        if (req.getSource() == req.getTarget()) {
            return new Command(){};
        }
        if (!(req.getSource() instanceof ActivityNode)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (req.getTarget() instanceof ActivityPartition) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject element = req.getSource();
        if (element == null || !(element instanceof ActivityNode)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (this.isDuplicateRelationship(req.getSource(), req.getTarget())) {
            return UnexecutableCommand.INSTANCE;
        }
        if (DiagramCoreValidation.canConnect((EditPart)this.getHost(), (EObject)req.getSource(), (EObject)req.getTarget()) != null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (element instanceof ActivityNode) {
            if (req.getContainmentFeature() == null) {
                req.setContainmentFeature(UMLPackage.eINSTANCE.getActivity_Edge());
            }
            Command command = this.getMSLWrapper((ICommand)new CreateIncomingControlFlowCommand(req, element.eContainer()));
            return command;
        }
        return null;
    }

    private boolean isDuplicateRelationship(EObject source, EObject target) {
        EObject container = source.eContainer();
        if (container instanceof Activity) {
            Activity activity = (Activity)container;
            EList list = activity.getEdges();
            for (ActivityEdge element : list) {
                if (element.getSource() != source || element.getTarget() != target) continue;
                return true;
            }
        }
        return false;
    }

    protected Command getCreateOutgoing(CreateRelationshipRequest req) {
        if (!(req.getSource() instanceof ActivityNode)) {
            return null;
        }
        EObject element = req.getTarget();
        if (element == null || !(element instanceof ActivityNode)) {
            return new Command(){};
        }
        if (element instanceof ActivityNode && req.getContainmentFeature() == null) {
            req.setContainmentFeature(UMLPackage.eINSTANCE.getActivity_Edge());
        }
        return this.getMSLWrapper((ICommand)new CreateOutgoingControlFlowCommand(req));
    }

    public static class LinkConstraints {
        private static final String OPPOSITE_END_VAR = "oppositeEnd";

        public static boolean canCreateControlFlow_3001(StructuredActivityNode container, ActivityNode source, ActivityNode target) {
            return LinkConstraints.canExistControlFlow_3001(container, source, target);
        }

        public static boolean canExistControlFlow_3001(StructuredActivityNode container, ActivityNode source, ActivityNode target) {
            return true;
        }
    }
}

