/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.expressions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;

public abstract class UMLAbstractExpression {
    private static final boolean DISABLED_NO_IMPL_EXCEPTION_LOG = Boolean.valueOf(Platform.getDebugOption((String)(String.valueOf(ActivityDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/disableNoExprImplExceptionLog")));
    private String body;
    private EClassifier context;
    private Map env;
    private IStatus status = Status.OK_STATUS;

    protected UMLAbstractExpression(EClassifier context) {
        this.context = context;
    }

    protected UMLAbstractExpression(String body, EClassifier context, Map env) {
        this.body = body;
        this.context = context;
        this.env = env;
    }

    protected void setStatus(int severity, String message, Throwable throwable) {
        String pluginID = "org.eclipse.epf.diagram.ad";
        this.status = new Status(severity, pluginID, -1, message != null ? message : "", throwable);
        if (!this.status.isOK()) {
            ActivityDiagramEditorPlugin.getInstance().logError("Expression problem:" + message + "body:" + this.body, throwable);
        }
    }

    protected abstract Object doEvaluate(Object var1, Map var2);

    public Object evaluate(Object context) {
        return this.evaluate(context, Collections.EMPTY_MAP);
    }

    public Object evaluate(Object context, Map env) {
        if (this.context().isInstance(context)) {
            try {
                return this.doEvaluate(context, env);
            }
            catch (Exception e) {
                if (DISABLED_NO_IMPL_EXCEPTION_LOG && e instanceof NoImplException) {
                    return null;
                }
                ActivityDiagramEditorPlugin.getInstance().logError("Expression evaluation failure: " + this.body, e);
            }
        }
        return null;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public String body() {
        return this.body;
    }

    public EClassifier context() {
        return this.context;
    }

    public Map environment() {
        return this.env;
    }

    public void assignTo(EStructuralFeature feature, EObject target) {
        this.evaluate(target);
    }

    protected Object performCast(Object value, ETypedElement targetType) {
        if (targetType.getEType() == null || targetType.getEType().getInstanceClass() == null) {
            return value;
        }
        Class targetClass = targetType.getEType().getInstanceClass();
        if (value != null && value instanceof Number) {
            Number num = (Number)value;
            Class<?> valClass = value.getClass();
            Class targetWrapperClass = targetClass;
            if (targetClass.isPrimitive()) {
                targetWrapperClass = EcoreUtil.wrapperClassFor((Class)targetClass);
            }
            if (valClass.equals(targetWrapperClass)) {
                return value;
            }
            if (Number.class.isAssignableFrom(targetWrapperClass)) {
                if (targetWrapperClass.equals(Byte.class)) {
                    return new Byte(num.byteValue());
                }
                if (targetWrapperClass.equals(Integer.class)) {
                    return new Integer(num.intValue());
                }
                if (targetWrapperClass.equals(Short.class)) {
                    return new Short(num.shortValue());
                }
                if (targetWrapperClass.equals(Long.class)) {
                    return new Long(num.longValue());
                }
                if (targetWrapperClass.equals(BigInteger.class)) {
                    return BigInteger.valueOf(num.longValue());
                }
                if (targetWrapperClass.equals(Float.class)) {
                    return new Float(num.floatValue());
                }
                if (targetWrapperClass.equals(Double.class)) {
                    return new Double(num.doubleValue());
                }
                if (targetWrapperClass.equals(BigDecimal.class)) {
                    return new BigDecimal(num.doubleValue());
                }
            }
        }
        return value;
    }

    public static final UMLAbstractExpression createNullExpression(EClassifier context) {
        return new UMLAbstractExpression(context){

            protected Object doEvaluate(Object context, Map env) {
                return null;
            }
        };
    }

    public static class NoImplException
    extends RuntimeException {
        public NoImplException(String message) {
            super(message);
        }
    }
}

