/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.epf.richtext.dialogs.AddImageDialog;
import org.eclipse.swt.widgets.Display;

public class AddImageAction
extends RichTextAction {
    public AddImageAction(IRichText richText) {
        super(richText, 1);
        this.setImageDescriptor(RichTextImages.IMG_DESC_ADD_IMAGE);
        this.setDisabledImageDescriptor(RichTextImages.DISABLED_IMG_DESC_ADD_IMAGE);
        this.setToolTipText(RichTextResources.addImageAction_toolTipText);
    }

    public void execute(IRichText richText) {
        if (richText != null) {
            String imageURL;
            AddImageDialog dialog = new AddImageDialog(Display.getCurrent().getActiveShell());
            dialog.open();
            if (dialog.getReturnCode() == 0 && (imageURL = dialog.getImage().getURL()).length() > 0) {
                richText.executeCommand("addImage", imageURL);
            }
        }
    }

    public boolean disableInSourceMode() {
        return false;
    }
}

