/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RichTextAction
extends Action {
    protected IRichText richText;
    protected ToolItem toolItem;
    protected Collection<IAction> fMenuActions = new LinkedHashSet<IAction>();
    protected IMenuCreator menuCreator = new IMenuCreator(){
        private MenuManager dropDownMenuMgr;

        private void createDropDownMenuMgr() {
            if (this.dropDownMenuMgr == null) {
                this.dropDownMenuMgr = new MenuManager();
                for (IAction item : RichTextAction.this.getMenuActions()) {
                    this.dropDownMenuMgr.add(item);
                }
            }
        }

        public Menu getMenu(Control parent) {
            this.createDropDownMenuMgr();
            return this.dropDownMenuMgr.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            this.createDropDownMenuMgr();
            Menu menu = new Menu(parent);
            IContributionItem[] items = this.dropDownMenuMgr.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item;
                IContributionItem newItem = item = items[i];
                if (item instanceof ActionContributionItem) {
                    newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
                }
                newItem.fill(menu, -1);
                ++i;
            }
            return menu;
        }

        public void dispose() {
            if (this.dropDownMenuMgr != null) {
                this.dropDownMenuMgr.dispose();
                this.dropDownMenuMgr = null;
            }
        }
    };

    public RichTextAction(IRichText richText, int style) {
        super(null, style);
        this.richText = richText;
    }

    public boolean disableInReadOnlyMode() {
        return true;
    }

    public boolean disableInSourceMode() {
        return true;
    }

    public void setToolItem(ToolItem toolItem) {
        this.toolItem = toolItem;
    }

    public void run() {
        this.execute(this.richText);
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public Collection<IAction> getMenuActions() {
        return this.fMenuActions;
    }

    public void addActionToMenu(IAction action) {
        this.fMenuActions.add(action);
    }

    public abstract void execute(IRichText var1);
}

