/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.ui.util;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class WrappedMessageDialog
extends MessageDialog {
    public WrappedMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    protected Control createMessageArea(Composite composite) {
        Control rComposite = super.createMessageArea(composite);
        int minWidth = 300;
        int charsPerLine = minWidth / 4 - 15;
        GridData gd = (GridData)this.messageLabel.getLayoutData();
        gd.minimumWidth = minWidth;
        this.messageLabel.setText(this.addLineBreaks(this.message, charsPerLine));
        return rComposite;
    }

    String addLineBreaks(String msg, int maxChars) {
        if (msg == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        int count = 0;
        int i = 0;
        while (i < msg.length()) {
            strBuf.append(msg.charAt(i));
            count = Character.isWhitespace(msg.charAt(i)) ? 0 : ++count;
            if (count >= maxChars) {
                if (!Character.isWhitespace(msg.charAt(i))) {
                    strBuf.append("\n");
                }
                count = 0;
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static boolean openConfirm(Shell parent, String title, String message) {
        WrappedMessageDialog dialog = new WrappedMessageDialog(parent, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return dialog.open() == 0;
    }

    public static void openError(Shell parent, String title, String message) {
        WrappedMessageDialog dialog = new WrappedMessageDialog(parent, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static void openInformation(Shell parent, String title, String message) {
        WrappedMessageDialog dialog = new WrappedMessageDialog(parent, title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static boolean openQuestion(Shell parent, String title, String message) {
        WrappedMessageDialog dialog = new WrappedMessageDialog(parent, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        return dialog.open() == 0;
    }

    public static void openWarning(Shell parent, String title, String message) {
        WrappedMessageDialog dialog = new WrappedMessageDialog(parent, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }
}

