/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.IRichTextEditor;
import org.eclipse.epf.richtext.IRichTextToolBar;
import org.eclipse.epf.richtext.RichText;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.RichTextSelection;
import org.eclipse.epf.richtext.RichTextToolBar;
import org.eclipse.epf.richtext.actions.CopyAction;
import org.eclipse.epf.richtext.actions.CutAction;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.actions.PasteAction;
import org.eclipse.epf.richtext.actions.PastePlainTextAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IReadOnlyDependent;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextEditor
implements IRichTextEditor {
    protected static final String HTML_TAB_NAME = RichTextResources.htmlTab_text;
    protected boolean debug;
    protected Logger logger;
    protected String basePath;
    protected ViewForm form;
    protected IRichTextToolBar toolBar;
    protected Composite content;
    protected CTabFolder tabFolder;
    protected CTabItem richTextTab;
    protected CTabItem htmlTab;
    protected IRichText richText;
    protected TextViewer sourceViewer;
    protected IDocument currentDoc;
    protected DropTarget sourceEditDropTarget;
    protected Menu contextMenu;
    protected boolean sourceModified = false;
    protected boolean editable = true;
    private OperationHistoryActionHandler undoAction;
    private OperationHistoryActionHandler redoAction;
    private IEditorSite editorSite;
    private Map<String, IAction> fActions = new HashMap<String, IAction>(10);
    private ActivationCodeTrigger fActivationCodeTrigger = new ActivationCodeTrigger();
    private List fActivationCodes = new ArrayList(2);
    final IUndoManager undoManager = new TextViewerUndoManager(10);
    private String[] fKeyBindingScopes;
    protected IDocumentListener sourceEditDocumentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            RichTextEditor.this.sourceModified = true;
            if (RichTextEditor.this.richText != null && RichTextEditor.this.richText instanceof RichText) {
                RichTextEditor.this.richText.notifyModifyListeners();
            }
        }
    };
    protected Listener sourceEditDeactivateListener = new Listener(){

        public void handleEvent(Event event) {
            if (RichTextEditor.this.sourceModified) {
                RichTextEditor.this.updateRichText(RichTextEditor.this.sourceViewer.getTextWidget().getText());
                RichTextEditor.this.setModified(true);
                RichTextEditor.this.sourceModified = false;
            }
        }
    };
    protected KeyListener sourceEditKeyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            String cmdId;
            ParameterizedCommand command;
            int accel;
            KeyStroke stroke;
            KeySequence seq;
            Binding bind;
            Object adapter = PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            if (adapter != null && adapter instanceof IBindingService && (bind = ((IBindingService)adapter).getPerfectMatch((TriggerSequence)(seq = KeySequence.getInstance((KeyStroke)(stroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)(accel = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e)))))))) != null && (command = bind.getParameterizedCommand()) != null && (cmdId = command.getId()) != null && cmdId.equals("org.eclipse.ui.edit.findReplace")) {
                RichTextEditor.this.richText.getFindReplaceAction().execute(RichTextEditor.this);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };

    public RichTextEditor(Composite parent, int style, IEditorSite editorSite) {
        this(parent, style, editorSite, null);
    }

    public RichTextEditor(Composite parent, int style, IEditorSite editorSite, String basePath) {
        this.basePath = basePath;
        this.editorSite = editorSite;
        this.debug = RichTextPlugin.getDefault().isDebugging();
        this.logger = RichTextPlugin.getDefault().getLogger();
        this.init(parent, style);
    }

    protected void init(Composite parent, int style) {
        try {
            this.form = new ViewForm(parent, style);
            this.form.marginHeight = 0;
            this.form.marginWidth = 0;
            this.toolBar = new RichTextToolBar((Composite)this.form, 0x800000, this);
            this.content = new Composite((Composite)this.form, 0x800000);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.content.setLayout((Layout)layout);
            this.tabFolder = this.createEditorTabFolder(this.content, style);
            this.form.setTopCenter((Control)((RichTextToolBar)this.toolBar).getToolbarMgr().getControl());
            this.form.setTopLeft((Control)((RichTextToolBar)this.toolBar).getToolbarMgrCombo().getControl());
            this.form.setContent((Control)this.content);
        }
        catch (Exception e) {
            this.logger.logError((Throwable)e);
        }
    }

    @Override
    public Control getControl() {
        return this.form;
    }

    public IRichText getRichTextControl() {
        return this.richText;
    }

    @Override
    public void setLayoutData(Object layoutData) {
        if (this.form != null) {
            this.form.setLayoutData(layoutData);
        }
    }

    @Override
    public Object getLayoutData() {
        if (this.form != null) {
            return this.form.getLayoutData();
        }
        return null;
    }

    @Override
    public void setFocus() {
        if (this.richText != null) {
            this.richText.setFocus();
        }
        this.setSelection(0);
        if (this.toolBar != null && this.tabFolder != null) {
            this.toolBar.updateToolBar(this.editable);
        }
    }

    @Override
    public void setBlur() {
        if (this.richText != null) {
            this.richText.setBlur();
        }
    }

    @Override
    public boolean hasFocus() {
        if (this.richText != null) {
            return this.richText.hasFocus();
        }
        return false;
    }

    @Override
    public void setSelection(int index) {
        if (this.tabFolder != null) {
            this.tabFolder.setSelection(index);
        }
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public URL getCopyURL() {
        if (this.richText != null) {
            return this.richText.getCopyURL();
        }
        return null;
    }

    @Override
    public void setCopyURL() {
        if (this.richText != null) {
            this.richText.setCopyURL();
        }
    }

    @Override
    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        if (this.toolBar != null && this.tabFolder != null) {
            this.toolBar.updateToolBar(editable);
        }
        if (this.richText != null) {
            this.richText.setEditable(editable);
        }
        if (this.sourceViewer != null) {
            this.sourceViewer.setEditable(editable);
        }
    }

    @Override
    public boolean getModified() {
        if (this.richText != null) {
            return this.richText.getModified();
        }
        return false;
    }

    @Override
    public void setModified(boolean modified) {
        if (this.richText != null) {
            this.richText.setModified(modified);
        }
    }

    @Override
    public String getText() {
        if (this.sourceModified) {
            this.setText(this.getSourceEdit().getText());
            this.setModified(true);
            this.sourceModified = false;
        }
        if (this.richText != null) {
            return this.richText.getText();
        }
        return "";
    }

    @Override
    public void setText(String text) {
        if (this.richText != null) {
            this.richText.setText(text);
        }
        this.sourceModified = false;
        if (this.tabFolder != null) {
            if (this.toolBar != null) {
                this.toolBar.updateToolBar(this.editable);
            }
            if (this.getSourceEdit() != null) {
                this.removeModifyListeners();
                this.currentDoc.set(text);
                this.addModifyListeners();
            }
        }
    }

    protected void addModifyListeners() {
        if (this.currentDoc != null) {
            this.currentDoc.addDocumentListener(this.sourceEditDocumentListener);
        }
    }

    protected void removeModifyListeners() {
        if (this.currentDoc != null) {
            this.currentDoc.removeDocumentListener(this.sourceEditDocumentListener);
        }
    }

    @Override
    public void checkModify() {
        this.richText.checkModify();
        if (this.sourceModified) {
            this.notifyModifyListeners();
        }
        if (this.debug) {
            this.printDebugMessage("checkModify", "modified=" + this.sourceModified);
        }
    }

    @Override
    public void restoreText() {
        if (this.richText != null) {
            this.richText.restoreText();
        }
    }

    @Override
    public RichTextSelection getSelected() {
        if (this.tabFolder.getSelection() == this.htmlTab) {
            String HTMLsource = this.getSourceEdit().getText();
            Point sel = this.sourceViewer.getSelectedRange();
            int selStartIndex = sel.x;
            int selEndIndex = sel.x + sel.y - 1;
            this.richText.getSelected().clear();
            this.richText.getSelected().setText(HTMLsource.substring(selStartIndex, selEndIndex + 1));
        }
        return this.richText.getSelected();
    }

    @Override
    public Object getData(String key) {
        if (this.richText != null) {
            this.richText.getData(key);
        }
        return null;
    }

    @Override
    public void setData(String key, Object value) {
        if (this.richText != null) {
            this.richText.setData(key, value);
        }
    }

    @Override
    public int executeCommand(String command) {
        if (this.richText != null) {
            return this.richText.executeCommand(command);
        }
        return 0;
    }

    @Override
    public int executeCommand(String command, String param) {
        if (this.richText != null) {
            return this.richText.executeCommand(command, param);
        }
        return 0;
    }

    @Override
    public int executeCommand(String command, String[] params) {
        if (this.richText != null) {
            return this.richText.executeCommand(command, params);
        }
        return 0;
    }

    @Override
    public void dispose() {
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        if (this.sourceEditDropTarget != null) {
            this.sourceEditDropTarget.dispose();
            this.sourceEditDropTarget = null;
        }
        if (this.fActivationCodeTrigger != null) {
            this.fActivationCodeTrigger.uninstall();
            this.fActivationCodeTrigger = null;
        }
        this.removeModifyListeners();
        if (this.getSourceEdit() != null) {
            this.getSourceEdit().removeListener(27, this.sourceEditDeactivateListener);
            this.getSourceEdit().removeKeyListener(this.sourceEditKeyListener);
            this.sourceEditDeactivateListener = null;
            this.sourceEditKeyListener = null;
        }
        if (this.sourceViewer != null) {
            this.sourceViewer = null;
        }
        if (this.fActions != null) {
            this.fActions.clear();
            this.fActions = null;
        }
        if (this.fActivationCodes != null) {
            this.fActivationCodes.clear();
            this.fActivationCodes = null;
        }
        if (this.richText != null) {
            this.richText.dispose();
            this.richText = null;
        }
    }

    @Override
    public boolean isDisposed() {
        if (this.richText != null) {
            return this.richText.isDisposed();
        }
        return true;
    }

    @Override
    public Iterator<ModifyListener> getModifyListeners() {
        if (this.richText != null) {
            this.richText.getModifyListeners();
        }
        return null;
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        if (this.richText != null) {
            this.richText.addKeyListener(listener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        if (this.richText != null) {
            this.richText.removeKeyListener(listener);
        }
    }

    @Override
    public void addModifyListener(ModifyListener listener) {
        if (this.richText != null) {
            this.richText.addModifyListener(listener);
        }
    }

    @Override
    public void removeModifyListener(ModifyListener listener) {
        if (this.richText != null) {
            this.richText.removeModifyListener(listener);
        }
    }

    @Override
    public void addDisposeListener(DisposeListener listener) {
        if (this.richText != null) {
            this.richText.addDisposeListener(listener);
        }
    }

    @Override
    public void removeDisposeListener(DisposeListener listener) {
        if (this.richText != null) {
            this.richText.removeDisposeListener(listener);
        }
    }

    @Override
    public void addHelpListener(HelpListener listener) {
        if (this.richText != null) {
            this.richText.addHelpListener(listener);
        }
    }

    @Override
    public void removeHelpListener(HelpListener listener) {
        if (this.richText != null) {
            this.richText.removeHelpListener(listener);
        }
    }

    @Override
    public void addListener(int eventType, Listener listener) {
        if (this.richText != null) {
            this.richText.addListener(eventType, listener);
        }
    }

    @Override
    public void removeListener(int eventType, Listener listener) {
        if (this.richText != null) {
            this.richText.removeListener(eventType, listener);
        }
    }

    @Override
    public Iterator<RichTextListener> getListeners() {
        if (this.richText != null) {
            return this.richText.getListeners();
        }
        return null;
    }

    @Override
    public void notifyModifyListeners() {
        if (this.richText != null) {
            Event event = new Event();
            event.display = Display.getCurrent();
            event.widget = this.richText.getControl();
            Iterator<ModifyListener> i = this.getModifyListeners();
            while (i != null && i.hasNext()) {
                ModifyListener listener = i.next();
                listener.modifyText(new ModifyEvent(event));
            }
        }
    }

    @Override
    public void fillToolBar(IRichTextToolBar toolBar) {
    }

    protected IRichText createRichTextControl(Composite parent, int style, String basePath) {
        return new RichText(parent, style, basePath);
    }

    protected CTabFolder createEditorTabFolder(Composite parent, int style) {
        CTabFolder folder = new CTabFolder(parent, 0x800400);
        folder.setLayout((Layout)new GridLayout(1, true));
        folder.setLayoutData((Object)new GridData(1808));
        Composite richTextComposite = new Composite((Composite)folder, 0x800000);
        GridLayout richTextCompositeLayout = new GridLayout(1, false);
        richTextCompositeLayout.marginHeight = 0;
        richTextCompositeLayout.marginWidth = 0;
        richTextComposite.setLayout((Layout)richTextCompositeLayout);
        richTextComposite.setLayoutData((Object)new GridData(1808));
        this.richText = this.createRichTextControl(richTextComposite, style, this.basePath);
        this.richText.setData("richText", this);
        this.richText.getFindReplaceAction().setRichText(this);
        this.richTextTab = new CTabItem(folder, 0x800000);
        this.richTextTab.setText(RichTextResources.richTextTab_text);
        this.richTextTab.setToolTipText(RichTextResources.richTextTab_toolTipText);
        this.richTextTab.setControl((Control)richTextComposite);
        Composite htmlComposite = new Composite((Composite)folder, 0x800000);
        htmlComposite.setLayout((Layout)new FillLayout());
        this.sourceViewer = new TextViewer(htmlComposite, 8389186);
        this.sourceViewer.setUndoManager(this.undoManager);
        this.setDocument(null);
        this.addModifyListeners();
        this.getSourceEdit().addListener(27, this.sourceEditDeactivateListener);
        this.getSourceEdit().addKeyListener(this.sourceEditKeyListener);
        this.contextMenu = new Menu((Decorations)parent.getShell(), 8);
        this.getSourceEdit().setMenu(this.contextMenu);
        this.fillContextMenu(this.contextMenu);
        this.htmlTab = new CTabItem(folder, 0);
        this.htmlTab.setText(HTML_TAB_NAME);
        this.htmlTab.setToolTipText(RichTextResources.htmlTab_toolTipText);
        this.htmlTab.setControl((Control)htmlComposite);
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabItem item = (CTabItem)event.item;
                if (item.getText().equals(HTML_TAB_NAME)) {
                    RichTextEditor.this.removeModifyListeners();
                    RichTextEditor.this.currentDoc.set(RichTextEditor.this.getText());
                    RichTextEditor.this.sourceModified = false;
                    RichTextEditor.this.addModifyListeners();
                    if (RichTextEditor.this.toolBar != null) {
                        RichTextEditor.this.toolBar.updateToolBar(RichTextEditor.this.editable);
                    }
                } else {
                    RichTextEditor.this.updateRichText(RichTextEditor.this.getSourceEdit().getText());
                    RichTextEditor.this.setModified(true);
                    if (RichTextEditor.this.toolBar != null) {
                        RichTextEditor.this.toolBar.updateToolBar(RichTextEditor.this.editable);
                    }
                }
            }
        });
        this.fillToolBar(this.toolBar);
        this.initializeActivationCodeTrigger();
        this.createActions();
        folder.setSelection(0);
        return folder;
    }

    private void setDocument(IDocument doc) {
        if (doc == null) {
            doc = new Document();
        }
        this.undoManager.disconnect();
        IDocument oldDoc = this.sourceViewer.getDocument();
        if (oldDoc != null) {
            oldDoc.removeDocumentListener(this.sourceEditDocumentListener);
        }
        this.currentDoc = doc;
        this.sourceViewer.setDocument(this.currentDoc);
        this.currentDoc.addDocumentListener(this.sourceEditDocumentListener);
        this.undoManager.connect((ITextViewer)this.sourceViewer);
        if (this.undoAction != null) {
            this.undoAction.setContext(this.getUndoContext());
        }
        if (this.redoAction != null) {
            this.redoAction.setContext(this.getUndoContext());
        }
    }

    public StyledText getSourceEdit() {
        if (this.sourceViewer != null) {
            return this.sourceViewer.getTextWidget();
        }
        return null;
    }

    public void addHTML(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (this.tabFolder.getSelection() == this.richTextTab) {
            this.executeCommand("addHTML", text);
        } else if (this.tabFolder.getSelection() == this.htmlTab) {
            String oldHTML = this.getSourceEdit().getText();
            Point sel = this.sourceViewer.getSelectedRange();
            int selStartIndex = sel.x;
            int selEndIndex = sel.x + sel.y - 1;
            String newHTML = String.valueOf(oldHTML.substring(0, selStartIndex)) + text + oldHTML.substring(selEndIndex + 1);
            this.removeModifyListeners();
            this.currentDoc.set(newHTML);
            this.addModifyListeners();
            this.updateRichText(newHTML);
        }
    }

    public void addImage(String imageURL, String height, String width, String altTag) {
        if (this.tabFolder.getSelection() == this.richTextTab) {
            this.executeCommand("addImage", new String[]{imageURL, height, width, altTag});
        } else if (this.tabFolder.getSelection() == this.htmlTab) {
            StringBuffer imageLink = new StringBuffer();
            imageLink.append("<img");
            if (height.length() > 0) {
                imageLink.append(" height=\"" + height + "\"");
            }
            if (altTag.length() > 0) {
                imageLink.append(" alt=\"" + altTag + "\"");
            }
            imageLink.append(" src=\"" + imageURL + "\"");
            if (width.length() > 0) {
                imageLink.append(" width=\"" + width + "\"");
            }
            imageLink.append(" />");
            String oldHTML = this.getSourceEdit().getText();
            Point sel = this.sourceViewer.getSelectedRange();
            int selStartIndex = sel.x;
            int selEndIndex = sel.x + sel.y - 1;
            String newHTML = String.valueOf(oldHTML.substring(0, selStartIndex)) + imageLink.toString() + oldHTML.substring(selEndIndex + 1);
            this.removeModifyListeners();
            this.currentDoc.set(newHTML);
            this.addModifyListeners();
            this.updateRichText(newHTML);
        }
    }

    public boolean isHTMLTabSelected() {
        return this.tabFolder.getSelection() == this.htmlTab;
    }

    protected void fillContextMenu(Menu contextMenu) {
        final MenuItem cutItem = new MenuItem(contextMenu, 8);
        cutItem.setText(RichTextResources.cutAction_text);
        cutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CutAction action = new CutAction(RichTextEditor.this);
                action.execute(RichTextEditor.this);
            }
        });
        final MenuItem copyItem = new MenuItem(contextMenu, 8);
        copyItem.setText(RichTextResources.copyAction_text);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CopyAction action = new CopyAction(RichTextEditor.this);
                action.execute(RichTextEditor.this);
            }
        });
        final MenuItem pasteItem = new MenuItem(contextMenu, 8);
        pasteItem.setText(RichTextResources.pasteAction_text);
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PasteAction action = new PasteAction(RichTextEditor.this);
                action.execute(RichTextEditor.this);
            }
        });
        final MenuItem pastePlainTextItem = new MenuItem(contextMenu, 8);
        pastePlainTextItem.setText(RichTextResources.pastePlainTextAction_text);
        pastePlainTextItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PastePlainTextAction action = new PastePlainTextAction(RichTextEditor.this);
                action.execute(RichTextEditor.this);
            }
        });
        contextMenu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                String selectedText = RichTextEditor.this.getSelected().getText();
                boolean selection = selectedText.length() > 0;
                cutItem.setEnabled(RichTextEditor.this.editable && selection);
                copyItem.setEnabled(selection);
                pasteItem.setEnabled(RichTextEditor.this.editable);
                pastePlainTextItem.setEnabled(RichTextEditor.this.editable);
            }
        });
    }

    private void updateRichText(String text) {
        if (this.richText != null) {
            this.richText.setText(text);
            this.richText.checkModify();
        }
        this.sourceModified = false;
        if (this.tabFolder != null && this.toolBar != null) {
            this.toolBar.updateToolBar(this.editable);
        }
    }

    private void addDropSupportToStyledText() {
        int operations = 19;
        this.sourceEditDropTarget = new DropTarget((Control)this.getSourceEdit(), operations);
        final TextTransfer textTransfer = TextTransfer.getInstance();
        final HTMLTransfer htmlTransfer = HTMLTransfer.getInstance();
        Transfer[] types = new Transfer[]{htmlTransfer, textTransfer};
        this.sourceEditDropTarget.setTransfer(types);
        this.sourceEditDropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                if (!RichTextEditor.this.getEditable()) {
                    event.detail = 0;
                }
                int i = 0;
                while (i < event.dataTypes.length) {
                    if (htmlTransfer.isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    ++i;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 13;
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (textTransfer.isSupportedType(event.currentDataType) || htmlTransfer.isSupportedType(event.currentDataType)) {
                    String text = (String)event.data;
                    RichTextEditor.this.addHTML(text);
                }
            }
        });
    }

    private void printDebugMessage(String method, String msg, String text) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("RichTextEditor[").append(this.richText.getControl().handle).append(']').append('.').append(method);
        if (msg != null && msg.length() > 0) {
            strBuf.append(": ").append(msg);
        }
        if (text != null && text.length() > 0) {
            strBuf.append('\n').append(text);
        }
        System.out.println(strBuf);
    }

    private void printDebugMessage(String method, String msg) {
        this.printDebugMessage(method, msg, null);
    }

    @Override
    public FindReplaceAction getFindReplaceAction() {
        return this.richText.getFindReplaceAction();
    }

    @Override
    public void setFindReplaceAction(FindReplaceAction findReplaceAction) {
        if (this.richText != null) {
            this.richText.setFindReplaceAction(findReplaceAction);
            this.richText.getFindReplaceAction().setRichText(this);
        }
    }

    @Override
    public void setInitialText(String text) {
        if (this.richText != null) {
            this.richText.setInitialText(text);
        }
        if (this.getSourceEdit() != null) {
            this.removeModifyListeners();
            this.setDocument((IDocument)new Document(text));
            this.addModifyListeners();
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager;
        if (this.sourceViewer instanceof ITextViewerExtension6 && (undoManager = this.sourceViewer.getUndoManager()) instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    protected void createActions() {
        this.createUndoRedoActions();
        Action selectAllAction = new Action(){

            public void run() {
                RichTextEditor.this.getSourceEdit().selectAll();
            }
        };
        selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.registerAction(ActionFactory.SELECT_ALL.getId(), (IAction)selectAllAction);
    }

    protected void createUndoRedoActions() {
        IUndoContext undoContext = this.getUndoContext();
        if (undoContext != null) {
            this.undoAction = new UndoActionHandler((IWorkbenchPartSite)this.getEditorSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
            this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.registerAction(ITextEditorActionConstants.UNDO, (IAction)this.undoAction);
            this.redoAction = new RedoActionHandler((IWorkbenchPartSite)this.getEditorSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
            this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            this.registerAction(ITextEditorActionConstants.REDO, (IAction)this.redoAction);
        }
    }

    private IEditorSite getEditorSite() {
        return this.editorSite;
    }

    private void registerAction(String actionId, IAction action) {
        IAction oldAction = this.getAction(actionId);
        if (oldAction instanceof OperationHistoryActionHandler) {
            ((OperationHistoryActionHandler)oldAction).dispose();
        }
        this.setAction(actionId, action);
        IActionBars actionBars = this.getEditorSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(actionId, action);
        }
    }

    public IAction getAction(String actionID) {
        assert (actionID != null);
        IAction action = this.fActions.get(actionID);
        return action;
    }

    public void setAction(String actionID, IAction action) {
        assert (actionID != null);
        if (action == null) {
            action = this.fActions.remove(actionID);
            if (action != null) {
                this.fActivationCodeTrigger.unregisterActionFromKeyActivation(action);
            }
        } else {
            this.fActions.put(actionID, action);
            this.fActivationCodeTrigger.registerActionForKeyActivation(action);
        }
    }

    private void initializeActivationCodeTrigger() {
        this.fActivationCodeTrigger.install();
        this.fActivationCodeTrigger.setScopes(this.fKeyBindingScopes);
    }

    static class ActionActivationCode {
        public String fActionId;
        public char fCharacter;
        public int fKeyCode = -1;
        public int fStateMask = -1;

        public ActionActivationCode(String actionId) {
            this.fActionId = actionId;
        }

        public boolean matches(VerifyEvent event) {
            return !(event.character != this.fCharacter || this.fKeyCode != -1 && event.keyCode != this.fKeyCode || this.fStateMask != -1 && event.stateMask != this.fStateMask);
        }
    }

    class ActivationCodeTrigger
    implements VerifyKeyListener {
        private boolean fIsInstalled = false;
        private IKeyBindingService fKeyBindingService;

        ActivationCodeTrigger() {
        }

        public void verifyKey(VerifyEvent event) {
            ActionActivationCode code = null;
            int size = RichTextEditor.this.fActivationCodes.size();
            int i = 0;
            while (i < size) {
                IAction action;
                code = (ActionActivationCode)RichTextEditor.this.fActivationCodes.get(i);
                if (code.matches(event) && (action = RichTextEditor.this.getAction(code.fActionId)) != null) {
                    if (action instanceof IUpdate) {
                        ((IUpdate)action).update();
                    }
                    if (!action.isEnabled() && action instanceof IReadOnlyDependent) {
                        IReadOnlyDependent dependent = (IReadOnlyDependent)action;
                        boolean writable = dependent.isEnabled(true);
                        if (writable) {
                            event.doit = false;
                            return;
                        }
                    } else if (action.isEnabled()) {
                        event.doit = false;
                        action.run();
                        return;
                    }
                }
                ++i;
            }
        }

        public void install() {
            if (!this.fIsInstalled) {
                if (RichTextEditor.this.sourceViewer instanceof ITextViewerExtension) {
                    TextViewer e = RichTextEditor.this.sourceViewer;
                    e.prependVerifyKeyListener((VerifyKeyListener)this);
                } else {
                    StyledText text = RichTextEditor.this.sourceViewer.getTextWidget();
                    text.addVerifyKeyListener((VerifyKeyListener)this);
                }
                this.fKeyBindingService = RichTextEditor.this.getEditorSite().getKeyBindingService();
                this.fIsInstalled = true;
            }
        }

        public void uninstall() {
            if (this.fIsInstalled) {
                StyledText text;
                if (RichTextEditor.this.sourceViewer instanceof ITextViewerExtension) {
                    TextViewer e = RichTextEditor.this.sourceViewer;
                    e.removeVerifyKeyListener((VerifyKeyListener)this);
                } else if (RichTextEditor.this.sourceViewer != null && (text = RichTextEditor.this.sourceViewer.getTextWidget()) != null && !text.isDisposed()) {
                    text.removeVerifyKeyListener((VerifyKeyListener)RichTextEditor.this.fActivationCodeTrigger);
                }
                this.fIsInstalled = false;
                this.fKeyBindingService = null;
            }
        }

        public void registerActionForKeyActivation(IAction action) {
            if (action.getActionDefinitionId() != null) {
                this.fKeyBindingService.registerAction(action);
            }
        }

        public void unregisterActionFromKeyActivation(IAction action) {
            if (action.getActionDefinitionId() != null) {
                this.fKeyBindingService.unregisterAction(action);
            }
        }

        public void setScopes(String[] keyBindingScopes) {
            if (keyBindingScopes != null && keyBindingScopes.length > 0) {
                this.fKeyBindingService.setScopes(keyBindingScopes);
            }
        }
    }
}

