/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.IRichTextToolBar;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.actions.IRichTextAction;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.epf.richtext.actions.RichTextComboAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolItem;

public class RichTextToolBar
implements IRichTextToolBar {
    private IRichText richText;
    private boolean addToolBar = true;
    private ToolBarManager toolbarMgr;
    private ToolBarManager toolbarMgrCombo;
    private List<Object> actionItems = new ArrayList<Object>();
    private static int lastWidth = -1;
    protected Composite parent;

    public RichTextToolBar(Composite parent, int style, IRichText richText) {
        this.parent = parent;
        this.richText = richText;
        this.addToolBar();
    }

    public void addAction(IAction action) {
        if (action != null) {
            ActionContributionItem item = new ActionContributionItem(action);
            this.toolbarMgr.add((IContributionItem)item);
            this.toolbarMgr.update(true);
            this.actionItems.add(item);
        }
    }

    public void addAction(RichTextComboAction item) {
        if (item != null) {
            item.init();
            this.toolbarMgrCombo.add((IContributionItem)item);
            this.toolbarMgrCombo.update(true);
            this.actionItems.add((Object)item);
        }
    }

    public void addSeparator() {
        this.toolbarMgr.add((IContributionItem)new Separator());
    }

    public void updateToolBar(boolean editable) {
        boolean richTextMode = true;
        if (this.richText instanceof RichTextEditor && ((RichTextEditor)this.richText).isHTMLTabSelected()) {
            richTextMode = false;
        }
        for (Object item : this.actionItems) {
            boolean enabledToolItem;
            if (item instanceof ToolItem) {
                enabledToolItem = true;
                ToolItem toolItem = (ToolItem)item;
                IRichTextAction action = (IRichTextAction)toolItem.getData();
                if (action != null && !editable && action.disableInReadOnlyMode()) {
                    enabledToolItem = false;
                }
                if (action != null && !richTextMode && action.disableInSourceMode()) {
                    enabledToolItem = false;
                }
                toolItem.setEnabled(enabledToolItem);
                continue;
            }
            if (item instanceof Combo) {
                if (richTextMode && editable) {
                    ((Combo)item).setEnabled(true);
                    continue;
                }
                ((Combo)item).setEnabled(false);
                continue;
            }
            if (!(item instanceof ActionContributionItem)) continue;
            enabledToolItem = true;
            RichTextAction action = (RichTextAction)((ActionContributionItem)item).getAction();
            if (action != null && !editable && action.disableInReadOnlyMode()) {
                enabledToolItem = false;
            }
            if (action != null && !richTextMode && action.disableInSourceMode()) {
                enabledToolItem = false;
            }
            action.setEnabled(enabledToolItem);
        }
    }

    protected void addToolBar() {
        if (this.addToolBar) {
            this.toolbarMgrCombo = new ToolBarManager(0x800040 | this.parent.getStyle());
            this.toolbarMgrCombo.createControl(this.parent);
            this.toolbarMgr = new ToolBarManager(0x800040 | this.parent.getStyle());
            this.toolbarMgr.createControl(this.parent);
            this.addToolBar = false;
        }
    }

    public ToolBarManager getToolbarMgr() {
        return this.toolbarMgr;
    }

    public ToolBarManager getToolbarMgrCombo() {
        return this.toolbarMgrCombo;
    }
}

