/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextComboAction;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontNameAction
extends RichTextComboAction {
    public FontNameAction(final IRichText richText) {
        super(richText);
        this.setToolTipText(RichTextResources.fontNameAction_toolTipText);
        TreeSet<String> fontSet = new TreeSet<String>();
        FontData[] fonts = Display.getCurrent().getFontList(null, true);
        int i = 0;
        while (i < fonts.length) {
            fontSet.add(fonts[i].getName());
            ++i;
        }
        this.input = new ArrayList();
        this.input.add(RichTextResources.fontNameAction_DefaultFontName);
        for (String fontName : fontSet) {
            this.input.add(fontName);
        }
        richText.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                String fontName = richText.getSelected().getFontName();
                if (fontName.equals(RichTextResources.fontNameAction_CSS_Default) || fontName.equals(RichTextResources.fontNameAction_CSS_Default_Mozilla) || fontName.equals("default")) {
                    fontName = RichTextResources.fontNameAction_DefaultFontName;
                }
                int index = FontNameAction.this.findFontNameInItems(fontName);
                FontNameAction.this.setNotifyListeners(false);
                FontNameAction.this.getCCombo().select(index);
                FontNameAction.this.setNotifyListeners(true);
            }
        });
    }

    private int findFontNameInItems(String fontName) {
        int index = -1;
        for (String font : this.input) {
            ++index;
            if (!font.equalsIgnoreCase(fontName)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public void execute(IRichText richText) {
        if (richText != null) {
            String selected = this.getCComboSelection();
            if (selected.equals(RichTextResources.fontNameAction_DefaultFontName)) {
                richText.executeCommand("setFontName", "");
            } else {
                richText.executeCommand("setFontName", selected);
            }
        }
    }

    @Override
    public Collection<String> getInput() {
        return this.input;
    }
}

