/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

import java.io.File;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.html.HTMLFormatter;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.RichTextSelection;
import org.eclipse.epf.richtext.actions.CopyAction;
import org.eclipse.epf.richtext.actions.CutAction;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.actions.PasteAction;
import org.eclipse.epf.richtext.actions.PastePlainTextAction;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichText
implements IRichText {
    private static final String ENCODED_SINGLE_QUOTE = "%sq%";
    private static final String ENCODED_NEWLINE = "%EOL%";
    protected static final String STATUS_PREFIX = "$$$";
    protected static final int STATUS_PREFIX_LENGTH = "$$$".length();
    protected static final int STATUS_NOP = 0;
    protected static final int STATUS_INITIALIZED = 1;
    protected static final int STATUS_MODIFIED = 2;
    protected static final int STATUS_GET_TEXT = 3;
    protected static final int STATUS_KEY_DOWN = 4;
    protected static final int STATUS_KEY_UP = 5;
    protected static final int STATUS_SELECT_TEXT = 6;
    protected static final int STATUS_SELECT_CONTROL = 7;
    protected static final int STATUS_SELECT_NONE = 8;
    protected static final int STATUS_EXEC_CMD = 9;
    protected static final int STATUS_REFORMAT_LINKS = 10;
    private static final String DEFAULT_BASE_PATH = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "rte";
    protected boolean debug;
    protected Logger logger;
    protected Browser editor;
    protected Control editorControl;
    protected static URL copyURL;
    protected Menu contextMenu;
    protected String rteFolder;
    protected String rteURL;
    protected String basePath;
    protected boolean initialized;
    protected boolean initializedWithFocus;
    protected String initialText;
    protected String currentText;
    protected boolean editable;
    protected boolean modified;
    protected boolean hasSelection;
    protected RichTextSelection richTextSelection;
    protected int status;
    protected HTMLFormatter htmlFormatter;
    protected Map<Listener, RichTextListener> listeners;
    protected List<ModifyListener> modifyListeners;
    protected boolean notifyingModifyListeners;
    protected boolean hasFocus;
    protected boolean processingJSEvent;
    protected boolean checkingModifyEvent;
    protected FindReplaceAction findReplaceAction;
    protected boolean isIE;

    public RichText(Composite parent, int style, String basePath) {
        block3: {
            this.currentText = "";
            this.editable = true;
            this.richTextSelection = new RichTextSelection();
            this.status = 0;
            this.notifyingModifyListeners = false;
            this.hasFocus = false;
            this.processingJSEvent = false;
            this.checkingModifyEvent = false;
            this.isIE = false;
            this.debug = RichTextPlugin.getDefault().isDebugging();
            this.logger = RichTextPlugin.getDefault().getLogger();
            this.findReplaceAction = new FindReplaceAction(this);
            this.rteFolder = String.valueOf(RichTextPlugin.getDefault().getInstallPath()) + "rte/";
            this.rteURL = XMLUtil.escape((String)("file://" + this.rteFolder));
            this.setBasePath(basePath);
            try {
                this.editor = new Browser(parent, 0);
                if (this.debug) {
                    this.printDebugMessage("RichText", "basePath=" + basePath);
                }
                this.editor.setLayoutData((Object)new GridData(1808));
                this.editor.setData("richText", (Object)this);
                this.init(parent, style);
            }
            catch (Exception e) {
                this.editor = null;
                String msg = "Failed to create RichText with basePath=" + basePath;
                this.logger.logError(msg, (Throwable)e);
                if (!this.debug) break block3;
                System.out.println(msg);
                e.printStackTrace();
            }
        }
    }

    public RichText(Composite parent, int style) {
        this(parent, style, null);
    }

    protected void setBasePath(String path) {
        this.basePath = path != null && path.length() > 0 ? (path.startsWith("\\\\") ? "\\\\" + FileUtil.appendSeparator((String)path.substring(FileUtil.UNC_PATH_PREFIX_LENGTH).replace('\\', '/'), (String)"/") : FileUtil.appendSeparator((String)path).replace('\\', '/')) : FileUtil.appendSeparator((String)DEFAULT_BASE_PATH).replace('\\', '/');
    }

    protected void init(Composite parent, int style) throws Exception {
        try {
            this.addStatusTextListener();
            if (this.debug) {
                this.printDebugMessage("init", "added status text listener");
            }
            String editorHTML = this.generateEditorHTML();
            if (this.debug) {
                this.printDebugMessage("init", "generated editor HTML");
            }
            this.editor.setText(editorHTML);
            if (this.debug) {
                this.printDebugMessage("init", "loaded editor HTML");
            }
            this.contextMenu = new Menu((Decorations)parent.getShell(), 8);
            this.editor.setMenu(this.contextMenu);
            this.fillContextMenu(this.contextMenu);
            if (this.debug) {
                this.printDebugMessage("init", "added context menu");
            }
            this.addListeners();
            if (this.debug) {
                this.printDebugMessage("init", "added listeners");
            }
            this.htmlFormatter = new HTMLFormatter();
            if (this.debug) {
                this.printDebugMessage("init", "instantiated HTMLFormatter");
            }
        }
        catch (Exception e) {
            this.editor = null;
            this.dispose();
            throw e;
        }
    }

    @Override
    public Control getControl() {
        return this.editor;
    }

    @Override
    public void setLayoutData(Object layoutData) {
        if (this.editor != null) {
            this.editor.setLayoutData(layoutData);
        }
    }

    @Override
    public Object getLayoutData() {
        if (this.editor != null) {
            return this.editor.getLayoutData();
        }
        return null;
    }

    @Override
    public void setFocus() {
        if (this.debug) {
            this.printDebugMessage("setFocus, editable=" + this.editable);
        }
        if (this.editor != null) {
            if (this.initialized) {
                if (!this.editor.isFocusControl()) {
                    if (!Platform.getOS().equals("win32")) {
                        this.editor.setFocus();
                    }
                    this.executeCommand("setFocus");
                }
                this.hasFocus = true;
            } else {
                this.initializedWithFocus = true;
            }
        }
    }

    @Override
    public void setBlur() {
        if (this.debug) {
            this.printDebugMessage("setBlur, editable=" + this.editable);
        }
        if (this.editor != null) {
            if (this.initialized) {
                this.hasFocus = false;
            } else {
                this.initializedWithFocus = false;
            }
        }
    }

    @Override
    public boolean hasFocus() {
        if (this.editor != null) {
            return this.hasFocus;
        }
        return false;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public URL getCopyURL() {
        return copyURL;
    }

    @Override
    public void setCopyURL() {
        try {
            copyURL = new File(this.basePath).toURL();
        }
        catch (Exception exception) {
            copyURL = null;
        }
    }

    @Override
    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        if (this.initialized) {
            this.executeCommand("setEditable", "" + editable);
        }
    }

    @Override
    public boolean getModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public String getText() {
        if (this.editor != null && this.initialized) {
            try {
                this.executeCommand("getText");
                if (this.currentText != null && this.currentText.length() > 0) {
                    this.currentText = this.currentText.replaceAll("<P>&nbsp;</P>", "<br/>");
                    this.currentText = this.tidyText(this.currentText);
                    this.currentText = this.formatHTML(this.currentText);
                } else {
                    this.currentText = "";
                }
                if (this.debug) {
                    this.printDebugMessage("getText", "text=", this.currentText);
                }
                return this.currentText;
            }
            catch (Exception e) {
                this.logger.logError((Throwable)e);
            }
        }
        return "";
    }

    protected String formatHTML(String text) {
        try {
            String formattedText = this.htmlFormatter.formatHTML(text);
            if (this.htmlFormatter.getLastErrorStr() != null) {
                this.logger.logError(this.htmlFormatter.getLastErrorStr());
            }
            return formattedText;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.logError((Throwable)e);
            return text;
        }
    }

    @Override
    public void setText(String text) {
        if (this.editor != null) {
            String newText;
            if (this.debug) {
                this.printDebugMessage("setText", "text=", text);
            }
            if ((newText = text) != null) {
                newText = this.tidyText(newText);
                newText = this.formatHTML(newText);
            } else {
                newText = "";
            }
            if (this.initialized) {
                this.modified = !newText.equals(this.currentText);
            }
            this.initialText = newText;
            if (this.initialText.equals("") && !this.isIE) {
                this.initialText = "<br />";
            }
            if (this.debug) {
                this.printDebugMessage("setText", "modified=" + this.modified + ", newText=", newText);
            }
            if (this.initialized) {
                try {
                    this.executeCommand("setText", newText);
                    this.executeCommand("setEditable", "" + this.editable);
                }
                catch (Exception e) {
                    this.logger.logError((Throwable)e);
                }
            }
            this.currentText = newText;
        }
    }

    @Override
    public void restoreText() {
        this.setText(this.initialText);
        this.modified = false;
    }

    public String getSelectedText() {
        return this.richTextSelection.getText();
    }

    @Override
    public RichTextSelection getSelected() {
        return this.richTextSelection;
    }

    @Override
    public Object getData(String key) {
        if (this.editor != null) {
            this.editor.getData(key);
        }
        return null;
    }

    @Override
    public void setData(String key, Object value) {
        if (this.editor != null) {
            this.editor.setData(key, value);
        }
    }

    protected int execute(final String script) {
        block6: {
            this.status = 0;
            if (this.editor != null && script != null && script.length() > 0) {
                try {
                    if (!this.isIE && this.processingJSEvent) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                if (!RichText.this.isDisposed()) {
                                    RichText.this.editor.execute(script);
                                }
                            }
                        });
                    } else {
                        this.editor.execute(script);
                    }
                    if (this.debug) {
                        this.printDebugMessage("execute", script);
                    }
                }
                catch (Exception e) {
                    String msg = "Failed to execute " + script;
                    this.logger.logError(msg, (Throwable)e);
                    if (!this.debug) break block6;
                    this.printDebugMessage("execute", msg);
                    e.printStackTrace();
                }
            }
        }
        return this.status;
    }

    @Override
    public int executeCommand(String command) {
        this.status = 0;
        if (command != null && command.equals("clearContent")) {
            String oldInitialText = this.initialText;
            this.setText("");
            this.initialText = oldInitialText;
            this.status = 1;
            this.modified = true;
            this.notifyModifyListeners();
        } else {
            this.status = this.execute(String.valueOf(command) + "();");
        }
        return this.status;
    }

    @Override
    public int executeCommand(String command, String param) {
        if (param == null) {
            return this.executeCommand(command);
        }
        return this.execute(String.valueOf(command) + "('" + this.formatText(param) + "');");
    }

    @Override
    public int executeCommand(String command, String[] params) {
        if (params == null || params.length == 0) {
            return this.executeCommand(command);
        }
        StringBuffer sb = new StringBuffer();
        int paramsLength = params.length;
        int i = 0;
        while (i < paramsLength) {
            sb.append('\'').append(this.formatText(params[i])).append('\'');
            if (i < paramsLength - 1) {
                sb.append(',');
            }
            ++i;
        }
        String param = sb.toString();
        return this.execute(String.valueOf(command) + "(" + param + ");");
    }

    @Override
    public void dispose() {
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.modifyListeners != null) {
            this.modifyListeners.clear();
            this.modifyListeners = null;
        }
        if (this.htmlFormatter != null) {
            this.htmlFormatter = null;
        }
        if (this.findReplaceAction != null) {
            this.findReplaceAction.dispose();
            this.findReplaceAction = null;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.editor.isDisposed();
    }

    @Override
    public Iterator<ModifyListener> getModifyListeners() {
        return this.modifyListeners.iterator();
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        if (this.editor != null) {
            this.editor.addKeyListener(listener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        if (this.editor != null) {
            this.editor.removeKeyListener(listener);
        }
    }

    @Override
    public void addModifyListener(ModifyListener listener) {
        if (this.editor != null && listener != null && !this.modifyListeners.contains(listener)) {
            this.modifyListeners.add(listener);
        }
    }

    @Override
    public void removeModifyListener(ModifyListener listener) {
        if (this.editor != null && listener != null && this.modifyListeners.contains(listener)) {
            this.modifyListeners.remove(listener);
        }
    }

    @Override
    public void addDisposeListener(DisposeListener listener) {
        if (this.editor != null) {
            this.editor.addDisposeListener(listener);
        }
    }

    @Override
    public void removeDisposeListener(DisposeListener listener) {
        if (this.editor != null) {
            this.editor.removeDisposeListener(listener);
        }
    }

    @Override
    public void addHelpListener(HelpListener listener) {
        if (this.editor != null) {
            this.editor.addHelpListener(listener);
        }
    }

    @Override
    public void removeHelpListener(HelpListener listener) {
        if (this.editor != null) {
            this.editor.removeHelpListener(listener);
        }
    }

    @Override
    public void addListener(int eventType, Listener listener) {
        if (this.editor != null && !this.listeners.containsKey(listener)) {
            if (eventType != 2 && (this.editorControl == null || eventType != 26 && eventType != 27 && eventType != 15 && eventType != 16)) {
                this.editor.addListener(eventType, listener);
            }
            this.listeners.put(listener, new RichTextListener(eventType, listener));
        }
    }

    @Override
    public void removeListener(int eventType, Listener listener) {
        if (this.editor != null && this.listeners.containsKey(listener)) {
            if (this.editorControl == null || eventType != 26 && eventType != 27 && eventType != 15 && eventType != 16) {
                this.editor.removeListener(eventType, listener);
            }
            this.listeners.remove(listener);
        }
    }

    @Override
    public Iterator<RichTextListener> getListeners() {
        return this.listeners.values().iterator();
    }

    protected void addStatusTextListener() {
        this.editor.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                String eventText = event.text;
                int eventTextLength = eventText.length();
                if (eventText.startsWith(RichText.STATUS_PREFIX) && eventTextLength > STATUS_PREFIX_LENGTH) {
                    try {
                        try {
                            RichText.this.processingJSEvent = true;
                            int endStatusIndex = STATUS_PREFIX_LENGTH + 1;
                            if (eventText.length() > STATUS_PREFIX_LENGTH + 1 && Character.isDigit(eventText.charAt(endStatusIndex))) {
                                ++endStatusIndex;
                            }
                            int statusType = Integer.parseInt(eventText.substring(STATUS_PREFIX_LENGTH, endStatusIndex));
                            switch (statusType) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    if (!RichText.this.initialized) {
                                        RichText.this.initialized = true;
                                        if (RichText.this.debug) {
                                            RichText.this.printDebugMessage("statusTextListener", "STATUS_INITIALIZED");
                                        }
                                        if (!Platform.getOS().equals("win32")) {
                                            RichText.this.executeCommand("setHeight", "" + RichText.this.editor.getBounds().height);
                                        }
                                        RichText.this.executeCommand("setText", RichText.this.currentText);
                                        if (RichText.this.initializedWithFocus) {
                                            RichText.this.setFocus();
                                        }
                                        if (!RichText.this.editable) {
                                            RichText.this.executeCommand("setEditable", "" + RichText.this.editable);
                                        }
                                    }
                                    break;
                                }
                                case 2: {
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_MODIFIED");
                                    }
                                    RichText.this.checkModify();
                                    break;
                                }
                                case 3: {
                                    RichText.this.currentText = eventTextLength >= STATUS_PREFIX_LENGTH + 2 ? eventText.substring(STATUS_PREFIX_LENGTH + 2) : "";
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_GET_TEXT, currentText=", RichText.this.currentText);
                                    }
                                    break;
                                }
                                case 4: {
                                    if (eventTextLength >= STATUS_PREFIX_LENGTH + 2) {
                                        String cmd = eventText.substring(STATUS_PREFIX_LENGTH + 2);
                                        if (RichText.this.debug) {
                                            RichText.this.printDebugMessage("statusTextListener", "STATUS_KEY_DOWN, cmd=" + cmd);
                                        }
                                        if (cmd.equals("copy")) {
                                            RichText.this.setCopyURL();
                                            break;
                                        }
                                        if (cmd.equals("cut")) {
                                            RichText.this.setCopyURL();
                                            CutAction action = new CutAction(RichText.this);
                                            action.execute(RichText.this);
                                            break;
                                        }
                                        if (cmd.equals("findText")) {
                                            RichText.this.getFindReplaceAction().execute(RichText.this);
                                            break;
                                        }
                                        if (cmd.equals("paste")) {
                                            PasteAction action = new PasteAction(RichText.this);
                                            action.execute(RichText.this);
                                            break;
                                        }
                                        if (cmd.equals("save")) {
                                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().doSave(null);
                                            break;
                                        }
                                        if (cmd.equals("saveAll")) {
                                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(false);
                                        }
                                    }
                                    break;
                                }
                                case 5: {
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_KEY_UP, modified=" + RichText.this.modified);
                                    }
                                    RichText.this.checkModify();
                                    break;
                                }
                                case 6: {
                                    if (eventTextLength >= STATUS_PREFIX_LENGTH + 2) {
                                        String[] strings = eventText.substring(STATUS_PREFIX_LENGTH + 2).split("\\$", 5);
                                        try {
                                            RichText.this.richTextSelection.setFontName(strings[0]);
                                            RichText.this.richTextSelection.setFontSize(strings[1]);
                                            RichText.this.richTextSelection.setBlockStyle(strings[2]);
                                            RichText.this.richTextSelection.setFlags(Integer.parseInt(strings[3]));
                                            RichText.this.richTextSelection.setText(strings[4]);
                                        }
                                        catch (NumberFormatException e) {
                                            RichText.this.logger.logError((Throwable)e);
                                        }
                                        if (RichText.this.debug) {
                                            RichText.this.printDebugMessage("selectionStatusListener", "current selection is=" + RichText.this.richTextSelection);
                                        }
                                        RichText.this.hasSelection = true;
                                        if (RichText.this.hasFocus()) {
                                            RichText.this.notifyListeners(2, new Event());
                                        }
                                    } else {
                                        RichText.this.richTextSelection.setText("");
                                        RichText.this.hasSelection = false;
                                    }
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_SELECT_TEXT, selectedText=", RichText.this.richTextSelection.getText());
                                    }
                                    break;
                                }
                                case 7: {
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_SELECT_CONTROL, control selected");
                                    }
                                    RichText.this.hasSelection = true;
                                    break;
                                }
                                case 8: {
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_SELECT_NONE, no selection");
                                    }
                                    RichText.this.hasSelection = false;
                                    break;
                                }
                                case 9: {
                                    if (eventTextLength >= STATUS_PREFIX_LENGTH + 3) {
                                        try {
                                            RichText.this.status = Integer.parseInt(eventText.substring(STATUS_PREFIX_LENGTH + 2, STATUS_PREFIX_LENGTH + 3));
                                        }
                                        catch (Exception exception) {
                                            RichText.this.status = -1;
                                        }
                                    }
                                    if (RichText.this.debug && RichText.this.status != 1) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_EXEC_CMD, status=" + RichText.this.status);
                                    }
                                    break;
                                }
                                case 10: {
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_REFORMAT_LINKS");
                                    }
                                    if (Platform.getOS().equals("win32") && RichText.this.modified) {
                                        RichText.this.setText(RichText.this.getText());
                                        RichText.this.modified = true;
                                    }
                                    RichText.this.checkModify();
                                }
                            }
                        }
                        catch (Exception exception) {
                            RichText.this.processingJSEvent = false;
                        }
                    }
                    finally {
                        RichText.this.processingJSEvent = false;
                    }
                }
            }
        });
    }

    protected String generateEditorHTML() throws Exception {
        String escapedBasePath = this.basePath;
        if (escapedBasePath.startsWith("\\\\")) {
            escapedBasePath = escapedBasePath.replaceFirst("^\\\\\\\\", "\\\\\\\\\\\\\\\\");
        }
        escapedBasePath = XMLUtil.escape((String)("file://" + escapedBasePath.replaceAll("'", "\\\\'")));
        String escapedRteUTL = this.rteURL.replaceAll("&apos;", "%27");
        StringBuffer rteXML = new StringBuffer();
        rteXML.append("<rte id=\"").append("rte").append("\" css=\"").append(String.valueOf(escapedRteUTL) + "rte.css").append("\" js=\"").append(String.valueOf(escapedRteUTL) + "rte.js").append("\" baseURL=\"").append(escapedBasePath).append("\"/>");
        StringWriter result = new StringWriter();
        XSLTProcessor.transform((String)(String.valueOf(this.rteFolder) + "rte.xsl"), (String)rteXML.toString(), (Writer)result);
        return result.toString();
    }

    protected void fillContextMenu(Menu contextMenu) {
        final MenuItem cutItem = new MenuItem(contextMenu, 8);
        cutItem.setText(RichTextResources.cutAction_text);
        cutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CutAction action = new CutAction(RichText.this);
                action.execute(RichText.this);
            }
        });
        final MenuItem copyItem = new MenuItem(contextMenu, 8);
        copyItem.setText(RichTextResources.copyAction_text);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CopyAction action = new CopyAction(RichText.this);
                action.execute(RichText.this);
            }
        });
        final MenuItem pasteItem = new MenuItem(contextMenu, 8);
        pasteItem.setText(RichTextResources.pasteAction_text);
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PasteAction action = new PasteAction(RichText.this);
                action.execute(RichText.this);
            }
        });
        final MenuItem pastePlainTextItem = new MenuItem(contextMenu, 8);
        pastePlainTextItem.setText(RichTextResources.pastePlainTextAction_text);
        pastePlainTextItem.setImage(RichTextImages.IMG_PASTE_PLAIN_TEXT);
        pastePlainTextItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PastePlainTextAction action = new PastePlainTextAction(RichText.this);
                action.execute(RichText.this);
            }
        });
        contextMenu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                RichText.this.getSelectedText();
                cutItem.setEnabled(RichText.this.editable && RichText.this.hasSelection);
                copyItem.setEnabled(RichText.this.hasSelection);
                pasteItem.setEnabled(RichText.this.editable);
                pastePlainTextItem.setEnabled(RichText.this.editable);
            }
        });
    }

    protected void addListeners() {
        this.editorControl = this.getControlSite((Composite)this.editor);
        if (this.editorControl != null) {
            if (this.debug) {
                this.printDebugMessage("init", "editorControl=" + this.editorControl.getClass().getName());
            }
            this.isIE = true;
            this.editorControl.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("activateListener");
                    }
                    RichText.this.setFocus();
                    RichText.this.notifyListeners(26, event);
                }
            });
            this.editorControl.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("deactivateListener");
                    }
                    RichText.this.setBlur();
                    RichText.this.notifyListeners(27, event);
                }
            });
            this.editorControl.addListener(15, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("focusInListener");
                    }
                    RichText.this.executeCommand("updateSelection");
                    RichText.this.notifyListeners(15, event);
                }
            });
            this.editorControl.addListener(2, new Listener(){

                public void handleEvent(Event event) {
                    int keyCode = event.keyCode;
                    int stateMask = event.stateMask;
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("keyUpListener", "keyCode=" + keyCode + ", stateMask=" + stateMask + ", editable=" + RichText.this.editable);
                    }
                    if ((stateMask & 0x40000) > 0 || (stateMask & 0x10000) > 0 || (stateMask & 0x20000) > 0 && keyCode == stateMask) {
                        return;
                    }
                    if (RichText.this.editable) {
                        switch (event.keyCode) {
                            case 9: 
                            case 0x1000001: 
                            case 0x1000002: 
                            case 0x1000003: 
                            case 0x1000004: 
                            case 0x1000005: 
                            case 0x1000006: 
                            case 0x1000007: 
                            case 0x1000008: {
                                return;
                            }
                        }
                        RichText.this.checkModify();
                    }
                }
            });
            this.editor.addLocationListener((LocationListener)new LocationAdapter(){

                public void changing(LocationEvent event) {
                    event.doit = RichText.this.editable;
                }
            });
        } else {
            this.editor.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("activateListener");
                    }
                    RichText.this.setFocus();
                }
            });
            this.editor.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 9) {
                        if ((e.stateMask & 0x20000) != 0) {
                            RichText.this.editor.traverse(8);
                        } else {
                            RichText.this.editor.traverse(16);
                        }
                        return;
                    }
                    if (!RichText.this.editable) {
                        e.doit = false;
                    }
                }

                public void keyReleased(KeyEvent e) {
                    if ((e.stateMask & 0x40000) > 0 || (e.stateMask & 0x10000) > 0) {
                        return;
                    }
                    if (RichText.this.editable) {
                        switch (e.keyCode) {
                            case 9: 
                            case 131072: 
                            case 0x1000001: 
                            case 0x1000002: 
                            case 0x1000003: 
                            case 0x1000004: 
                            case 0x1000005: 
                            case 0x1000006: 
                            case 0x1000007: 
                            case 0x1000008: {
                                break;
                            }
                            default: {
                                RichText.this.checkModify();
                            }
                        }
                    }
                }
            });
        }
        this.editor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (RichText.this.debug) {
                    RichText.this.printDebugMessage("disposeListener");
                }
                RichText.this.dispose();
            }
        });
        this.listeners = new Hashtable<Listener, RichTextListener>();
        this.modifyListeners = new ArrayList<ModifyListener>();
    }

    protected void notifyListeners(int eventType, Event event) {
        if (this.notifyingModifyListeners) {
            return;
        }
        if (this.listeners != null) {
            event.display = Display.getCurrent();
            event.widget = this.editor;
            for (RichTextListener listener : this.listeners.values()) {
                if (listener.getEventType() != eventType) continue;
                if (this.debug) {
                    this.printDebugMessage("notifyListeners", "notifying listener, " + listener + ", eventType=" + eventType);
                }
                listener.getListener().handleEvent(event);
                if (!this.debug) continue;
                this.printDebugMessage("notifyListeners", "notified listener, " + listener + ", eventType=" + eventType);
            }
        }
    }

    @Override
    public void notifyModifyListeners() {
        this.notifyingModifyListeners = true;
        Event event = new Event();
        event.display = Display.getCurrent();
        event.widget = this.editor;
        for (ModifyListener listener : this.modifyListeners) {
            if (this.debug) {
                this.printDebugMessage("notifyModifyListeners", "notifying listener, " + listener);
            }
            listener.modifyText(new ModifyEvent(event));
            if (!this.debug) continue;
            this.printDebugMessage("notifyModifyListeners", "notified listener, " + listener);
        }
        this.notifyingModifyListeners = false;
    }

    @Override
    public void checkModify() {
        try {
            if (!this.checkingModifyEvent) {
                this.checkingModifyEvent = true;
                if (this.modified) {
                    this.notifyModifyListeners();
                } else if (!this.isIE && this.processingJSEvent) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            if (!RichText.this.getText().equals(RichText.this.initialText)) {
                                RichText.this.modified = true;
                                RichText.this.notifyModifyListeners();
                            }
                        }
                    });
                } else if (!this.getText().equals(this.initialText)) {
                    this.modified = true;
                    this.notifyModifyListeners();
                }
                if (this.debug) {
                    this.printDebugMessage("checkModify", "modified=" + this.modified);
                }
            }
        }
        finally {
            this.checkingModifyEvent = false;
        }
    }

    protected String tidyText(String text) {
        return text;
    }

    protected String formatText(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int textSize = text.length();
        int i = 0;
        while (i < textSize) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\r': {
                    break;
                }
                case '\t': {
                    result.append(' ');
                    break;
                }
                case '\n': {
                    result.append(ENCODED_NEWLINE);
                    break;
                }
                case '\'': {
                    result.append(ENCODED_SINGLE_QUOTE);
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                default: {
                    result.append(ch);
                }
            }
            ++i;
        }
        return result.toString();
    }

    protected Control getControlSite(Composite composite) {
        if (Platform.getOS().equals("win32")) {
            Control[] controls = composite.getChildren();
            int i = 0;
            while (i < controls.length) {
                String controlClass = controls[i].getClass().getName();
                if (controlClass.equals("org.eclipse.swt.browser.WebSite")) {
                    return controls[i];
                }
                if (controls[i] instanceof Composite) {
                    return this.getControlSite((Composite)controls[i]);
                }
                ++i;
            }
        }
        return null;
    }

    protected void printDebugMessage(String method, String msg, String text) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("RichText[").append(this.editor.handle).append(']').append('.').append(method);
        if (msg != null && msg.length() > 0) {
            strBuf.append(": ").append(msg);
        }
        if (text != null && text.length() > 0) {
            strBuf.append('\n').append(text);
        }
        System.out.println(strBuf);
    }

    protected void printDebugMessage(String method, String msg) {
        this.printDebugMessage(method, msg, null);
    }

    protected void printDebugMessage(String method) {
        this.printDebugMessage(method, null);
    }

    @Override
    public FindReplaceAction getFindReplaceAction() {
        return this.findReplaceAction;
    }

    @Override
    public void setFindReplaceAction(FindReplaceAction findReplaceAction) {
        if (findReplaceAction != null) {
            if (this.findReplaceAction != null && this.findReplaceAction != findReplaceAction) {
                this.findReplaceAction.dispose();
            }
            this.findReplaceAction = findReplaceAction;
            this.findReplaceAction.setRichText(this);
        }
    }

    @Override
    public void setInitialText(String text) {
        this.setText(text);
        this.initialText = text == null ? "" : text;
        this.modified = false;
    }
}

