/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextComboAction;
import org.eclipse.epf.richtext.html.FontStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontStyleAction
extends RichTextComboAction {
    public FontStyleAction(final IRichText richText) {
        super(richText);
        this.setToolTipText(RichTextResources.fontStyleAction_toolTipText);
        this.input = new ArrayList();
        this.input.add(FontStyle.NORMAL.getName());
        this.input.add(FontStyle.SECTION_HEADING.getName());
        this.input.add(FontStyle.SUBSECTION_HEADING.getName());
        this.input.add(FontStyle.SUB_SUBSECTION_HEADING.getName());
        this.input.add(FontStyle.QUOTE.getName());
        this.input.add(FontStyle.CODE_SAMPLE.getName());
        richText.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                String blockStyle = richText.getSelected().getBlockStyle();
                String name = FontStyle.getFontStyleName(blockStyle);
                int index = ((List)FontStyleAction.this.input).indexOf(name);
                FontStyleAction.this.setNotifyListeners(false);
                FontStyleAction.this.getCCombo().select(index);
                FontStyleAction.this.setNotifyListeners(true);
            }
        });
    }

    @Override
    public void execute(IRichText richText) {
        if (richText != null) {
            String selected = this.getCComboSelection();
            String value = FontStyle.getFontStyleValue(selected);
            richText.executeCommand("setFontStyle", value);
        }
    }

    @Override
    public Collection<String> getInput() {
        return this.input;
    }
}

