/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.io.PrintStream;

public class ProfilingUtil {
    public static boolean traceFootprint = false;
    private static PrintStream output = System.out;

    public static void setOutput(PrintStream ps) {
        output = ps;
    }

    public static void fullGC() {
        long wasFree;
        Runtime rt = Runtime.getRuntime();
        long isFree = rt.freeMemory();
        do {
            wasFree = isFree;
            rt.runFinalization();
            rt.gc();
        } while ((isFree = rt.freeMemory()) > wasFree);
    }

    public static long traceUsedMemory(String location) {
        Runtime rt = Runtime.getRuntime();
        long usedMem = rt.totalMemory() - rt.freeMemory();
        output.println("Footprint> " + location + ": " + usedMem / 1000L + " K");
        return usedMem;
    }

    public static long traceUsedMemoryDiff(String locationInfo, long currUsed, long PrevUsed) {
        long diff = currUsed - PrevUsed;
        output.println("Footprint> Diff, " + locationInfo + ": " + diff / 1000L + " K\n");
        return diff;
    }
}

