/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.epf.common.IActivator;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.I18nUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractPlugin
extends AbstractUIPlugin
implements IActivator {
    private static final String ICON_PATH = "icons/";
    private static Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static Map<String, MsgDialog> msgDialogs = new HashMap<String, MsgDialog>();
    private static Map<String, Image> sharedImages = new HashMap<String, Image>();
    private ResourceBundle resourceBundle;
    private String pluginId;
    private URL installURL;
    private String installPath;
    private URL iconURL;
    private boolean profiling;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.init(context);
        if (this.isDebugging()) {
            this.getLogger().logInfo("Started " + this.pluginId);
        }
    }

    public void stop(BundleContext context) throws Exception {
        for (Image image : sharedImages.values()) {
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
        super.stop(context);
        if (this.isDebugging()) {
            this.getLogger().logInfo("Stopped " + this.pluginId);
        }
    }

    protected void init(BundleContext context) throws Exception {
        Bundle bundle = this.getBundle();
        this.resourceBundle = Platform.getResourceBundle((Bundle)bundle);
        this.pluginId = bundle.getSymbolicName();
        if (this.isDebugging()) {
            this.getLogger().logInfo("Initializing " + this.pluginId);
        }
        this.installURL = bundle.getEntry("/");
        try {
            this.installPath = FileLocator.resolve((URL)this.installURL).getPath();
        }
        catch (IOException iOException) {
            this.installPath = Platform.getInstallLocation().getURL().getPath();
        }
        try {
            this.iconURL = new URL(this.installURL, ICON_PATH);
        }
        catch (IOException iOException) {}
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            String key = String.valueOf(symbolicName) + "/profiling";
            String value = InternalPlatform.getDefault().getOption(key);
            boolean bl = this.profiling = value == null ? false : value.equalsIgnoreCase("true");
        }
        if (this.isDebugging()) {
            this.getLogger().logInfo("Initialized " + this.pluginId + ", installPath=" + this.installPath);
        }
    }

    public String getId() {
        return this.pluginId;
    }

    public URL getInstallURL() {
        return this.installURL;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public Properties getProperties(String path) throws IOException {
        Properties props = new Properties();
        if (path == null) {
            return props;
        }
        String filePath = this.getLocalizedFile(path, true);
        if (filePath != null) {
            props.load(new FileInputStream(filePath));
        }
        return props;
    }

    public String getLocalizedFile(String path, boolean useDefault) throws IOException {
        URL url;
        URL entry;
        String filePath = null;
        String fileName = FileUtil.getFileName((String)path);
        int index = path.lastIndexOf(fileName);
        String pathName = path.substring(0, index);
        Locale locale = Locale.getDefault();
        Bundle bundle = this.getBundle();
        Bundle[] bundles = Platform.getFragments((Bundle)bundle);
        if (bundles != null) {
            int i = 0;
            while (i < bundles.length) {
                URL url2;
                URL entry2 = bundles[i].getEntry(pathName);
                if (entry2 != null && (filePath = I18nUtil.getLocalizedFile((String)(String.valueOf((url2 = FileLocator.resolve((URL)entry2)).getPath()) + fileName), (Locale)locale)) != null) break;
                ++i;
            }
        }
        if (filePath == null && (entry = bundle.getEntry(path)) != null && (filePath = I18nUtil.getLocalizedFile((String)(url = FileLocator.resolve((URL)entry)).getPath(), (Locale)locale)) == null && useDefault) {
            filePath = url.getPath();
        }
        return filePath;
    }

    public void copyLocalizedFiles(String path, File toDir, boolean recursive, boolean useLocaleFileName) throws IOException {
        String pluginPath = this.getInstallPath();
        URI pluginUri = new File(pluginPath).toURI();
        URI pathUri = new File(pluginPath, path).toURI();
        ArrayList files = new ArrayList();
        File f = new File(pluginPath, path);
        FileUtil.getAllFiles((File)f, files, (boolean)recursive);
        Iterator it = files.iterator();
        while (it.hasNext()) {
            URI srcUri = ((File)it.next()).toURI();
            String relPath = pluginUri.relativize(srcUri).getPath();
            String localizedFile = this.getLocalizedFile(relPath, false);
            if (localizedFile == null) continue;
            relPath = pathUri.relativize(srcUri).getPath();
            File srcFile = new File(localizedFile);
            File targetFile = new File(toDir, relPath);
            File targetParent = targetFile.getParentFile();
            if (useLocaleFileName) {
                String fileName = srcFile.getName();
                targetFile = new File(targetParent, fileName);
            }
            if (this.isDebugging()) {
                System.out.println("Copying localized file: ");
                System.out.println("Source: " + srcFile);
                System.out.println("Target: " + targetFile);
                System.out.println("");
            }
            try {
                if (!targetParent.exists()) {
                    targetParent.mkdirs();
                }
                if (!targetFile.exists()) {
                    targetFile.createNewFile();
                }
                FileUtil.copyFile((File)srcFile, (File)targetFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getString(String key) {
        if (this.resourceBundle != null) {
            try {
                return this.resourceBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return String.valueOf('[') + key + ']';
    }

    public String formatMessage(String key, Object argument) {
        if (this.resourceBundle != null) {
            try {
                String msg = this.resourceBundle.getString(key);
                Object[] arguments = new Object[]{argument};
                return MessageFormat.format(msg, arguments);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return String.valueOf('[') + key + ']';
    }

    public URL getImageURL(String relativePath) {
        try {
            URL url = new URL(this.iconURL, relativePath);
            return FileLocator.resolve((URL)url);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ImageDescriptor getImageDescriptor(String relativePath) {
        try {
            URL url = new URL(this.iconURL, relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public Image getImage(String relativePath) {
        Image image = null;
        ImageDescriptor imageDescriptor = this.getImageDescriptor(relativePath);
        if (imageDescriptor != null) {
            image = imageDescriptor.createImage(false);
        }
        return image;
    }

    public Image getSharedImage(String relativePath) {
        Image image = sharedImages.get(relativePath);
        if (image != null) {
            return image;
        }
        ImageDescriptor imageDescriptor = this.getImageDescriptor(relativePath);
        if (imageDescriptor != null && (image = imageDescriptor.createImage(false)) != null) {
            sharedImages.put(relativePath, image);
        }
        return image;
    }

    public boolean isProfiling() {
        return this.profiling;
    }

    public Logger getLogger() {
        Logger logger = loggers.get(this.pluginId);
        if (logger == null) {
            logger = new Logger((Plugin)this);
            loggers.put(this.pluginId, logger);
        }
        return logger;
    }

    public static MsgDialog getMsgDialog(IActivator plugin) {
        MsgDialog msgDialog = msgDialogs.get(plugin.getId());
        if (msgDialog == null) {
            msgDialog = new MsgDialog(plugin);
            msgDialogs.put(plugin.getId(), msgDialog);
        }
        return msgDialog;
    }

    public MsgDialog getMsgDialog() {
        return AbstractPlugin.getMsgDialog(this);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

