/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

public class RichTextSelection {
    protected String text = "";
    protected int offsetStart = 0;
    protected String fontName = "";
    protected String fontSize = "";
    protected String blockStyle = "";
    protected int flags = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int SUBSCRIPT = 8;
    public static final int SUPERSCRIPT = 16;

    public String getBlockStyle() {
        return this.blockStyle;
    }

    public void setBlockStyle(String blockStyle) {
        this.blockStyle = blockStyle;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public int getOffsetStart() {
        return this.offsetStart;
    }

    public void setOffsetStart(int offsetStart) {
        this.offsetStart = offsetStart;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isBold() {
        return (this.flags & 1) != 0;
    }

    public boolean isItalic() {
        return (this.flags & 2) != 0;
    }

    public boolean isUnderLine() {
        return (this.flags & 4) != 0;
    }

    public boolean isSubscript() {
        return (this.flags & 8) != 0;
    }

    public boolean isSuperscript() {
        return (this.flags & 0x10) != 0;
    }

    public void clear() {
        this.text = "";
        this.offsetStart = 0;
        this.fontName = "";
        this.fontSize = "";
        this.blockStyle = "";
        this.flags = 0;
    }

    public String toString() {
        String str = "Text: " + this.text + "\n";
        str = String.valueOf(str) + "fontName: " + this.fontName + "\n";
        str = String.valueOf(str) + "fontSize: " + this.fontSize + "\n";
        str = String.valueOf(str) + "blockStyle: " + this.blockStyle + "\n";
        str = String.valueOf(str) + "flags: " + this.flags + "\n";
        return str;
    }
}

