/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.dialogs;

import java.io.File;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.epf.richtext.html.Image;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddImageDialog
extends BaseDialog {
    protected Image image = new Image();
    protected Text urlText;
    protected Button browseButton;
    protected SelectionAdapter browseSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
            dialog.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.bmp"});
            String imageFile = dialog.open();
            if (imageFile != null && imageFile.length() > 0) {
                File file = new File(imageFile);
                try {
                    String url = file.toURL().toExternalForm();
                    AddImageDialog.this.urlText.setText(url);
                }
                catch (Exception e) {
                    AddImageDialog.this.logger.logError((Throwable)e);
                }
            }
        }
    };
    protected ModifyListener urlTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (AddImageDialog.this.okButton != null) {
                AddImageDialog.this.okButton.setEnabled(AddImageDialog.this.urlText.getText().trim().length() > 0);
            }
        }
    };

    public AddImageDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 3;
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(RichTextResources.urlLabel_text);
        this.urlText = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        this.urlText.setLayoutData((Object)gridData);
        this.urlText.addModifyListener(this.urlTextListener);
        this.browseButton = new Button(composite, 0);
        this.browseButton.setText(RichTextResources.browseButton_text);
        this.browseButton.addSelectionListener((SelectionListener)this.browseSelectionAdapter);
        super.getShell().setText(RichTextResources.addImageDialog_title);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
        String url = this.urlText.getText();
        if (url != null && url.length() > 0) {
            this.image.setURL(url);
        }
        super.okPressed();
    }

    public Image getImage() {
        return this.image;
    }
}

