/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.ui.util;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.common.ui.util.CommonPreferences;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceUtil {
    private static final String PREFERENCE_DELIMITER = ";";

    public static List<String> getList(IPreferenceStore prefStore, String name) {
        ArrayList<String> values = new ArrayList<String>();
        if (prefStore != null && name != null) {
            String value = prefStore.getString(name);
            StringTokenizer tokenizer = new StringTokenizer(value, PREFERENCE_DELIMITER);
            int tokenCount = tokenizer.countTokens();
            int i = 0;
            while (i < tokenCount) {
                values.add(tokenizer.nextToken());
                ++i;
            }
        }
        return values;
    }

    public static String[] getStringValues(IPreferenceStore prefStore, String name) {
        List<String> list = PreferenceUtil.getList(prefStore, name);
        String[] values = new String[list.size()];
        list.toArray(values);
        return values;
    }

    public static void setList(IPreferenceStore prefStore, String name, List values) {
        if (prefStore != null && name != null && values != null) {
            StringBuffer buffer = new StringBuffer();
            for (String value : values) {
                buffer.append(value);
                buffer.append(PREFERENCE_DELIMITER);
            }
            prefStore.setValue(name, buffer.toString());
        }
    }

    public static void addToList(IPreferenceStore prefStore, String name, String value, String defaultValue) {
        if (prefStore != null && name != null && value != null) {
            List<String> list = PreferenceUtil.getList(prefStore, name);
            list.remove(value);
            list.add(0, value);
            int preferenceHistorySize = CommonPreferences.getPreferenceHistorySize();
            if (list.size() > preferenceHistorySize) {
                list = list.subList(0, preferenceHistorySize - 1);
            }
            if (defaultValue != null && defaultValue.length() > 0 && !list.contains(defaultValue)) {
                if (list.size() == preferenceHistorySize) {
                    list.add(list.size() - 1, defaultValue);
                } else {
                    list.add(defaultValue);
                }
            }
            PreferenceUtil.setList(prefStore, name, list);
        }
    }

    public static void addToList(IPreferenceStore prefStore, String name, String value) {
        PreferenceUtil.addToList(prefStore, name, value, null);
    }

    public static void setStringValues(IPreferenceStore prefStore, String name, String[] values) {
        if (prefStore != null && name != null && values != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < values.length) {
                buffer.append(values[i]);
                buffer.append(PREFERENCE_DELIMITER);
                ++i;
            }
            prefStore.setValue(name, buffer.toString());
        }
    }
}

