/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class PastePlainTextAction
extends RichTextAction {
    public PastePlainTextAction(IRichText richText) {
        super(richText, 1);
        this.setImageDescriptor(RichTextImages.IMG_DESC_PASTE_PLAIN_TEXT);
        this.setDisabledImageDescriptor(RichTextImages.DISABLED_IMG_DESC_PASTE_PLAIN_TEXT);
        this.setToolTipText(RichTextResources.pastePlainTextAction_toolTipText);
        this.setEnabled(true);
    }

    public boolean disableInSourceMode() {
        return false;
    }

    public void execute(IRichText richText) {
        Clipboard clipboard;
        String text;
        if (richText != null && (text = (String)(clipboard = new Clipboard(Display.getCurrent())).getContents((Transfer)TextTransfer.getInstance())) != null && text.length() > 0) {
            text = StrUtil.convertNewlinesToHTML((String)text);
            if (richText instanceof RichTextEditor) {
                ((RichTextEditor)richText).addHTML(text);
            } else {
                richText.executeCommand("addHTML", text);
            }
        }
    }
}

