/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LaunchConfigurationPropertiesDialog
extends LaunchConfigurationsDialog
implements ILaunchConfigurationListener {
    private ILaunchConfiguration fLaunchConfiguration;

    public LaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration launchConfiguration, LaunchGroupExtension group) {
        super(shell, group);
        this.fLaunchConfiguration = launchConfiguration;
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public LaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration launchConfiguration, LaunchGroupExtension group, Set reservednames) {
        super(shell, group);
        this.fLaunchConfiguration = launchConfiguration;
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        this.fReservedNames = reservednames;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.resize();
    }

    protected void initializeContent() {
        ILaunchConfiguration launchConfiguration = this.getLaunchConfiguration();
        if (this.shouldSetDefaultsOnOpen() && launchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
            ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)launchConfiguration;
            this.doSetDefaults(wc);
        }
        this.getTabViewer().setInput(launchConfiguration);
        IStatus status = this.getInitialStatus();
        if (status != null) {
            this.handleStatus(status);
        }
    }

    public boolean close() {
        if (!this.isSafeToClose()) {
            return false;
        }
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        return super.close();
    }

    protected void addContent(Composite dialogComp) {
        Composite topComp = new Composite(dialogComp, 0);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        topLayout.marginHeight = 5;
        topLayout.marginWidth = 5;
        topComp.setLayout((Layout)topLayout);
        topComp.setFont(dialogComp.getFont());
        this.setTitle(this.getTitleAreaTitle());
        this.setMessage("");
        this.setModeLabelState();
        Composite editAreaComp = this.createLaunchConfigurationEditArea(topComp);
        gd = new GridData(1808);
        editAreaComp.setLayoutData((Object)gd);
        editAreaComp.setFont(dialogComp.getFont());
        dialogComp.layout(true);
        LaunchConfigurationPropertiesDialog.applyDialogFont((Control)dialogComp);
    }

    protected String getTitleAreaTitle() {
        return LaunchConfigurationsMessages.LaunchConfigurationPropertiesDialog_Edit_launch_configuration_properties_1;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected String getShellTitle() {
        return LaunchConfigurationsMessages.LaunchConfigurationPropertiesDialog_Properties_for__0__2;
    }

    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.launch_configuration_properties_dialog";
    }

    public void updateButtons() {
        this.getTabViewer().refresh();
        this.getButton(0).setEnabled(this.getTabViewer().canSave());
    }

    protected void okPressed() {
        this.getTabViewer().handleApplyPressed();
        super.okPressed();
    }

    public int open() {
        this.setOpenMode(-1);
        return super.open();
    }

    protected String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.LAUNCH_CONFIGURATION_PROPERTIES_DIALOG_SECTION";
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        if (this.getLaunchConfiguration().equals(manager.getMovedFrom(configuration))) {
            this.fLaunchConfiguration = configuration;
            this.getTabViewer().setInput(this.getLaunchConfiguration());
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }
}

