/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneProxy;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.debug.ui.DebugPopup;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class InspectPopupDialog
extends DebugPopup {
    private static final String PREF_INSPECT_POPUP_SASH_WEIGHTS = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + "inspectPopupSashWeights";
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{75, 25};
    private static final int MIN_WIDTH = 300;
    private static final int MIN_HEIGHT = 250;
    private IPresentationContext fContext;
    private TreeModelViewer fViewer;
    private SashForm fSashForm;
    private Composite fDetailPaneComposite;
    private DetailPaneProxy fDetailPane;
    private Tree fTree;
    private IExpression fExpression;

    public InspectPopupDialog(Shell shell, Point anchor, String commandId, IExpression expression) {
        super(shell, anchor, commandId);
        this.fExpression = expression;
    }

    protected Control createDialogArea(Composite parent) {
        StructuredViewer structuredViewer;
        int i;
        Composite composite = new Composite(parent, parent.getStyle());
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fSashForm = new SashForm(composite, parent.getStyle());
        this.fSashForm.setOrientation(512);
        this.fSashForm.setLayoutData((Object)new GridData(1808));
        VariablesView view = this.getViewToEmulate();
        this.fContext = new PresentationContext("org.eclipse.debug.ui.VariableView", (IWorkbenchPart)view);
        if (view != null) {
            IPresentationContext copy = ((TreeModelViewer)view.getViewer()).getPresentationContext();
            String[] properties = copy.getProperties();
            i = 0;
            while (i < properties.length) {
                String key = properties[i];
                this.fContext.setProperty(key, copy.getProperty(key));
                ++i;
            }
        }
        this.fViewer = new TreeModelViewer((Composite)this.fSashForm, 0x1000000A, this.fContext);
        this.fViewer.setAutoExpandLevel(1);
        this.fDetailPaneComposite = SWTFactory.createComposite((Composite)this.fSashForm, 1, 1, 1808);
        this.fDetailPane = new DetailPaneProxy(new DetailPaneContainer());
        this.fDetailPane.display(null);
        this.fTree = this.fViewer.getTree();
        this.fTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InspectPopupDialog.this.fDetailPane.display((IStructuredSelection)InspectPopupDialog.this.fViewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.initSashWeights();
        this.fViewer.getContentProvider();
        if (view != null && (structuredViewer = (StructuredViewer)view.getViewer()) != null) {
            ViewerFilter[] filters = structuredViewer.getFilters();
            i = 0;
            while (i < filters.length) {
                this.fViewer.addFilter(filters[i]);
                ++i;
            }
        }
        TreeRoot treeRoot = new TreeRoot();
        this.fViewer.addViewerUpdateListener(new IViewerUpdateListener(){

            public void viewerUpdatesComplete() {
            }

            public void viewerUpdatesBegin() {
            }

            public void updateStarted(IViewerUpdate update) {
            }

            public void updateComplete(IViewerUpdate update) {
                if (update instanceof IChildrenUpdate) {
                    TreeSelection selection = new TreeSelection(new TreePath(new Object[]{InspectPopupDialog.this.fExpression}));
                    InspectPopupDialog.this.fViewer.setSelection((ISelection)selection);
                    InspectPopupDialog.this.fDetailPane.display((IStructuredSelection)selection);
                    InspectPopupDialog.this.fViewer.removeViewerUpdateListener(this);
                }
            }
        });
        this.fViewer.setInput(treeRoot);
        return this.fTree;
    }

    protected void initSashWeights() {
        String[] weights;
        String prefWeights = DebugUIPlugin.getDefault().getPreferenceStore().getString(PREF_INSPECT_POPUP_SASH_WEIGHTS);
        if (prefWeights.length() > 0 && (weights = prefWeights.split(":")).length == 2) {
            try {
                int[] intWeights = new int[]{Integer.parseInt(weights[0]), Integer.parseInt(weights[1])};
                this.fSashForm.setWeights(intWeights);
                return;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.fSashForm.setWeights(DEFAULT_SASH_WEIGHTS);
    }

    protected void saveDialogBounds(Shell shell) {
        int[] weights;
        super.saveDialogBounds(shell);
        if (this.fSashForm != null && !this.fSashForm.isDisposed() && (weights = this.fSashForm.getWeights()).length == 2) {
            String weightString = String.valueOf(weights[0]) + ":" + weights[1];
            DebugUIPlugin.getDefault().getPluginPreferences().setValue(PREF_INSPECT_POPUP_SASH_WEIGHTS, weightString);
        }
    }

    private VariablesView getViewToEmulate() {
        IWorkbenchPage page = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
        VariablesView expressionsView = (VariablesView)page.findView("org.eclipse.debug.ui.ExpressionView");
        if (expressionsView != null && expressionsView.isVisible()) {
            return expressionsView;
        }
        VariablesView variablesView = (VariablesView)page.findView("org.eclipse.debug.ui.VariableView");
        if (variablesView != null && variablesView.isVisible()) {
            return variablesView;
        }
        if (expressionsView != null) {
            return expressionsView;
        }
        return variablesView;
    }

    public boolean close() {
        if (!this.wasPersisted()) {
            this.fExpression.dispose();
        }
        this.fDetailPane.dispose();
        this.fContext.dispose();
        return super.close();
    }

    protected String getActionText() {
        return DebugUIViewsMessages.InspectPopupDialog_0;
    }

    protected void persist() {
        super.persist();
        DebugPlugin.getDefault().getExpressionManager().addExpression(this.fExpression);
        this.fExpression = null;
        IWorkbenchPage page = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
        IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
        if (part == null) {
            try {
                page.showView("org.eclipse.debug.ui.ExpressionView");
            }
            catch (PartInitException partInitException) {}
        } else {
            page.bringToTop((IWorkbenchPart)part);
        }
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        initialSize.x = Math.max(initialSize.x, 300);
        initialSize.y = Math.max(initialSize.y, 250);
        return initialSize;
    }

    protected List getBackgroundColorExclusions() {
        List list = super.getBackgroundColorExclusions();
        list.add(this.fSashForm);
        return list;
    }

    private class DetailPaneContainer
    implements IDetailPaneContainer {
        private DetailPaneContainer() {
        }

        public String getCurrentPaneID() {
            return InspectPopupDialog.this.fDetailPane.getCurrentPaneID();
        }

        public IStructuredSelection getCurrentSelection() {
            return (IStructuredSelection)InspectPopupDialog.this.fViewer.getSelection();
        }

        public void refreshDetailPaneContents() {
            InspectPopupDialog.this.fDetailPane.display(this.getCurrentSelection());
        }

        public Composite getParentComposite() {
            return InspectPopupDialog.this.fDetailPaneComposite;
        }

        public IWorkbenchPartSite getWorkbenchPartSite() {
            return null;
        }

        public void paneChanged(String newPaneID) {
            if (newPaneID.equals(DefaultDetailPane.ID)) {
                InspectPopupDialog.this.applyBackgroundColor(InspectPopupDialog.this.getShell().getDisplay().getSystemColor(29), InspectPopupDialog.this.fDetailPane.getCurrentControl());
            }
        }
    }

    private class TreeRoot
    extends ElementContentProvider {
        private TreeRoot() {
        }

        protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
            return 1;
        }

        protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
            return new Object[]{InspectPopupDialog.this.fExpression};
        }

        protected boolean supportsContextId(String id) {
            return true;
        }
    }
}

