/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.contexts;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractDebugContextProvider
implements IDebugContextProvider {
    private ListenerList fListeners = new ListenerList();
    private IWorkbenchPart fPart;

    public AbstractDebugContextProvider(IWorkbenchPart part) {
        this.fPart = part;
    }

    public void addDebugContextListener(IDebugContextListener listener) {
        this.fListeners.add((Object)listener);
    }

    public IWorkbenchPart getPart() {
        return this.fPart;
    }

    public void removeDebugContextListener(IDebugContextListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected void fire(final DebugContextEvent event) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IDebugContextListener listener = (IDebugContextListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.debugContextChanged(event);
                }

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }
            });
            ++i;
        }
    }
}

