/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.commands;

import org.eclipse.epf.authoring.gef.edit.NamedNodeEditPart;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Display;

public class ChangeNameCommand
extends Command {
    private NamedNode element;
    private String newName;
    private String oldName;
    private static final String LABEL = AuthoringUIResources.gef_changeNameCommand_label;
    private static final String UNDO_MESSAGE = AuthoringUIResources.gef_changeNameCommand_undoMessage;

    public ChangeNameCommand(NamedNode elem, String newName) {
        super(LABEL);
        this.element = elem;
        this.oldName = elem.getName();
        this.newName = newName.trim();
    }

    public boolean canExecute() {
        return this.element != null;
    }

    public void execute() {
        this.element.setName(this.newName);
    }

    public void undo() {
        if (!StrUtil.isBlank((String)this.oldName)) {
            this.element.setName(this.oldName);
        } else {
            Display.getCurrent().asyncExec((Runnable)new PromptEdit(null, UNDO_MESSAGE));
        }
    }

    static class PromptEdit
    implements Runnable {
        private String msg;

        PromptEdit(NamedNodeEditPart part, String msg) {
            this.msg = msg;
        }

        public void run() {
            String title = AuthoringUIResources.warningDialog_title;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, this.msg, "");
        }
    }
}

