/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.epf.authoring.gef.edit.ClosestAnchor;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.edit.RelativeXYAnchor;
import org.eclipse.epf.authoring.gef.util.ConnectionAnchorLocator;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.swt.graphics.Color;

public class SynchBarNodeEditPart
extends NodeEditPart
implements ConnectionAnchorLocator {
    private static final Color BG_COLOR = new Color(null, 51, 102, 102);
    private Point recentTargetEndPoint;
    private Point recentSourceEndPoint;

    public SynchBarNodeEditPart(TypedNode model) {
        super((Node)model);
    }

    protected DirectEditPolicy createDirectEditPolicy() {
        return null;
    }

    protected IFigure createFigure() {
        RectangleFigure f = new RectangleFigure();
        f.setBackgroundColor(BG_COLOR);
        f.setSize(100, 5);
        return f;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        boolean isRelative = false;
        Point sourceEndPoint = null;
        if (this.recentSourceEndPoint == null) {
            Link link = (Link)connection.getModel();
            sourceEndPoint = link.getSourceEndPoint();
            isRelative = true;
        } else {
            sourceEndPoint = this.recentSourceEndPoint;
        }
        if (sourceEndPoint != null) {
            return new RelativeXYAnchor(this.getFigure(), sourceEndPoint, isRelative);
        }
        return super.getSourceConnectionAnchor(connection);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point p = null;
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest req = (CreateConnectionRequest)request;
            p = req.getLocation();
        } else if (request instanceof LocationRequest) {
            p = ((LocationRequest)request).getLocation();
        }
        if (p != null) {
            this.recentSourceEndPoint = this.getLocation(p);
            return new RelativeXYAnchor(this.getFigure(), this.recentSourceEndPoint, true);
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        boolean isRelative = false;
        Point targetEndPoint = null;
        if (this.recentTargetEndPoint == null) {
            Link link = (Link)connection.getModel();
            targetEndPoint = link.getTargetEndPoint();
            isRelative = true;
        } else {
            targetEndPoint = this.recentTargetEndPoint;
        }
        if (targetEndPoint != null) {
            return new RelativeXYAnchor(this.getFigure(), targetEndPoint, isRelative);
        }
        return super.getTargetConnectionAnchor(connection);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point p = null;
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest req = (CreateConnectionRequest)request;
            p = req.getLocation();
        } else if (request instanceof LocationRequest) {
            p = ((LocationRequest)request).getLocation();
        }
        if (p != null) {
            this.recentTargetEndPoint = this.getLocation(p);
            return new RelativeXYAnchor(this.getFigure(), this.recentTargetEndPoint, true);
        }
        return super.getTargetConnectionAnchor(request);
    }

    public Point getLocation(Point reference) {
        return ClosestAnchor.getLocation(this.getFigure(), reference);
    }
}

