/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.epf.authoring.gef.figures.TextFigure;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public class TextFigureCellEditorLocator
implements CellEditorLocator {
    private TextFigure figure;

    public TextFigureCellEditorLocator(TextFigure tf) {
        this.setFigure(tf);
    }

    public void relocate(CellEditor celleditor) {
        TextFigureCellEditorLocator.doLocate(celleditor, this.figure);
    }

    public static void doLocate(CellEditor ce, TextFigure fig) {
        Text text = (Text)ce.getControl();
        String n = (String)ce.getValue();
        GC gc = new GC((Drawable)text);
        Point size = gc.textExtent(n);
        gc.dispose();
        if (size.x != 0) {
            size = text.computeSize(size.x, -1);
        }
        text.setSize(size.x, size.y);
        Rectangle textBounds = new Rectangle(text.getClientArea().x, text.getClientArea().y, text.getClientArea().width, text.getClientArea().height);
        Rectangle figBounds = fig.getClientArea();
        fig.translateToAbsolute((Translatable)figBounds);
        int delta = (figBounds.width - textBounds.width) / 2;
        int y = fig.getTextFlowPage().getLocation().y;
        text.setLocation(figBounds.x + delta, y);
    }

    public TextFigure getFigure() {
        return this.figure;
    }

    public void setFigure(TextFigure figure) {
        this.figure = figure;
    }
}

