/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import com.ibm.icu.util.StringTokenizer;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.epf.authoring.gef.commands.CreateLinkCommand;
import org.eclipse.epf.authoring.gef.commands.ReconnectLinkCommand;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.RaisedMarginBorder;
import org.eclipse.epf.authoring.gef.util.ConnectionAnchorLocator;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.WorkProductComposite;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class WorkProductCompositeEditPart
extends NodeContainerEditPart
implements NodeEditPart {
    private static Color BG_COLOR;

    public WorkProductCompositeEditPart(WorkProductComposite model) {
        super((NodeContainer)model);
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        FlowLayout layout = new FlowLayout();
        layout.setMinorSpacing(20);
        figure.setLayoutManager((LayoutManager)layout);
        figure.setBorder((Border)new RaisedMarginBorder());
        figure.setBackgroundColor(this.getBackgroundColor());
        figure.setOpaque(true);
        return figure;
    }

    protected void handlePropertyChanged(Notification msg) {
        switch (msg.getFeatureID(NodeContainer.class)) {
            case 7: {
                this.refreshChildren();
                this.adjustSize();
                EditPart diagramEditPart = this.getParent();
                diagramEditPart.refresh();
                return;
            }
        }
        super.handlePropertyChanged(msg);
    }

    private void adjustSize() {
        List list = this.getChildren();
        int tHeight = 20;
        int tWidth = 20;
        for (GraphicalEditPart editpart : list) {
            tHeight += editpart.getFigure().getPreferredSize().height;
            if (tWidth >= editpart.getFigure().getPreferredSize().width) continue;
            tWidth = editpart.getFigure().getPreferredSize().width;
        }
        ((Node)this.getModel()).setHeight(tHeight);
        ((Node)this.getModel()).setWidth(tWidth + 20);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GraphicalNodeEditPolicy(){

            protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
                CreateLinkCommand cmd = (CreateLinkCommand)request.getStartCommand();
                cmd.setTarget((Node)this.getHost().getModel());
                if (request.getTargetEditPart() instanceof ConnectionAnchorLocator && !request.getTargetEditPart().equals(request.getSourceEditPart())) {
                    cmd.setTargetEndPoint(((ConnectionAnchorLocator)request.getTargetEditPart()).getLocation(request.getLocation()));
                }
                return cmd;
            }

            protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
                CreateLinkCommand cmd = new CreateLinkCommand(ModelFactory.eINSTANCE.createLink(), (Node)this.getHost().getModel());
                if (request.getTargetEditPart() instanceof ConnectionAnchorLocator) {
                    cmd.setSourceEndPoint(((ConnectionAnchorLocator)request.getTargetEditPart()).getLocation(request.getLocation()));
                } else {
                    cmd.setSourceEndPoint(request.getLocation());
                }
                request.setStartCommand((Command)cmd);
                return cmd;
            }

            protected Command getReconnectSourceCommand(ReconnectRequest request) {
                Link link = (Link)request.getConnectionEditPart().getModel();
                ReconnectLinkCommand cmd = new ReconnectLinkCommand(link, (Node)this.getHost().getModel(), true);
                if (request.getTarget() instanceof ConnectionAnchorLocator) {
                    cmd.setEndPoint(((ConnectionAnchorLocator)request.getTarget()).getLocation(request.getLocation()));
                }
                return cmd;
            }

            protected Command getReconnectTargetCommand(ReconnectRequest request) {
                Link link = (Link)request.getConnectionEditPart().getModel();
                ReconnectLinkCommand cmd = new ReconnectLinkCommand(link, (Node)this.getHost().getModel(), false);
                if (request.getTarget() instanceof ConnectionAnchorLocator) {
                    cmd.setEndPoint(((ConnectionAnchorLocator)request.getTarget()).getLocation(request.getLocation()));
                }
                return cmd;
            }
        });
        this.installEditPolicy("LayoutEditPolicy", null);
        this.installEditPolicy("ComponentEditPolicy", null);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    protected List getModelSourceConnections() {
        return this.getNode().getOutgoingConnections();
    }

    protected List getModelTargetConnections() {
        return this.getNode().getIncomingConnections();
    }

    protected Node getNode() {
        return (Node)this.getModel();
    }

    protected Color getBackgroundColor() {
        String colorString;
        if (BG_COLOR != null) {
            return BG_COLOR;
        }
        if (BG_COLOR == null && (colorString = AuthoringUIPlugin.getDefault().getPreferenceStore().getString("ADD_WP_BOX_BG_COLOR_RGB")) != null && colorString.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(colorString, ",");
            int r = Integer.parseInt(tokenizer.nextToken());
            int g = Integer.parseInt(tokenizer.nextToken());
            int b = Integer.parseInt(tokenizer.nextToken());
            BG_COLOR = new Color(null, r, g, b);
            return BG_COLOR;
        }
        if (BG_COLOR == null) {
            BG_COLOR = new Color((Device)Display.getCurrent(), 255, 255, 205);
        }
        return BG_COLOR;
    }
}

