/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.figures;

import java.util.Iterator;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class RoleTaskFlowLayout
extends FlowLayout {
    boolean adjust = false;
    WorkingData data;

    public RoleTaskFlowLayout() {
    }

    public RoleTaskFlowLayout(boolean isHorizontal) {
        super(isHorizontal);
    }

    public void layout(IFigure parent) {
        if (this.adjust) {
            this.adjustLayout(parent);
        } else {
            super.layout(parent);
        }
    }

    protected void initRow() {
        this.data.rowX = 0;
        this.data.rowHeight = 0;
        this.data.rowWidth = 0;
        this.data.rowCount = 0;
    }

    protected void initVariables(IFigure parent) {
        this.data.row = new IFigure[parent.getChildren().size()];
        this.data.bounds = new Rectangle[this.data.row.length];
        this.data.maxWidth = this.data.area.width;
    }

    private void adjustLayout(IFigure parent) {
        this.data = new WorkingData();
        Rectangle relativeArea = parent.getClientArea();
        this.data.area = this.transposer.t(relativeArea);
        Iterator iterator = parent.getChildren().iterator();
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            wHint = parent.getClientArea().width;
        } else {
            hHint = parent.getClientArea().height;
        }
        this.initVariables(parent);
        this.initRow();
        while (iterator.hasNext()) {
            IFigure f = (IFigure)iterator.next();
            Dimension pref = this.transposer.t(this.getChildSize(f, wHint, hHint));
            Rectangle r = new Rectangle(0, 0, pref.width, pref.height);
            if (this.data.rowCount > 0 && this.data.rowWidth + pref.width > this.data.maxWidth) {
                this.layoutRow(parent);
            }
            r.x = this.data.rowX;
            r.y = this.data.rowY;
            int dx = r.width + this.getMinorSpacing();
            this.data.rowX += dx;
            this.data.rowWidth += dx;
            this.data.rowHeight = Math.max(this.data.rowHeight, r.height);
            this.data.row[this.data.rowCount] = f;
            this.data.bounds[this.data.rowCount] = r;
            ++this.data.rowCount;
        }
        if (this.data.rowCount != 0) {
            this.layoutRow(parent);
        }
        this.data = null;
    }

    public void setAdjust(boolean adjust) {
        this.adjust = adjust;
    }

    class WorkingData {
        int rowHeight;
        int rowWidth;
        int rowCount;
        int rowX;
        int rowY;
        int maxWidth;
        Rectangle[] bounds;
        Rectangle area;
        IFigure[] row;

        WorkingData() {
        }
    }
}

