/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ActivityDiagram;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.RoleNode;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProductDescriptor;

public final class Validation {
    private static final String errMsg_CanNotConnect = AuthoringUIResources.DiagramValidation_err_cannot_connect_text;
    private static final String errMsg_SamePredAndSucc = AuthoringUIResources.DiagramValidation_err_samepredandsuc_text;
    private static final String errMsg_CanNotDelete = AuthoringUIResources.DiagramValidation_err_cannot_delete_text;

    public static String checkConnect(Node source, Node target) {
        if (source.getDiagram() != target.getDiagram()) {
            return AuthoringUIResources.DiagramValidation_err_cannot_connect_text;
        }
        if (source.getDiagram() instanceof ActivityDiagram) {
            ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            Object adapter = adapterFactory.adapt(source.getDiagram().getObject(), ITreeItemContentProvider.class);
            Object proc = null;
            if (adapter instanceof IBSItemProvider) {
                proc = ((IBSItemProvider)adapter).getTopItem();
            }
            ArrayList<Object> allElements = new ArrayList<Object>();
            AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator((AdapterFactory)adapterFactory, proc);
            while (iter.hasNext()) {
                Object obj = iter.next();
                allElements.add(TngUtil.unwrap(obj));
            }
            if (proc != null) {
                if (target.getDiagram().isReadOnly()) {
                    return errMsg_CanNotConnect;
                }
                if (source.getObject() instanceof WorkBreakdownElement) {
                    if (target.getObject() instanceof WorkBreakdownElement) {
                        if (ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)target.getObject()), (WorkBreakdownElement)((WorkBreakdownElement)source.getObject()), allElements)) {
                            return errMsg_SamePredAndSucc;
                        }
                        if (target.isReadOnly()) {
                            return errMsg_CanNotConnect;
                        }
                    } else if (target instanceof TypedNode) {
                        if (((TypedNode)target).getType() == 3 || ((TypedNode)target).getType() == 6) {
                            return errMsg_CanNotConnect;
                        }
                        Collection targetNodes = GraphicalDataHelper.getTargetNodes((TypedNode)((TypedNode)target), WorkBreakdownElementNode.class);
                        WorkBreakdownElement pred = (WorkBreakdownElement)source.getObject();
                        for (Node node : targetNodes) {
                            if (node.isReadOnly()) {
                                return errMsg_CanNotConnect;
                            }
                            if (!ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)node.getObject()), (WorkBreakdownElement)pred, allElements)) continue;
                            return errMsg_SamePredAndSucc;
                        }
                    }
                } else if (source instanceof TypedNode) {
                    Collection srcNodes;
                    if (target == source) {
                        return errMsg_CanNotConnect;
                    }
                    if (((TypedNode)source).getType() == 4 || ((TypedNode)source).getType() == 6) {
                        return errMsg_CanNotConnect;
                    }
                    if (target instanceof TypedNode) {
                        if (Validation.checkSyncBarCircularLooop((TypedNode)source, (TypedNode)target) != null) {
                            return errMsg_CanNotConnect;
                        }
                        if (((TypedNode)target).getType() == 3 || ((TypedNode)target).getType() == 6) {
                            return errMsg_CanNotConnect;
                        }
                        srcNodes = GraphicalDataHelper.getSourceNodes((TypedNode)((TypedNode)source), WorkBreakdownElementNode.class);
                        if (!srcNodes.isEmpty()) {
                            Collection targetNodes = GraphicalDataHelper.getTargetNodes((TypedNode)((TypedNode)target), WorkBreakdownElementNode.class);
                            for (Node node : targetNodes) {
                                if (node.isReadOnly()) {
                                    return errMsg_CanNotConnect;
                                }
                                WorkBreakdownElement succ = (WorkBreakdownElement)node.getObject();
                                Iterator iterator = srcNodes.iterator();
                                while (iterator.hasNext()) {
                                    WorkBreakdownElement pred = (WorkBreakdownElement)((Node)iterator.next()).getObject();
                                    if (!ProcessUtil.checkCircular((WorkBreakdownElement)succ, (WorkBreakdownElement)pred, allElements)) continue;
                                    return errMsg_SamePredAndSucc;
                                }
                            }
                        }
                    } else if (target instanceof WorkBreakdownElementNode) {
                        if (target.isReadOnly()) {
                            return errMsg_CanNotConnect;
                        }
                        srcNodes = GraphicalDataHelper.getSourceNodes((TypedNode)((TypedNode)source), WorkBreakdownElementNode.class);
                        WorkBreakdownElement succ = (WorkBreakdownElement)target.getObject();
                        Iterator iterator = srcNodes.iterator();
                        while (iterator.hasNext()) {
                            WorkBreakdownElement pred = (WorkBreakdownElement)((Node)iterator.next()).getObject();
                            if (!ProcessUtil.checkCircular((WorkBreakdownElement)succ, (WorkBreakdownElement)pred, allElements)) continue;
                            return errMsg_SamePredAndSucc;
                        }
                    }
                }
            }
        } else if (source.getDiagram() instanceof ActivityDetailDiagram) {
            if (source.isReadOnly() || target.isReadOnly()) {
                return errMsg_CanNotConnect;
            }
            if (source.getObject() instanceof RoleDescriptor || target.getObject() instanceof RoleDescriptor || source.getObject() instanceof TaskDescriptor && target.getObject() instanceof TaskDescriptor || source.getObject() instanceof WorkProductDescriptor && target.getObject() instanceof WorkProductDescriptor) {
                return errMsg_CanNotConnect;
            }
            for (Link link : source.getOutgoingConnections()) {
                if (link.getTarget() != target) continue;
                return errMsg_CanNotConnect;
            }
        } else if (source.getDiagram() instanceof WorkProductDependencyDiagram && (source.isReadOnly() || target.isReadOnly())) {
            return errMsg_CanNotConnect;
        }
        return null;
    }

    public static String checkDelete(Link link) {
        Node source = link.getSource();
        Node target = link.getTarget();
        if (target != null && target.getDiagram() instanceof ActivityDetailDiagram) {
            return errMsg_CanNotDelete;
        }
        if (target != null && target.getDiagram() instanceof ActivityDiagram) {
            if (target instanceof WorkBreakdownElementNode) {
                if (source instanceof WorkBreakdownElementNode) {
                    if (link.getTarget().isReadOnly()) {
                        return errMsg_CanNotDelete;
                    }
                    return null;
                }
                if (source instanceof TypedNode) {
                    TypedNode sourceNode = (TypedNode)source;
                    if (!target.isReadOnly()) {
                        return null;
                    }
                    if (sourceNode.getType() == 2) {
                        return null;
                    }
                    if (sourceNode.getType() == 1) {
                        return Validation.checkSyncBarIncomingLinks(sourceNode);
                    }
                    if (sourceNode.isReadOnly()) {
                        return errMsg_CanNotDelete;
                    }
                }
            } else if (target instanceof TypedNode) {
                TypedNode typedNode = (TypedNode)target;
                if (typedNode.getType() == 2) {
                    return null;
                }
                if (source instanceof WorkBreakdownElementNode) {
                    if (Validation.checkSyncBarOutgoingLinks((TypedNode)target) == null) {
                        return null;
                    }
                    if (source.isReadOnly()) {
                        return errMsg_CanNotDelete;
                    }
                }
                if (source instanceof TypedNode) {
                    TypedNode sourceTypedNode = (TypedNode)source;
                    if (sourceTypedNode.getType() == 2) {
                        return null;
                    }
                    if (sourceTypedNode.getType() == 1) {
                        return Validation.checkSyncBarIncomingLinks(sourceTypedNode);
                    }
                }
            }
        }
        return null;
    }

    public static String checkDelete(Node node) {
        if (node.isReadOnly()) {
            return errMsg_CanNotDelete;
        }
        Diagram diagram = node.getDiagram();
        if (diagram instanceof ActivityDiagram) {
            if (node instanceof TypedNode) {
                Collection targetNodes = GraphicalDataHelper.getTargetNodes((TypedNode)((TypedNode)node), WorkBreakdownElementNode.class);
                for (Node target : targetNodes) {
                    if (!target.isReadOnly()) continue;
                    return errMsg_CanNotDelete;
                }
            }
        } else if (diagram instanceof ActivityDetailDiagram && node instanceof RoleNode) {
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkReconnect(Node source, Node target, Link link) {
        if (source.getDiagram() instanceof ActivityDiagram && link.getTarget() != null) {
            if (link.getTarget().isReadOnly()) {
                return errMsg_CanNotConnect;
            }
            if (link.getTarget() instanceof TypedNode) {
                Collection targetNodes = GraphicalDataHelper.getTargetNodes((TypedNode)((TypedNode)link.getTarget()), WorkBreakdownElementNode.class);
                for (Node node : targetNodes) {
                    if (!node.isReadOnly()) continue;
                    return errMsg_CanNotConnect;
                }
            }
        }
        return Validation.checkConnect(source, target, link);
    }

    public static String checkConnect(Node source, Node target, Link link) {
        if (source == target && !(source.getObject() instanceof Activity)) {
            return errMsg_CanNotConnect;
        }
        EList links = source.getOutgoingConnections();
        if (links != null) {
            if (links.contains(link) && link.getTarget().equals(target)) {
                return null;
            }
            for (Link linkx : links) {
                Node linkxtarget = linkx.getTarget();
                if (linkxtarget == null || !linkxtarget.equals(target)) continue;
                return errMsg_CanNotConnect;
            }
        }
        return Validation.checkConnect(source, target);
    }

    public static String checkSyncBarCircularLooop(TypedNode sNode, TypedNode tNode) {
        EList list = tNode.getOutgoingConnections();
        if (!list.isEmpty() && list.size() > 0) {
            for (Link link : list) {
                Node typednode = link.getTarget();
                if (sNode.equals(typednode)) {
                    return errMsg_CanNotConnect;
                }
                if (!(typednode instanceof TypedNode)) continue;
                return Validation.checkSyncBarCircularLooop(sNode, (TypedNode)typednode);
            }
        }
        return null;
    }

    public static String checkSyncBarIncomingLinks(TypedNode typedNode) {
        for (Link link : typedNode.getIncomingConnections()) {
            Node source = link.getSource();
            if (!(source instanceof WorkBreakdownElementNode ? source.isReadOnly() : source instanceof TypedNode && ((TypedNode)source).getType() == 1 && Validation.checkSyncBarIncomingLinks((TypedNode)source) != null)) continue;
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkSyncBarOutgoingLinks(TypedNode typedNode) {
        for (Link link : typedNode.getOutgoingConnections()) {
            Node target = link.getTarget();
            if (!(target instanceof WorkBreakdownElementNode ? target.isReadOnly() : target instanceof TypedNode && ((TypedNode)target).getType() == 1 && Validation.checkSyncBarOutgoingLinks((TypedNode)target) != null)) continue;
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static boolean isReadOnly(Link link) {
        Node target = link.getTarget();
        Node source = link.getSource();
        if (target != null && target.getDiagram() instanceof ActivityDiagram) {
            return Validation.checkDelete(link) != null;
        }
        return target != null && target.getDiagram() instanceof ActivityDetailDiagram && (source != null && source instanceof TaskNode && source.isReadOnly() || target instanceof TaskNode && target.isReadOnly());
    }
}

