/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.viewer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.authoring.gef.viewer.AbstractDiagramGraphicalViewer;
import org.eclipse.epf.authoring.gef.viewer.ActivityDetailDiagramViewer;
import org.eclipse.epf.authoring.gef.viewer.ActivityDiagramViewer;
import org.eclipse.epf.authoring.gef.viewer.WPDependencyDiagramViewer;
import org.eclipse.epf.diagram.model.util.DiagramInfo;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.diagram.ui.utils.ImageUtils;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ProcessAdapterFactoryFilter;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ActivityDiagramService
implements IActivityDiagramService {
    private Composite parent = null;
    private Composite holder = null;
    private File pubDir;
    private static Map typeMap = new HashMap();
    private org.eclipse.epf.library.layout.diagram.DiagramInfo diagramInfo = null;
    private boolean publishUncreatedADD = true;
    private boolean publishADForActivityExtension = true;
    Shell shell = null;

    static {
        typeMap.put("Activity", new Integer(0));
        typeMap.put("ActivityDetail", new Integer(2));
        typeMap.put("WPDependency", new Integer(1));
    }

    public static int getIntType(String diagramType) {
        Integer type = (Integer)typeMap.get(diagramType);
        if (type != null) {
            return type;
        }
        return -1;
    }

    public ActivityDiagramService() {
        this(null, new File(LibraryService.getInstance().getCurrentMethodLibraryLocation()));
    }

    public ActivityDiagramService(File pubDir) {
        this(null, pubDir);
    }

    public ActivityDiagramService(Composite parent, File pubDir) {
        this.parent = parent;
        this.pubDir = pubDir;
    }

    private AbstractDiagramGraphicalViewer getDiagramViewer(int diagramType) {
        if (this.shell != null && this.shell.isDisposed()) {
            this.parent = null;
            this.shell = null;
        }
        this.getViewerHolder(this.parent);
        switch (diagramType) {
            case 0: {
                return new ActivityDiagramViewer(this.holder);
            }
            case 2: {
                return new ActivityDetailDiagramViewer(this.holder);
            }
            case 1: {
                return new WPDependencyDiagramViewer(this.holder);
            }
        }
        return null;
    }

    private void getViewerHolder(Composite parent) {
        if (parent == null) {
            if (this.shell == null || this.shell.isDisposed()) {
                this.shell = this.createShell();
            }
            this.shell.open();
            parent = this.shell;
        }
        if (this.holder != null) {
            this.holder.dispose();
        }
        this.holder = new Composite(parent, 0);
        this.holder.setLayoutData((Object)new GridData(1, 1));
        this.holder.setLayout((Layout)new GridLayout());
        this.holder.setVisible(false);
    }

    private Shell createShell() {
        Shell shell = null;
        Display d = Display.getDefault();
        shell = new Shell(d);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        shell.setLayout((Layout)layout);
        shell.setBounds(0, 0, 0, 0);
        shell.setVisible(false);
        return shell;
    }

    public void dispose() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
            this.shell.dispose();
        }
    }

    public org.eclipse.epf.library.layout.diagram.DiagramInfo saveDiagram(final Object wrapper, final String imgPath, final String diagramType, final IFilter filter, final Suppression sup) {
        this.diagramInfo = null;
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                ActivityDiagramService.this.__internal_saveDiagram(wrapper, imgPath, diagramType, filter, sup);
            }
        });
        return this.diagramInfo;
    }

    private boolean hasUserDefinedDiagram(Activity e, String imgPath, String diagramType) throws Exception {
        DiagramInfo info = new DiagramInfo(e);
        switch (ActivityDiagramService.getIntType(diagramType)) {
            case 0: {
                if (!info.canPublishADImage()) break;
                return info.getActivityDiagram() != null && info.canPublishADImage();
            }
            case 2: {
                if (!info.canPublishADDImage()) break;
                return info.getActivityDetailDiagram() != null && info.canPublishADDImage();
            }
            case 1: {
                if (!info.canPublishWPDImage()) break;
                return info.getWPDDiagram() != null && info.canPublishWPDImage();
            }
        }
        return false;
    }

    private void __internal_saveDiagram(Object wrapper, String imgPath, String diagramType, IFilter filter, Suppression sup) {
        if (sup.isSuppressed(wrapper)) {
            return;
        }
        Object o = TngUtil.unwrap((Object)wrapper);
        if (!(o instanceof Activity)) {
            return;
        }
        Activity e = (Activity)o;
        Image image = null;
        int type = ActivityDiagramService.getIntType(diagramType);
        if (type < 0) {
            return;
        }
        AbstractDiagramGraphicalViewer viewer = null;
        boolean dirtyFlag = e.eResource().isModified();
        try {
            boolean exist;
            if (this.hasUserDefinedDiagram(e, imgPath, diagramType)) {
                return;
            }
            Diagram d = GraphicalDataManager.getInstance().getUMADiagram(e, type, false);
            boolean bl = exist = d != null;
            if (exist) {
                if (d.getSuppressed().booleanValue()) {
                    return;
                }
                if (type == 0 && this.checkVariability((VariabilityElement)e, filter, type) != null) {
                    return;
                }
            } else {
                if (type == 1) {
                    return;
                }
                if (type == 0) {
                    if (!this.publishADForActivityExtension) {
                        return;
                    }
                    if (!e.getBreakdownElements().isEmpty()) {
                        return;
                    }
                    VariabilityElement calculatedBase = this.checkVariability((VariabilityElement)e, filter, type);
                    if (calculatedBase == null) {
                        return;
                    }
                    wrapper = calculatedBase;
                    e = (Activity)calculatedBase;
                    exist = true;
                }
                if (!this.publishUncreatedADD && type == 2) {
                    Iterator iterator;
                    boolean contributorexist = false;
                    MethodConfiguration config = null;
                    if (filter instanceof ProcessAdapterFactoryFilter) {
                        config = ((ProcessAdapterFactoryFilter)filter).getMethodConfiguration();
                    }
                    if (config == null) {
                        return;
                    }
                    List list = ConfigurationHelper.getContributors((VariabilityElement)e, (MethodConfiguration)config);
                    if (e instanceof Activity && (iterator = list.iterator()) != null) {
                        while (iterator.hasNext()) {
                            Diagram dx;
                            Object act = iterator.next();
                            if (act == null || (dx = GraphicalDataManager.getInstance().getUMADiagram((Activity)act, type, false)) == null) continue;
                            contributorexist = true;
                            break;
                        }
                    }
                    if (!contributorexist) {
                        return;
                    }
                }
            }
            try {
                try {
                    viewer = this.getDiagramViewer(type);
                    viewer.loadDiagram(wrapper, !exist, filter, sup);
                    this.diagramInfo = viewer.getDiagramInfo();
                    if (this.diagramInfo != null && !this.diagramInfo.isEmpty()) {
                        image = viewer.createDiagramImage();
                        if (image != null) {
                            File f = new File(this.pubDir, imgPath);
                            File parent = f.getParentFile();
                            if (!parent.exists()) {
                                parent.mkdirs();
                            }
                            if (!f.exists()) {
                                f.createNewFile();
                            }
                            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
                            ImageWriter writer = iter.next();
                            ImageWriteParam iwp = writer.getDefaultWriteParam();
                            iwp.setCompressionMode(2);
                            iwp.setCompressionQuality(1.0f);
                            FileImageOutputStream output = new FileImageOutputStream(f);
                            writer.setOutput(output);
                            BufferedImage bufferedImage = ImageUtils.convertToAWT((ImageData)image.getImageData());
                            IIOImage iioImage = new IIOImage(bufferedImage, null, null);
                            writer.write(null, iioImage, iwp);
                            writer.dispose();
                            this.diagramInfo.setImageFilePath(imgPath);
                        } else {
                            System.out.println("Unable to create diagram image");
                        }
                    }
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
                if (!exist && (d = GraphicalDataManager.getInstance().getUMADiagram(e, type, false)) != null) {
                    EcoreUtil.remove((EObject)d);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        finally {
            try {
                e.eResource().setModified(dirtyFlag);
                if (viewer != null) {
                    viewer.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
            catch (RuntimeException e1) {
                e1.printStackTrace();
            }
        }
    }

    private VariabilityElement checkVariability(VariabilityElement e, IFilter filter, int type) {
        MethodConfiguration config = null;
        if (filter instanceof ProcessAdapterFactoryFilter) {
            config = ((ProcessAdapterFactoryFilter)filter).getMethodConfiguration();
        }
        if (config == null) {
            return null;
        }
        List list = ConfigurationHelper.getContributors((VariabilityElement)e, (MethodConfiguration)config);
        for (Object next : list) {
            if (!(next instanceof Activity) || ((Activity)next).getBreakdownElements().isEmpty()) continue;
            return null;
        }
        VariabilityInfo eInfo = ((ProcessAdapterFactoryFilter)filter).getVariabilityInfo(e);
        List contributors = eInfo.getContributors();
        VariabilityElement ve = e.getVariabilityBasedOnElement();
        if (ve == null) {
            return null;
        }
        Activity replacer = (Activity)ConfigurationHelper.getReplacer((VariabilityElement)ve, (MethodConfiguration)config);
        if (replacer != null) {
            ve = replacer;
            Diagram replacerDiagram = GraphicalDataManager.getInstance().getUMADiagram(replacer, type, false);
            if (replacerDiagram != null) {
                return replacer;
            }
            return null;
        }
        Diagram baseDiagram = GraphicalDataManager.getInstance().getUMADiagram((Activity)ve, type, false);
        if (baseDiagram != null) {
            if (baseDiagram.getSuppressed().booleanValue()) {
                return null;
            }
            VariabilityInfo veInfo = ((ProcessAdapterFactoryFilter)filter).getVariabilityInfo(ve);
            List veContributors = veInfo.getContributors();
            if (contributors.size() != veContributors.size()) {
                for (Object next : contributors) {
                    if (veContributors.contains(next) || ((Activity)next).getBreakdownElements().isEmpty()) continue;
                    return null;
                }
            }
            return ve;
        }
        return this.checkVariability(ve, filter, type);
    }

    public void setPublishedUnCreatedADD(boolean flag) {
        this.publishUncreatedADD = flag;
    }

    public void setPublishADForActivityExtension(boolean flag) {
        this.publishADForActivityExtension = flag;
    }

    public Activity getRealizedForUnmodified(Object activity, IFilter filter, Suppression suppression) {
        return null;
    }
}

