/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.BrowsingPerspective;
import org.eclipse.epf.authoring.ui.dialogs.ContributionSelection;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.ui.util.PerspectiveUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UIActionDispatcher
implements ISelectionProvider {
    private static UIActionDispatcher instance = null;
    protected List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected List<IDoubleClickListener> doubleClickListeners = new ArrayList<IDoubleClickListener>();
    private CurrentSelection currentSelection = new CurrentSelection();
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent e) {
            ISelection selection = e.getSelection();
            if (selection != null) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPartSite site = window.getActivePage().getActivePart().getSite();
                IStructuredSelection sel = (IStructuredSelection)selection;
                Object[] selObjs = sel.toArray();
                Object selectedObject = null;
                if (selObjs != null && selObjs.length > 0) {
                    UIActionDispatcher.openAuthoringPerspective();
                    Object obj = TngUtil.unwrap((Object)selObjs[0]);
                    ConfigurationView view = ConfigurationView.getView();
                    if (view != null && site.equals(view.getSite())) {
                        if (obj instanceof VariabilityElement) {
                            VariabilityElement element = (VariabilityElement)obj;
                            ContributionSelection contribSelection = new ContributionSelection();
                            selectedObject = contribSelection.getSelectedContributor(element);
                        } else if (obj instanceof Milestone) {
                            selectedObject = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)obj));
                        }
                    } else {
                        selectedObject = obj;
                    }
                    if (selectedObject != null) {
                        EditorChooser.getInstance().openEditor(selectedObject);
                    }
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UIActionDispatcher getInstance() {
        if (instance != null) return instance;
        Class<UIActionDispatcher> clazz = UIActionDispatcher.class;
        synchronized (UIActionDispatcher.class) {
            if (instance != null) return instance;
            instance = new UIActionDispatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private UIActionDispatcher() {
        this(null);
    }

    public UIActionDispatcher(Object owner) {
        IWorkbenchWindow activeWorkbenchWindow = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activeWorkbenchWindow.addPerspectiveListener(new IPerspectiveListener(){

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor desc) {
                    if (desc.getId().equals(AuthoringPerspective.PERSPECTIVE_ID)) {
                        UIActionDispatcher.this.addDoubleClickListener(UIActionDispatcher.this.doubleClickListener);
                        if (LibraryView.getViewInstance() == null) {
                            LibraryView.setNeedRegisterChangeListenersInCreate(true);
                        } else {
                            LibraryView.getViewInstance().registerChangeListeners();
                        }
                    } else {
                        UIActionDispatcher.this.removeDoubleClickListener(UIActionDispatcher.this.doubleClickListener);
                    }
                    ConfigurationHelper.getDelegate().setAuthoringPerspective(AuthoringPerspective.PERSPECTIVE_ID.equals(desc.getId()));
                }

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor desc, String id) {
                    ConfigurationHelper.getDelegate().setAuthoringPerspective(AuthoringPerspective.PERSPECTIVE_ID.equals(desc.getId()));
                }
            });
        }
        if (PerspectiveUtil.isActivePerspective((String)AuthoringPerspective.PERSPECTIVE_ID)) {
            this.addDoubleClickListener(this.doubleClickListener);
        }
    }

    public static void editConfiguration(String configName) {
    }

    public static void openLibraryPerspective() {
        PerspectiveUtil.openPerspective((String)BrowsingPerspective.PERSPECTIVE_ID);
        IWorkbenchPage wkbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = wkbPage.findView(LibraryView.VIEW_ID);
        if (viewPart != null) {
            wkbPage.hideView(viewPart);
        }
        viewPart = wkbPage.findView(ConfigurationView.VIEW_ID);
        wkbPage.activate((IWorkbenchPart)viewPart);
    }

    public static void openAuthoringPerspective() {
        PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
        IWorkbenchPage wkbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = wkbPage.findView(LibraryView.VIEW_ID);
        wkbPage.activate((IWorkbenchPart)viewPart);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.selectionChangedListeners.contains(listener)) {
            this.selectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.currentSelection.selection;
    }

    public ISelectionProvider getSelectionSource() {
        return this.currentSelection.source;
    }

    public void setSelection(ISelection selection) {
        this.setSelection(this, selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(ISelectionProvider source, ISelection selection) {
        UIActionDispatcher uIActionDispatcher = this;
        synchronized (uIActionDispatcher) {
            this.currentSelection.selection = selection;
            this.currentSelection.source = source;
            SelectionChangedEvent event = new SelectionChangedEvent(source, selection);
            ArrayList<ISelectionChangedListener> processedItems = new ArrayList<ISelectionChangedListener>();
            while (this.selectionChangedListeners.size() > 0) {
                ISelectionChangedListener listener = this.selectionChangedListeners.remove(0);
                if (listener == null) continue;
                try {
                    listener.selectionChanged(event);
                }
                catch (Exception e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
                processedItems.add(listener);
            }
            this.selectionChangedListeners.addAll(processedItems);
        }
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        if (!this.doubleClickListeners.contains(listener)) {
            this.doubleClickListeners.add(listener);
        }
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDoubleClickEvent(DoubleClickEvent event) {
        UIActionDispatcher uIActionDispatcher = this;
        synchronized (uIActionDispatcher) {
            ArrayList<IDoubleClickListener> processedItems = new ArrayList<IDoubleClickListener>();
            while (this.doubleClickListeners.size() > 0) {
                IDoubleClickListener listener = this.doubleClickListeners.remove(0);
                try {
                    listener.doubleClick(event);
                }
                catch (Exception e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
                processedItems.add(listener);
            }
            this.doubleClickListeners.addAll(processedItems);
        }
    }

    public class CurrentSelection {
        public ISelectionProvider source = null;
        public ISelection selection = StructuredSelection.EMPTY;
    }
}

