/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.dialogs.ContributionSelection;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Phase;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class ConfigurationViewEditAction
extends BaseSelectionListenerAction {
    public static final String ACTION_ID = ConfigurationViewEditAction.class.getName();
    private IStructuredSelection selected;
    private ContributionSelection contributorSelector = new ContributionSelection();

    public ConfigurationViewEditAction(String text) {
        super(text);
    }

    public void run() {
        ArrayList<Object> elementList = new ArrayList<Object>();
        Iterator objects = this.selected.iterator();
        while (objects.hasNext()) {
            Object element = TngUtil.unwrap(objects.next());
            if (element instanceof VariabilityElement) {
                Object obj = this.contributorSelector.getSelectedContributor((VariabilityElement)element);
                if (obj == null) continue;
                elementList.add(obj);
                continue;
            }
            elementList.add(element);
        }
        if (elementList.size() < 1) {
            return;
        }
        if (PerspectiveListUtil.isBrowsingPerspective()) {
            UIActionDispatcher.openAuthoringPerspective();
        }
        for (Object element : elementList) {
            EditorChooser.getInstance().openEditor(element);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.selected = selection;
        boolean enableTheMenu = true;
        for (Object element : selection) {
            Object realObj = TngUtil.unwrap(element);
            if (!(realObj instanceof MethodElement)) {
                enableTheMenu = false;
                break;
            }
            if (realObj instanceof DeliveryProcess || realObj instanceof CapabilityPattern) break;
            if (!(realObj instanceof Phase) && !(realObj instanceof Activity) && !(realObj instanceof ProcessPackage)) continue;
            enableTheMenu = false;
            break;
        }
        return enableTheMenu;
    }
}

