/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandActionDelegate;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.library.edit.command.CommandStatusChecker;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.process.command.CreateProcessComponentCommand;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.UmaFactory;

public class CreateMethodElementCommand
extends CommandWrapper
implements CommandActionDelegate {
    protected Object obj;

    public CreateMethodElementCommand(Command command) {
        super(command);
    }

    private void reloadCurrentLibraryOnRollbackError() {
        ViewHelper.reloadCurrentLibaryOnRollbackError(null);
    }

    public void execute() {
        Object cmd = TngUtil.unwrap((Command)this);
        super.execute();
        if (this.command instanceof CreateProcessComponentCommand) {
            IStatus status = ((CreateProcessComponentCommand)this.command).getStatus();
            if (status != null && !status.isOK()) {
                if (CommandStatusChecker.hasRollbackError((IStatus)status)) {
                    this.reloadCurrentLibraryOnRollbackError();
                } else if (!CommandStatusChecker.hasSaveError((IStatus)status)) {
                    this.displayError(status);
                }
                return;
            }
        } else {
            MethodElementAddCommand addCmd;
            IStatus status;
            cmd = this;
            while (cmd instanceof CommandWrapper && !(cmd instanceof MethodElementAddCommand)) {
                cmd = ((CommandWrapper)cmd).getCommand();
            }
            if (cmd instanceof MethodElementAddCommand && (status = (addCmd = (MethodElementAddCommand)cmd).getStatus()) != null && !status.isOK()) {
                if (CommandStatusChecker.hasRollbackError((IStatus)status)) {
                    this.reloadCurrentLibraryOnRollbackError();
                } else if (!CommandStatusChecker.hasSaveError((IStatus)status)) {
                    this.displayError(status);
                }
                return;
            }
        }
        Collection result = this.getCommand().getResult();
        for (Object o : result) {
            this.obj = TngUtil.unwrap(o);
            if (!(this.obj instanceof EObject) || ((EObject)this.obj).eContainer() == null) continue;
            if (AuthoringUIPreferences.getEnableAutoNameGen() && this.obj instanceof MethodElement) {
                LibraryUtil.addNameTrackPresentationNameMark((MethodElement)((MethodElement)this.obj));
            }
            Job job = new Job("Persistence for new practice"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (CreateMethodElementCommand.this.obj instanceof Practice) {
                        Practice prac = (Practice)CreateMethodElementCommand.this.obj;
                        MethodElementProperty prop = UmaFactory.eINSTANCE.createMethodElementProperty();
                        prop.setName("PUBLISH_CATEGORY");
                        prop.setValue(new Boolean(true).toString());
                        prac.getMethodElementProperty().add(prop);
                        LibraryEditUtil.save(Collections.singleton(prac.eResource()));
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            IEditorKeeper.REFERENCE.getEditorKeeper().openEditor(this.obj);
        }
    }

    public boolean canUndo() {
        return false;
    }

    public Object getImage() {
        CommandActionDelegate cmd = (CommandActionDelegate)this.getCommand();
        return cmd.getImage();
    }

    public String getText() {
        CommandActionDelegate cmd = (CommandActionDelegate)this.getCommand();
        return cmd.getText();
    }

    public String getToolTipText() {
        CommandActionDelegate cmd = (CommandActionDelegate)this.getCommand();
        return cmd.getToolTipText();
    }

    protected void displayError(IStatus status) {
        int severity = status.getSeverity();
        if (severity == 4 || severity == 2) {
            AuthoringUIPlugin.getDefault().getMsgDialog().display(this.getLabel(), AuthoringUIResources.errorDialog_createError, status);
        }
    }
}

