/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.LayoutAction;
import org.eclipse.epf.authoring.ui.actions.MultiActionGroup;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.edit.PluginUIPackageContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;

public class LayoutActionGroup
extends MultiActionGroup {
    public LayoutActionGroup(LibraryView libView) {
        super(LayoutActionGroup.createActions(libView), LayoutActionGroup.getSelectedState(libView));
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.contributeToViewMenu(actionBars.getMenuManager());
    }

    private void contributeToViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(AuthoringUIResources.LayoutActionGroup_label);
        Separator marker = new Separator("layout");
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IContributionItem)marker);
        viewMenu.appendToGroup("layout", (IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator("additions-end"));
        this.addActions((IMenuManager)layoutSubMenu);
    }

    static int getSelectedState(LibraryView libView) {
        if (PluginUIPackageContext.INSTANCE.isFlatLayout()) {
            return 0;
        }
        return 1;
    }

    static IAction[] createActions(LibraryView libView) {
        LayoutAction flatLayoutAction = new LayoutAction(libView, true);
        flatLayoutAction.setText(AuthoringUIResources.LayoutActionGroup_flatLayoutAction_label);
        flatLayoutAction.setImageDescriptor(AuthoringUIImages.IMG_DESC_LAYOUT_FLAT);
        LayoutAction hierarchicalLayout = new LayoutAction(libView, false);
        hierarchicalLayout.setText(AuthoringUIResources.LayoutActionGroup_hierarchicalLayoutAction_label);
        hierarchicalLayout.setImageDescriptor(AuthoringUIImages.IMG_DESC_LAYOUT_HIERARCHICAL);
        return new IAction[]{flatLayoutAction, hierarchicalLayout};
    }
}

