/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.epf.authoring.ui.providers.MethodElementLabelDecorator;
import org.eclipse.epf.authoring.ui.util.LibraryValidationMarkerHelper;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyValidationMgr;
import org.eclipse.epf.library.edit.validation.IValidationManager;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.validation.ValidationManager;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.validation.constraints.LibraryTraversalStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class LibraryValidateAction
extends ValidateAction {
    private HashSet resources;
    private boolean success;
    private boolean showSuccess = true;
    private Map contextData = new HashMap();
    private MethodLibrary library;

    public LibraryValidateAction() {
        this.eclipseResourcesUtil = new LibraryValidationMarkerHelper();
    }

    public LibraryValidateAction(boolean showSuccess) {
        this();
        this.showSuccess = showSuccess;
    }

    public LibraryValidateAction(MethodLibrary library) {
        this();
        this.library = library;
    }

    public void putContextData(Object key, Object value) {
        this.contextData.put(key, value);
    }

    protected Diagnostic validate(IProgressMonitor progressMonitor) {
        ValidationManager validationMgr = (ValidationManager)LibraryEditUtil.getInstance().getValidationManager();
        LibraryUIPreferences.update((IValidationManager)validationMgr);
        validationMgr.setEmfValidateAction((ValidateAction)this);
        if (this.showSuccess) {
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
                    ViewHelper.checkLibraryHealth(LibraryValidateAction.this.library == null ? LibraryValidateAction.this.selectedObjects : LibraryValidateAction.this.library);
                }
            });
        } else {
            validationMgr.setNameCheck(true);
            validationMgr.setCircularDependancyCheck(true);
            validationMgr.setUndeclaredDependancyCheck(false);
        }
        BasicDiagnostic ret = this.validate_old(progressMonitor);
        List scope = this.library == null ? this.selectedObjects : this.library;
        validationMgr.validate((DiagnosticChain)ret, (Object)scope, progressMonitor);
        return ret;
    }

    private BasicDiagnostic validate_old(final IProgressMonitor progressMonitor) {
        Object e;
        if (this.resources == null) {
            this.resources = new HashSet();
        } else {
            this.resources.clear();
        }
        boolean dependencyInfoMgrSet = false;
        Collection<Object> eObjects = new ArrayList();
        Iterator it = this.library == null ? this.selectedObjects.iterator() : this.library.getMethodPlugins().iterator();
        while (it.hasNext()) {
            Object element = TngUtil.unwrap(it.next());
            if (!(element instanceof EObject)) continue;
            eObjects.add(element);
            Resource resource = ((EObject)element).eResource();
            if (resource != null) {
                this.resources.add(resource);
            }
            if (dependencyInfoMgrSet || !(element instanceof MethodElement)) continue;
            MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)((MethodElement)element));
            this.putContextData("CTX_DEPENDENCY_VALIDATION_MGR", new DependencyValidationMgr(lib));
            dependencyInfoMgrSet = true;
        }
        int count = eObjects.size();
        eObjects = LibraryTraversalStrategy.makeTargetsDisjoint(eObjects);
        LibraryTraversalStrategy.LibraryIterator libIter = new LibraryTraversalStrategy.LibraryIterator(eObjects, true, 1, true);
        while (libIter.hasNext()) {
            Resource resource;
            Object o = libIter.next();
            ++count;
            if (!(o instanceof EObject) || (resource = ((EObject)o).eResource()) == null) continue;
            this.resources.add(resource);
        }
        progressMonitor.beginTask("", count);
        Diagnostician diagnostician = new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                return TngUtil.getLabelWithPath((Object)eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map context) {
                progressMonitor.worked(1);
                if (context == null) {
                    context = LibraryValidateAction.this.contextData;
                } else {
                    context.putAll(LibraryValidateAction.this.contextData);
                }
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
        ArrayList list = new ArrayList(eObjects);
        int max = list.size() - 1;
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        while (i < max) {
            Object e2 = list.get(i);
            if (e2 instanceof NamedElement) {
                strBuf.append(((NamedElement)e2).getName()).append(", ");
            }
            ++i;
        }
        Object v0 = e = max < 0 ? null : list.get(max);
        if (e instanceof NamedElement) {
            strBuf.append(((NamedElement)e).getName());
        }
        BasicDiagnostic diagnostics = new BasicDiagnostic("org.eclipse.emf.ecore", 0, EcorePlugin.INSTANCE.getString("_UI_DiagnosticRoot_diagnostic", new Object[]{strBuf.toString()}), list.toArray()){

            public String getMessage() {
                String msg = super.getMessage();
                if (msg != null && msg.length() > 2000) {
                    msg = String.valueOf(msg.substring(0, 2000)) + " ... ";
                }
                return msg;
            }
        };
        for (EObject eObject : eObjects) {
            progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(eObject)}));
            diagnostician.validate(eObject, (DiagnosticChain)diagnostics);
        }
        this.success = diagnostics.getSeverity() == 0;
        return diagnostics;
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        if (diagnostic != null) {
            if (this.showSuccess || !this.isSuccessful()) {
                ValidateAction.EclipseResourcesUtil savedRef = this.eclipseResourcesUtil;
                this.eclipseResourcesUtil = null;
                try {
                    super.handleDiagnostic(diagnostic);
                }
                finally {
                    this.eclipseResourcesUtil = savedRef;
                }
            }
            if (this.eclipseResourcesUtil != null) {
                IWorkbenchPart part;
                Viewer viewer = null;
                if (!diagnostic.getChildren().isEmpty()) {
                    HashMap<Diagnostic, Resource> diagnosticToResourceMap = new HashMap<Diagnostic, Resource>();
                    for (Diagnostic diagnostic2 : diagnostic.getChildren()) {
                        Resource resource;
                        Object o;
                        List data = diagnostic2.getData();
                        if (data.isEmpty() || !((o = data.get(0)) instanceof EObject) || (resource = ((EObject)o).eResource()) == null) continue;
                        diagnosticToResourceMap.put(diagnostic2, resource);
                    }
                    for (Map.Entry entry : diagnosticToResourceMap.entrySet()) {
                        Diagnostic childDiagnostic = (Diagnostic)entry.getKey();
                        Resource resource = (Resource)entry.getValue();
                        this.eclipseResourcesUtil.createMarkers(resource, childDiagnostic);
                    }
                    List data = ((Diagnostic)diagnostic.getChildren().get(0)).getData();
                    if (!data.isEmpty()) {
                        IWorkbenchPart iWorkbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                        Object e = data.get(0);
                        if (iWorkbenchPart instanceof ISetSelectionTarget) {
                            ((ISetSelectionTarget)iWorkbenchPart).selectReveal((ISelection)new StructuredSelection(e));
                        } else if (iWorkbenchPart instanceof IViewerProvider && (viewer = ((IViewerProvider)iWorkbenchPart).getViewer()) != null) {
                            viewer.setSelection((ISelection)new StructuredSelection(data.get(0)), true);
                        }
                    }
                }
                if (viewer == null && (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IViewerProvider) {
                    viewer = ((IViewerProvider)part).getViewer();
                }
                if (viewer != null) {
                    MethodElementLabelDecorator.clearDecorationCache();
                    viewer.refresh();
                }
                try {
                    this.refreshViews();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void deleteMarkers() {
        Iterator iter = this.resources.iterator();
        while (iter.hasNext()) {
            this.eclipseResourcesUtil.deleteMarkers((Object)((Resource)iter.next()));
        }
    }

    protected void refreshViews() {
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (selection == null) {
            this.deleteMarkers();
            return false;
        }
        return super.updateSelection(selection);
    }
}

