/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.category.StandardCategoriesItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ActivityHandler;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.ui.actions.ILibraryAction;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;

public class LibraryViewPasteAction
extends PasteAction
implements ILibraryAction {
    private IProgressMonitor progressMonitor;

    public void run() {
        LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
        runner.setProgressMonitor(this.getProgressMonitor());
        runner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                TraceableAdapterFactoryEditingDomain tDomain = null;
                if (LibraryViewPasteAction.this.domain instanceof TraceableAdapterFactoryEditingDomain) {
                    tDomain = (TraceableAdapterFactoryEditingDomain)LibraryViewPasteAction.this.domain;
                    tDomain.setExtenalMaintainedCopyMap(new HashMap());
                }
                LibraryViewPasteAction.this.performPaste();
                if (tDomain != null) {
                    HashSet resouresToSave = new HashSet();
                    Map map = tDomain.getExtenalMaintainedCopyMap();
                    LibraryEditUtil.getInstance().fixWpStates(map.keySet(), resouresToSave);
                    ActivityHandler.fixGuidReferences((Map)map, (boolean)false, (boolean)true, resouresToSave);
                    LibraryEditUtil.getInstance().fixProcssWpStates(map.keySet(), resouresToSave);
                    ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                    try {
                        try {
                            for (MultiFileXMIResourceImpl res : resouresToSave) {
                                res.setModified(true);
                                persister.save((Resource)res);
                            }
                            persister.commit();
                        }
                        catch (Exception e) {
                            persister.rollback();
                            e.printStackTrace();
                            if (tDomain != null) {
                                tDomain.setExtenalMaintainedCopyMap(null);
                            }
                        }
                    }
                    finally {
                        if (tDomain != null) {
                            tDomain.setExtenalMaintainedCopyMap(null);
                        }
                    }
                }
            }
        });
    }

    protected void performPaste() {
        if (this.command instanceof PasteFromClipboardCommand) {
            IStatus status;
            PasteFromClipboardCommand cmd = (PasteFromClipboardCommand)this.command;
            Object owner = cmd.getOwner();
            if (owner instanceof Adapter) {
                owner = ((Adapter)owner).getTarget();
            }
            if (owner instanceof EObject && !(status = UserInteractionHelper.checkModify((EObject)((EObject)owner), (Object)MsgBox.getDefaultShell())).isOK()) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(this.getText(), null, status);
                return;
            }
        }
        if (this.command == null) {
            return;
        }
        super.run();
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty() || selection.size() != 1) {
            return false;
        }
        Object object = selection.getFirstElement();
        if (object instanceof MethodPlugin) {
            return false;
        }
        if (object instanceof StandardCategoriesItemProvider) {
            return false;
        }
        return super.updateSelection(selection);
    }

    public void notifyPropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }
}

