/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LibraryViewSimpleAction
extends Action {
    private LibraryView libraryView;

    public LibraryViewSimpleAction(LibraryView libView, String text) {
        super(text);
        this.libraryView = libView;
    }

    protected abstract void doRun();

    public void run() {
        LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
        runner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                LibraryViewSimpleAction.this.doRun();
            }
        });
    }

    public boolean updateSelection(IStructuredSelection selection) {
        return true;
    }

    protected LibraryView getLibraryView() {
        return this.libraryView;
    }

    protected Object getSelectionParentObject() {
        TreeItem[] selectedItems = this.getLibraryView().getTreeViewer().getTree().getSelection();
        if (selectedItems == null || selectedItems.length == 0) {
            return null;
        }
        TreeItem item = selectedItems[0].getParentItem();
        return TngUtil.unwrap((Object)item.getData());
    }

    public static boolean save(Collection<Resource> resouresToSave) {
        ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
        try {
            HashSet<MultiFileXMIResourceImpl> seens = new HashSet<MultiFileXMIResourceImpl>();
            for (MultiFileXMIResourceImpl multiFileXMIResourceImpl : resouresToSave) {
                if (seens.contains(multiFileXMIResourceImpl)) continue;
                persister.save((Resource)multiFileXMIResourceImpl);
                seens.add(multiFileXMIResourceImpl);
            }
            persister.commit();
        }
        catch (Exception exception) {
            persister.rollback();
            return false;
        }
        return true;
    }

    public static abstract class CustomeCategoryAction
    extends LibraryViewSimpleAction {
        public CustomeCategoryAction(LibraryView libView, String text) {
            super(libView, text);
        }

        protected boolean checkModify() {
            IStructuredSelection selection = (IStructuredSelection)this.getLibraryView().getSelection();
            for (Object element : selection) {
                if (!(element instanceof MethodElement) && !((element = TngUtil.unwrap(element)) instanceof CustomCategory) || this.checkModify(element)) continue;
                return false;
            }
            return true;
        }

        protected boolean checkModify(Object element) {
            if (element instanceof MethodElement || (element = TngUtil.unwrap((Object)element)) instanceof CustomCategory) {
                EObject container = ((EObject)element).eContainer();
                IStatus status = UserInteractionHelper.checkModify((EObject)container, (Object)this.getLibraryView().getSite().getShell());
                if (container != null && !status.isOK()) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.errorDialog_moveError, status);
                    return false;
                }
            }
            return true;
        }
    }
}

