/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.authoring.ui.dialogs.MethodAddLinkDialog;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.ui.LibraryUIUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.actions.AddLinkAction;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MethodAddLinkAction
extends AddLinkAction {
    public MethodAddLinkAction(IRichText richText) {
        super(richText);
    }

    public void execute(IRichText richText) {
        if (richText != null) {
            if (richText instanceof IMethodRichText) {
                String linkURL;
                MethodAddLinkDialog dialog = new MethodAddLinkDialog(Display.getCurrent().getActiveShell(), (IMethodRichText)richText);
                dialog.open();
                if (dialog.getReturnCode() == 0 && (linkURL = dialog.getLink().getURL()).length() > 0) {
                    if (dialog.getFileToCopy() != null) {
                        try {
                            linkURL = LibraryUIUtil.getURLForAttachment((Shell)Display.getCurrent().getActiveShell(), (File)dialog.getFileToCopy(), (MethodElement)((IMethodRichText)richText).getMethodElement(), (boolean)true);
                            if (linkURL == null) {
                                return;
                            }
                            String url = "<a href=\"";
                            url = Platform.getOS().equals("win32") ? String.valueOf(url) + NetUtil.encodeFileURL((String)("file:/" + linkURL)) : String.valueOf(url) + NetUtil.encodeFileURL((String)("./" + linkURL));
                            linkURL = url = String.valueOf(url) + "\"" + (dialog.getOpenLinkInNewWindow() ? " target=\"_blank\"" : "") + ">" + new File(linkURL).getName() + "</a>";
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (richText instanceof RichTextEditor) {
                        ((RichTextEditor)richText).addHTML(linkURL);
                    } else {
                        richText.executeCommand("addHTML", linkURL);
                    }
                }
            } else {
                super.execute(richText);
            }
        }
    }
}

