/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.ui.action.StaticSelectionCommandAction;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.actions.CreateMethodElementCommand;
import org.eclipse.epf.library.edit.process.command.CreateProcessComponentCommand;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.provider.UmaEditPlugin;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;

public final class MethodCreateChildAction
extends StaticSelectionCommandAction {
    protected Object descriptor;

    public MethodCreateChildAction(EditingDomain editingDomain, ISelection selection, Object descriptor) {
        this.editingDomain = editingDomain;
        this.descriptor = descriptor;
        this.configureAction(selection);
    }

    protected Command createActionCommand(EditingDomain editingDomain, Collection collection) {
        if (collection.size() == 1) {
            Object owner = collection.iterator().next();
            Object cmd = null;
            if (this.descriptor instanceof CommandParameter && ((CommandParameter)this.descriptor).getValue() instanceof ProcessComponent) {
                CommandParameter newChildParameter = (CommandParameter)this.descriptor;
                CreateChildCommand.Helper helper = (CreateChildCommand.Helper)((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory().adapt(owner, IEditingDomainItemProvider.class);
                cmd = new CreateProcessComponentCommand(editingDomain, (EObject)owner, newChildParameter.getEStructuralFeature(), newChildParameter.getValue(), newChildParameter.getIndex(), collection, helper){};
            } else {
                cmd = CreateChildCommand.create((EditingDomain)editingDomain, owner, (Object)this.descriptor, (Collection)collection);
            }
            if (this.isUserDefinedType()) {
                return new CreateMethodElementCommand((Command)cmd){

                    public String getText() {
                        String name = MethodCreateChildAction.this.getNameForUserDefinedType();
                        if (name != null) {
                            return name;
                        }
                        return super.getText();
                    }

                    public Object getImage() {
                        Object img = MethodCreateChildAction.this.getImageForUserDefinedType();
                        if (img != null) {
                            return img;
                        }
                        return super.getImage();
                    }
                };
            }
            return new CreateMethodElementCommand((Command)cmd);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private void superRun() {
        super.run();
    }

    public void run() {
        LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
        runner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                MethodCreateChildAction.this.superRun();
            }
        });
    }

    private boolean isUserDefinedType() {
        try {
            if (this.descriptor instanceof CommandParameter && ((CommandParameter)this.descriptor).getValue() instanceof Practice) {
                Practice prac = (Practice)((CommandParameter)this.descriptor).getValue();
                UserDefinedTypeMeta udtMeta = PracticePropUtil.getPracticePropUtil().getUtdData(prac);
                if (udtMeta != null) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return false;
    }

    private String getNameForUserDefinedType() {
        try {
            if (this.isUserDefinedType()) {
                Practice prac = (Practice)((CommandParameter)this.descriptor).getValue();
                UserDefinedTypeMeta udtMeta = PracticePropUtil.getPracticePropUtil().getUtdData(prac);
                return (String)udtMeta.getRteNameMap().get("typeName");
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    private Object getImageForUserDefinedType() {
        if (this.isUserDefinedType()) {
            Practice prac = (Practice)((CommandParameter)this.descriptor).getValue();
            ImageDescriptor image = TngUtil.getImageForUdt((Practice)prac);
            if (image == null) {
                return UmaEditPlugin.INSTANCE.getImage("full/obj16/UdtNode");
            }
            return image;
        }
        return null;
    }
}

