/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.actions.LibraryValidateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class MethodLibraryActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(this.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                MethodLibraryActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(this.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return MethodLibraryActionBarContributor.this.activeEditor instanceof IViewerProvider;
        }

        public void run() {
            MethodLibraryActionBarContributor.this.doRefresh();
        }
    };
    protected Collection createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection createSiblingActions;
    protected IMenuManager createSiblingMenuManager;
    protected String name;
    protected boolean enabled = true;

    public MethodLibraryActionBarContributor() {
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new LibraryValidateAction();
        this.name = "MethodElementEditor";
    }

    public MethodLibraryActionBarContributor(String name) {
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new LibraryValidateAction();
        this.name = name;
    }

    protected DeleteAction createDeleteAction() {
        return new DeleteAction(this.removeAllReferencesOnDelete());
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.deleteAction = this.createDeleteAction();
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.cutAction = this.createCutAction();
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        this.copyAction = this.createCopyAction();
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.pasteAction = this.createPasteAction();
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    protected CopyAction createCopyAction() {
        return new CopyAction();
    }

    protected PasteAction createPasteAction() {
        return new PasteAction();
    }

    protected CutAction createCutAction() {
        return new CutAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator(String.valueOf(this.name) + "-settings"));
        toolBarManager.add((IContributionItem)new Separator(String.valueOf(this.name) + "-additions"));
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void contributeToMenu(IMenuManager menuManager) {
        IMenuManager editMenu = menuManager.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)new Separator("group.assist"));
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void setActivePage(IEditorPart part) {
        if (part != null) {
            this.setActiveEditor(part);
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditor).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
        if (!(this.activeEditor instanceof FormEditor)) {
            this.update();
        }
    }

    protected Collection generateCreateChildActions(Collection descriptors, ISelection selection) {
        ArrayList<CreateChildAction> actions = new ArrayList<CreateChildAction>();
        if (descriptors != null) {
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateChildAction(this.activeEditor, selection, i.next()));
            }
        }
        return actions;
    }

    protected Collection generateCreateSiblingActions(Collection descriptors, ISelection selection) {
        ArrayList<CreateSiblingAction> actions = new ArrayList<CreateSiblingAction>();
        if (descriptors != null) {
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateSiblingAction(this.activeEditor, selection, i.next()));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection actions, String contributionID) {
        if (actions != null) {
            for (IAction action : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, action);
                    continue;
                }
                manager.add(action);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    protected void updatePasteAction() {
        ISelectionProvider selectionProvider;
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            this.pasteAction.setEnabled(this.pasteAction.updateSelection((IStructuredSelection)structuredSelection));
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.updatePasteAction();
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("edit"));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions-end"));
        this.addGlobalActions(menuManager);
        if (this.enabled) {
            MenuManager submenuManager = null;
            submenuManager = new MenuManager(this.getString("_UI_CreateChild_menu_item"));
            this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
            menuManager.insertBefore("additions", (IContributionItem)submenuManager);
            submenuManager = new MenuManager(this.getString("_UI_CreateSibling_menu_item"));
            this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
            menuManager.insertBefore("additions", (IContributionItem)submenuManager);
        }
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        String key;
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        String string = key = (this.style & 1) == 0 ? "additions-end" : "additions";
        if (this.validateAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new ActionContributionItem((IAction)this.validateAction));
        }
    }

    protected String getString(String key) {
        return AuthoringUIPlugin.getDefault().getString(key);
    }

    protected void doRefresh() {
        Viewer viewer;
        if (this.activeEditor instanceof IViewerProvider && (viewer = ((IViewerProvider)this.activeEditor).getViewer()) != null) {
            viewer.refresh();
        }
    }

    protected boolean removeAllReferencesOnDelete() {
        return false;
    }

    public void activate() {
        if (this.activeEditor != null) {
            IActionBars actionBars = this.activeEditor.getEditorSite().getActionBars();
            if (this.activeEditor instanceof FormEditor) {
                IFormPage page = ((FormEditor)this.activeEditor).getActivePageInstance();
                if (page instanceof IFormPage) {
                    actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
                    actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
                    actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
                    actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
                    actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
                    actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), null);
                }
            } else {
                actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
                actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
                actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
                actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
                actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
                actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
            }
            actionBars.updateActionBars();
        }
        super.activate();
    }
}

