/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.IModifyingAction;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameAction
extends CommandActionHandler
implements IWorkbenchPartAction,
IModifyingAction {
    private static final String LABEL = AuthoringUIResources.renameAction_text;
    private IStructuredSelection selection;
    private IWorkbenchPart activePart;

    public RenameAction(String text) {
        super(null, text);
    }

    public RenameAction() {
        this(LABEL);
    }

    private boolean canRename(IStructuredSelection selection) {
        if (!(this.domain instanceof AdapterFactoryEditingDomain) || selection.size() > 1) {
            return false;
        }
        Object element = TngUtil.unwrap((Object)selection.getFirstElement());
        return element instanceof NamedElement && !TngUtil.isPredefined((MethodElement)((MethodElement)element));
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean ret = false;
        if (this.canRename(selection)) {
            this.selection = selection;
            ret = super.updateSelection(selection);
        }
        this.setEnabled(ret);
        return ret;
    }

    public Command createCommand(Collection<?> selection) {
        if (selection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        Object o = TngUtil.unwrap(selection.iterator().next());
        if (o instanceof NamedElement) {
            return new RenameCommand((NamedElement)o, null);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
        this.activePart = workbenchPart;
    }

    private void superRun() {
        IStatus status;
        NamedElement e = (NamedElement)TngUtil.unwrap((Object)this.selection.getFirstElement());
        Shell shell = this.activePart.getSite().getShell();
        if (e.eContainer() != null && e.eContainer().eResource() != e.eResource() && !(status = UserInteractionHelper.checkModify((EObject)e.eContainer(), (Object)shell)).isOK()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.renameDialog_renameError, status);
            return;
        }
        if (!FileUtil.getValidateEdit().renamePrecheck((Object)e, (Object)shell)) {
            return;
        }
        final IValidator validator = IValidatorFactory.INSTANCE.createNameValidator(e, ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory());
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                if (validator != null) {
                    return UserInteractionHelper.getSimpleErrorMessage((String)validator.isValid(newText));
                }
                return null;
            }
        };
        boolean getInput = true;
        InputDialog inputDlg = new InputDialog(Display.getCurrent().getActiveShell(), AuthoringUIResources.rename_text, AuthoringUIResources.newname_text, e.getName(), inputValidator);
        while (getInput) {
            getInput = false;
            if (inputDlg.open() != 0) continue;
            String newName = inputDlg.getValue().trim();
            if (e instanceof ContentElement) {
                newName = StrUtil.makeValidFileName((String)newName);
            }
            if (newName.equals(e.getName())) continue;
            if (e instanceof MethodConfiguration) {
                String[] configNames = LibraryServiceUtil.getMethodConfigurationNames((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
                int i = 0;
                while (i < configNames.length) {
                    if (newName.equals(configNames[i])) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.duplicateElementNameError_msg, (Object)newName));
                        getInput = true;
                        break;
                    }
                    ++i;
                }
            }
            if (getInput) {
                inputDlg = new InputDialog(Display.getCurrent().getActiveShell(), AuthoringUIResources.rename_text, AuthoringUIResources.newname_text, e.getName(), inputValidator);
                continue;
            }
            if (e instanceof MethodPlugin) {
                String title = AuthoringUIResources.methodPluginDescriptionPage_confirmRename_title;
                String msg = AuthoringUIResources.bind((String)AuthoringUIResources.methodPluginDescriptionPage_confirmRename, (Object[])new Object[]{e.getName(), newName});
                if (!MessageDialog.openConfirm((Shell)shell, (String)title, (String)msg)) {
                    return;
                }
                EditorChooser.getInstance().closeMethodEditorsForPluginElements((MethodPlugin)e);
            }
            RenameCommand renameCmd = (RenameCommand)this.command;
            renameCmd.setNewName(newName);
            renameCmd.setShell(shell);
            super.run();
        }
    }

    public void run() {
        BusyIndicator.showWhile((Display)this.activePart.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
                runner.run(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        RenameAction.this.superRun();
                    }
                });
            }
        });
    }

    public static void doRename(NamedElement e, String newName) {
        new RenameCommand(e, newName).execute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenameCommand
    extends AbstractCommand {
        private NamedElement e;
        private String newName;
        private String oldName;
        private Shell shell;
        Collection<Resource> renamedResources;

        public RenameCommand(NamedElement e, String newName) {
            this.e = e;
            this.newName = newName;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public void setShell(Shell shell) {
            this.shell = shell;
        }

        private void rollback() {
            this.setName(this.oldName);
            if (!this.renamedResources.isEmpty()) {
                this.adjustLocation(this.renamedResources, new ArrayList<Resource>());
            }
        }

        private void handlePersistenceException(Exception e1) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e1);
            String details = e1.getMessage() != null ? MessageFormat.format(": {0}", e1.getMessage()) : "";
            String msg = MessageFormat.format(AuthoringUIResources.ElementsView_err_saving, this.e.eResource().getURI().toFileString(), details);
            throw new MessageException(msg);
        }

        private ILibraryPersister.FailSafeMethodLibraryPersister getPersister() {
            return LibraryServiceUtil.getPersisterFor((Resource)this.e.eResource()).getFailSafePersister();
        }

        private IStatus adjustLocation(Collection<Resource> renamedResources) {
            ArrayList<Resource> resourcesToRename = new ArrayList<Resource>();
            if (this.e instanceof ContentElement && ContentDescriptionFactory.hasPresentation((MethodElement)((MethodElement)this.e))) {
                resourcesToRename.add(((ContentElement)this.e).getPresentation().eResource());
            }
            resourcesToRename.add(this.e.eResource());
            return this.adjustLocation(resourcesToRename, renamedResources);
        }

        private IStatus adjustLocation(Collection<Resource> resourcesToRename, Collection<Resource> renamedResources) {
            ILibraryPersister.FailSafeMethodLibraryPersister persister = this.getPersister();
            try {
                for (Resource resource : resourcesToRename) {
                    URI oldURI = resource.getURI();
                    persister.adjustLocation(resource);
                    if (resource.getURI().equals((Object)oldURI)) continue;
                    renamedResources.add(resource);
                }
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                try {
                    persister.rollback();
                }
                catch (Exception exception) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
                return new Status(4, AuthoringUIPlugin.getDefault().getId(), e.getMessage(), (Throwable)e);
            }
        }

        private void setName(String newName) {
            this.e.setName(newName);
            if (this.e instanceof ProcessComponent) {
                Process proc = ((ProcessComponent)this.e).getProcess();
                proc.setName(newName);
            }
        }

        public void execute() {
            this.oldName = this.e.getName();
            this.setName(this.newName);
            IStatus status = UserInteractionHelper.checkModify((EObject)this.e, (Object)(this.shell == null ? MsgBox.getDefaultShell() : this.shell));
            if (status.isOK() && this.e instanceof DescribableElement) {
                ContentDescription presentation = ((DescribableElement)this.e).getPresentation();
                status = UserInteractionHelper.checkModify((EObject)presentation, (Object)(this.shell == null ? MsgBox.getDefaultShell() : this.shell));
            }
            if (!status.isOK()) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.renameDialog_renameError, status);
                return;
            }
            this.renamedResources = new ArrayList<Resource>();
            Runnable runnable = new Runnable(){

                public void run() {
                    IStatus status = RenameCommand.this.adjustLocation(RenameCommand.this.renamedResources);
                    if (!status.isOK()) {
                        RenameCommand.this.rollback();
                        Exception ex = (Exception)status.getException();
                        throw ex instanceof RuntimeException ? (RuntimeException)ex : new WrappedException(ex);
                    }
                }
            };
            boolean result = UserInteractionHelper.runWithProgress((Runnable)runnable, (String)AuthoringUIResources.ElementsView_renaming_text);
            if (!result) {
                return;
            }
            status = UserInteractionHelper.checkModify((EObject)this.e, (Object)(this.shell == null ? MsgBox.getDefaultShell() : this.shell));
            if (!status.isOK()) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.renameDialog_renameError, status);
                UserInteractionHelper.runWithProgress((Runnable)new Runnable(){

                    public void run() {
                        RenameCommand.this.rollback();
                    }
                }, (String)"");
                return;
            }
            runnable = new Runnable(){

                public void run() {
                    Process proc;
                    DiagramManager mgr;
                    ILibraryPersister.FailSafeMethodLibraryPersister persister = RenameCommand.this.getPersister();
                    try {
                        try {
                            persister.save(RenameCommand.this.e.eResource());
                            persister.commit();
                        }
                        catch (Exception e1) {
                            try {
                                persister.rollback();
                            }
                            catch (Exception e) {
                                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                            }
                            RenameCommand.this.handlePersistenceException(e1);
                        }
                    }
                    catch (RuntimeException e) {
                        RenameCommand.this.rollback();
                        throw e;
                    }
                    if (RenameCommand.this.e instanceof ProcessComponent && (mgr = DiagramManager.getInstance((Process)(proc = ((ProcessComponent)RenameCommand.this.e).getProcess()), (Object)this)) != null) {
                        try {
                            try {
                                mgr.updateResourceURI();
                            }
                            catch (Exception e) {
                                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                                try {
                                    mgr.removeConsumer((Object)this);
                                }
                                catch (Exception e2) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e2);
                                }
                            }
                        }
                        finally {
                            try {
                                mgr.removeConsumer((Object)this);
                            }
                            catch (Exception e) {
                                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                            }
                        }
                    }
                }
            };
            UserInteractionHelper.runWithProgress((Runnable)runnable, (String)AuthoringUIResources.ElementsView_renaming_text);
        }

        public void redo() {
            this.execute();
        }

        protected boolean prepare() {
            return true;
        }

        public void dispose() {
            this.e = null;
            super.dispose();
        }
    }
}

