/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.LibraryViewSimpleAction;
import org.eclipse.epf.authoring.ui.forms.CustomCategoryAssignPage;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.LibraryModificationHelper;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnassignAction
extends LibraryViewSimpleAction.CustomeCategoryAction {
    public UnassignAction(LibraryView libView) {
        super(libView, AuthoringUIResources.unassignAction_text);
    }

    @Override
    protected void doRun() {
        if (!this.checkModify()) {
            return;
        }
        Collection<Resource> resouceToSave = this.doRunBeforeSave();
        UnassignAction.save(resouceToSave);
    }

    private Collection<Resource> doRunBeforeSave() {
        IStructuredSelection selection = (IStructuredSelection)this.getLibraryView().getSelection();
        Object element = selection.getFirstElement();
        if (!((element = TngUtil.unwrap((Object)element)) instanceof CustomCategory)) {
            return null;
        }
        CustomCategory category = (CustomCategory)element;
        EObject container = category.eContainer();
        IStatus status = UserInteractionHelper.checkModify((EObject)container, (Object)this.getLibraryView().getSite().getShell());
        if (container != null && !status.isOK()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.errorDialog_title, AuthoringUIResources.errorDialog_moveError, status);
            return null;
        }
        Object parent = this.getSelectionParentObject();
        if (!(parent instanceof CustomCategory)) {
            return null;
        }
        CustomCategory parentCc = (CustomCategory)parent;
        UnassignAction.unassign(this.getLibraryView().getSite().getShell(), element, parentCc, new ArrayList());
        return Collections.singleton(parentCc.eResource());
    }

    public static void unassign(Shell shell, Object element, final CustomCategory parentCc, final ArrayList usedCategories) {
        final LibraryModificationHelper helper = new LibraryModificationHelper();
        final ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(element);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                CustomCategoryAssignPage.removeItemsFromModel1(elements, parentCc, usedCategories, (IActionManager)helper.getActionManager(), CustomCategoryAssignPage.getAncestors(parentCc));
            }
        });
    }
}

