/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.IModifyingAction;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.library.edit.process.command.UpdateSuppressionFromBaseCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSuppressionFromBaseAction
extends CommandActionHandler
implements IWorkbenchPartAction,
IModifyingAction {
    private ProcessEditor editor;

    public UpdateSuppressionFromBaseAction(String text) {
        super(null, text);
    }

    public UpdateSuppressionFromBaseAction() {
        this(AuthoringUIResources.ProcessEditor_updateSuppressionFromBaseAction_label);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ArrayList list = new ArrayList();
        for (Object element : selection) {
            if (!Suppression.isValid(element)) continue;
            list.add(element);
        }
        if (list.isEmpty()) {
            return false;
        }
        if (list.size() == 1 && ProcessUtil.isRolledUpDescriptor(list.get(0), (AdapterFactory)((AdapterFactoryEditingDomain)this.domain).getAdapterFactory())) {
            return false;
        }
        return super.updateSelection((IStructuredSelection)new StructuredSelection(list));
    }

    public Command createCommand(Collection<?> selection) {
        return new UpdateSuppressionFromBaseCommand(this.getText(), selection, this.editor.getAdapterFactory(), this.editor.getSuppression()){

            public void execute() {
                super.execute();
                if (!this.getAffectedObjects().isEmpty()) {
                    UpdateSuppressionFromBaseAction.this.editor.refreshAllProcessEditors();
                }
            }

            public void undo() {
                super.undo();
                if (!this.getAffectedObjects().isEmpty()) {
                    UpdateSuppressionFromBaseAction.this.editor.refreshAllProcessEditors();
                }
            }
        };
    }

    @Override
    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
        if (workbenchPart instanceof ProcessEditor) {
            this.editor = (ProcessEditor)workbenchPart;
        } else if (workbenchPart == null) {
            this.editor = null;
        }
    }

    private void superRun() {
        super.run();
    }

    public void run() {
        BusyIndicator.showWhile((Display)this.editor.getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                UpdateSuppressionFromBaseAction.this.superRun();
            }
        });
    }
}

