/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.celleditors;

import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.celleditors.AbstractCheckBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ProcessCheckBoxCellEditor
extends AbstractCheckBoxCellEditor {
    private final Image checkImage = AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/Check.gif");
    private final Image uncheckImage = AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/Uncheck.gif");
    private final Image disableCheckImage = AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/DisableCheck.gif");
    private final Image disableUncheckImage = AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/DisableUncheck.gif");
    private SelectionListener listener;

    public ProcessCheckBoxCellEditor(Composite tree) {
        super(tree);
    }

    public Image getImage(TreeItem item, String columnproperty) {
        ICellModifier modifier = this.getCellModifier();
        Object element = item.getData();
        if (element == null) {
            return null;
        }
        Object value = modifier.getValue(element, columnproperty);
        if (value == null || !(value instanceof Boolean)) {
            return null;
        }
        boolean canModify = modifier.canModify(element, columnproperty);
        if (((Boolean)value).booleanValue()) {
            return canModify ? this.checkImage : this.disableCheckImage;
        }
        return canModify ? this.uncheckImage : this.disableUncheckImage;
    }

    public void modify(TreeItem item, String columnproperty) {
        ICellModifier modifier = this.getCellModifier();
        if (!modifier.canModify(item.getData(), columnproperty)) {
            return;
        }
        modifier.modify((Object)item, columnproperty, (Object)new Boolean((Boolean)modifier.getValue(item.getData(), columnproperty) == false));
    }

    protected Control createControl(Tree parent) {
        Button button = new Button((Composite)parent, 32);
        button.pack();
        return button;
    }

    protected void hookControl(Control control, TreeItem item, final String columnproperty) {
        final ICellModifier modifier = this.getCellModifier();
        final TreeItem element = item;
        final Button checkbox = (Button)control;
        if (this.listener != null) {
            checkbox.removeSelectionListener(this.listener);
        }
        this.listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                modifier.modify(element, columnproperty, (Object)new Boolean(checkbox.getSelection()));
            }
        };
        checkbox.addSelectionListener(this.listener);
    }
}

