/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.LibraryViewSimpleAction;
import org.eclipse.epf.authoring.ui.actions.UnassignAction;
import org.eclipse.epf.authoring.ui.forms.CustomCategoryAssignPage;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.common.utils.ExtensionHelper;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.UniqueNamePNameHandler;
import org.eclipse.epf.library.services.LibraryModificationHelper;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceScanner;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignDialog
extends Dialog
implements ISelectionChangedListener {
    ArrayList usedCategories = new ArrayList();
    private TreeViewer treeViewer;
    private ArrayList elements = new ArrayList();
    private Object destination;
    private boolean assigning = false;
    private ProgressMonitorPart progressMonitorPart;
    private Cursor waitCursor;
    private boolean lockedUI = false;

    public static AssignDialog newAssignDialog(Shell parentShell, Collection elements) {
        return new AssignDialog(parentShell, elements);
    }

    public static AssignDialog newReassignDialog(Shell parentShell, Collection elements, MethodElement parentElement) {
        return new ReassignDialog(parentShell, elements, parentElement);
    }

    public static AssignDialog newDeepCopyDialog(Shell parentShell, Collection elements) {
        Object[] context = new Object[]{parentShell, elements};
        Object obj = ExtensionHelper.create(CustomCategoryDeepCopyDialog.class, (Object)context);
        if (obj instanceof CustomCategoryDeepCopyDialog) {
            return (CustomCategoryDeepCopyDialog)((Object)obj);
        }
        return new CustomCategoryDeepCopyDialog(parentShell, elements);
    }

    protected AssignDialog(Shell parentShell, Collection elementsToAssign) {
        super(parentShell);
        this.elements.addAll(elementsToAssign);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        Label label = new Label(composite, 0);
        label.setText(AuthoringUIResources.MoveDialog_destination_text);
        GridData layoutData = new GridData(1);
        label.setLayoutData((Object)layoutData);
        this.treeViewer = new TreeViewer(composite, 2820);
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData spec = new GridData(1808);
        spec.widthHint = 300;
        spec.heightHint = 300;
        this.treeViewer.getControl().setLayoutData((Object)spec);
        this.treeViewer.setInput((Object)LibraryService.getInstance().getCurrentMethodLibrary());
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        this.progressMonitorPart = this.createProgressMonitorPart(composite, pmlayout);
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        this.progressMonitorPart.setVisible(false);
        this.waitCursor = parent.getShell().getDisplay().getSystemCursor(1);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(AuthoringUIResources.AssignDialog_assign_text);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.destination = TngUtil.unwrap((Object)((IStructuredSelection)event.getSelection()).getFirstElement());
    }

    protected void okPressed() {
        if (this.doAssign()) {
            super.okPressed();
        }
    }

    private boolean isValidDestination() {
        if (!(this.destination instanceof CustomCategory)) {
            return false;
        }
        if (this.elements == null || this.elements.isEmpty()) {
            return false;
        }
        MethodPlugin targetPlugin = LibraryUtil.getMethodPlugin((EObject)((CustomCategory)this.destination));
        if (targetPlugin == null) {
            return false;
        }
        if (this.elements.get(0) instanceof MethodElement) {
            MethodPlugin sourcePlugin = LibraryUtil.getMethodPlugin((EObject)((MethodElement)this.elements.get(0)));
            if (sourcePlugin == targetPlugin) {
                return true;
            }
            if (targetPlugin.getBases().contains(sourcePlugin)) {
                return true;
            }
        }
        return false;
    }

    private boolean doAssign() {
        if (this.destination == null) {
            String title = AuthoringUIResources.errorDialog_title;
            String problem = AuthoringUIResources.MoveDialog_nomove_destination_problem_msg;
            String msg = AuthoringUIResources.MoveDialog_selectdestination_text;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, problem, msg);
            return false;
        }
        if (!this.isValidDestination()) {
            String title = AuthoringUIResources.errorDialog_title;
            String problem = AuthoringUIResources.MoveDialog_invalid_move_destination_problem_msg;
            String msg = AuthoringUIResources.MoveDialog_validdestination_text;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, problem, msg);
            return false;
        }
        IStatus status = UserInteractionHelper.checkModify((EObject)((EObject)this.destination), (Object)this.getShell());
        if (!status.isOK()) {
            String title = AuthoringUIResources.errorDialog_title;
            String msg = AuthoringUIResources.MoveDialog_cannotModifyDestination;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, msg, status);
            return false;
        }
        this.assigning = true;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.subTask(AuthoringUIResources.assignAction_text);
                try {
                    Collection<Resource> resouresToSave = AssignDialog.this.doWorkBeforeSave();
                    LibraryViewSimpleAction.save(resouresToSave);
                }
                finally {
                    AssignDialog.this.assigning = false;
                }
            }
        };
        Shell shell = this.getShell();
        shell.setCursor(this.waitCursor);
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(false);
        this.treeViewer.getControl().setEnabled(false);
        this.progressMonitorPart.setVisible(true);
        IStatus stat = null;
        try {
            try {
                stat = UserInteractionHelper.getUIHelper().runInModalContext(runnable, true, (IProgressMonitor)this.progressMonitorPart, (Object)shell);
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                this.progressMonitorPart.done();
                return true;
            }
        }
        finally {
            this.progressMonitorPart.done();
        }
        if (stat != null && !stat.isOK()) {
            String title = AuthoringUIResources.errorDialog_title;
            String msg = AuthoringUIResources.dialogs_AssignDialog_errorMessage;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, msg, stat);
        }
        return true;
    }

    protected Collection<Resource> doWorkBeforeSave() {
        final LibraryModificationHelper helper = new LibraryModificationHelper();
        final CustomCategory category = (CustomCategory)this.destination;
        final HashSet<Resource> resouresToSave = new HashSet<Resource>();
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                CustomCategoryAssignPage.addItemsToModel1(AssignDialog.this.elements, category, AssignDialog.this.usedCategories, (IActionManager)helper.getActionManager(), CustomCategoryAssignPage.getAncestors(category));
                resouresToSave.add(category.eResource());
            }
        });
        return resouresToSave;
    }

    public boolean close() {
        if (this.assigning) {
            return false;
        }
        return super.close();
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
        return new ProgressMonitorPart(composite, (Layout)pmlayout, -1){
            String currentTask;
            {
                this.currentTask = null;
            }

            public void setBlocked(IStatus reason) {
                super.setBlocked(reason);
                if (!AssignDialog.this.lockedUI) {
                    AssignDialog.getBlockedHandler().showBlocked(this.getShell(), (IProgressMonitor)this, reason, this.currentTask);
                }
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (!AssignDialog.this.lockedUI) {
                    AssignDialog.getBlockedHandler().clearBlocked();
                }
            }

            public void beginTask(String name, int totalWork) {
                super.beginTask(name, totalWork);
                this.currentTask = name;
            }

            public void setTaskName(String name) {
                super.setTaskName(name);
                this.currentTask = name;
            }

            public void subTask(String name) {
                super.subTask(name);
                if (this.currentTask == null) {
                    this.currentTask = name;
                }
            }
        };
    }

    protected ArrayList getElements() {
        return this.elements;
    }

    protected Object getDestination() {
        return this.destination;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CustomCategoryDeepCopyDialog
    extends AssignDialog {
        ContentPackage customCategoryPkg;
        private UniqueNamePNameHandler nameHandler;
        private ResourceScanner scanner;

        public CustomCategoryDeepCopyDialog(Shell parentShell, Collection elements) {
            super(parentShell, elements);
        }

        @Override
        protected Collection<Resource> doWorkBeforeSave() {
            if (this.getElements() == null || !(this.getElements().get(0) instanceof CustomCategory) || !(this.getDestination() instanceof CustomCategory)) {
                return null;
            }
            CustomCategory source = (CustomCategory)this.getElements().get(0);
            CustomCategory targetParent = (CustomCategory)this.getDestination();
            this.initDeepCopy(source, targetParent);
            CustomCategory copy = (CustomCategory)this.deepCopy((EObject)source, null);
            this.customCategoryPkg.getContentElements().add(copy);
            targetParent.getCategorizedElements().add(copy);
            ArrayList<Resource> resouresToSave = new ArrayList<Resource>();
            resouresToSave.add(targetParent.eResource());
            if (this.scanner != null) {
                this.scanner.copyFiles();
            }
            return resouresToSave;
        }

        protected EObject deepCopy(EObject source, MethodElement copiedOwner) {
            EObject copy = UmaFactory.eINSTANCE.create(source.eClass());
            this.handleNames(source, copy);
            EList features = source.eClass().getEAllStructuralFeatures();
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                this.copyFeatureValue(source, copy, feature, copiedOwner);
                ++i;
            }
            return copy;
        }

        private void handleNames(EObject source, EObject copy) {
            if (copy instanceof CustomCategory) {
                Object name = source.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
                Object pname = source.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName());
                copy.eSet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), name);
                copy.eSet((EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), pname);
                this.nameHandler.ensureUnique((DescribableElement)((CustomCategory)copy));
            }
        }

        private void copyFeatureValue(EObject sourceObj, EObject copiedObj, EStructuralFeature feature, MethodElement copiedOwner) {
            if (feature instanceof EAttribute) {
                this.copyAttributeFeatureValue(sourceObj, copiedObj, (EAttribute)feature, copiedOwner);
            } else if (feature instanceof EReference) {
                this.copyReferenceFeatureValue(sourceObj, copiedObj, (EReference)feature);
            }
        }

        private void copyAttributeFeatureValue(EObject sourceObj, EObject copiedObj, EAttribute feature, MethodElement copiedOwner) {
            Object sourceValue = sourceObj.eGet((EStructuralFeature)feature);
            if (sourceValue == null) {
                return;
            }
            Object copiedValue = sourceValue;
            if (sourceObj instanceof CustomCategory) {
                if (feature == UmaPackage.eINSTANCE.getMethodElement_Guid()) {
                    copiedValue = EcoreUtil.generateUUID();
                    copiedObj.eSet((EStructuralFeature)feature, copiedValue);
                    return;
                }
                if (feature == UmaPackage.eINSTANCE.getNamedElement_Name()) {
                    return;
                }
                if (feature == UmaPackage.eINSTANCE.getMethodElement_PresentationName()) {
                    return;
                }
            } else if (copiedOwner != null && sourceObj instanceof ContentDescription && feature == UmaPackage.eINSTANCE.getMethodElement_Guid()) {
                copiedValue = UmaUtil.generateGUID((String)copiedOwner.getGuid());
                copiedObj.eSet((EStructuralFeature)feature, copiedValue);
                return;
            }
            if (this.scanner != null) {
                if (sourceValue instanceof URI) {
                    URI uri = (URI)sourceValue;
                    String urlStr = this.scanner.registerFileCopy(uri.toString());
                    try {
                        copiedValue = new URI(urlStr);
                    }
                    catch (Exception exception) {
                        copiedValue = sourceValue;
                    }
                } else if (sourceValue instanceof String && sourceObj instanceof MethodElement && copiedObj instanceof MethodElement) {
                    copiedValue = this.scanner.scan((MethodElement)sourceObj, (MethodElement)copiedObj, (String)sourceValue, (EStructuralFeature)feature);
                }
            }
            copiedObj.eSet((EStructuralFeature)feature, copiedValue);
        }

        private void copyReferenceFeatureValue(EObject sourceObj, EObject copiedObj, EReference feature) {
            MethodElement copiedOwner;
            Object sourceValue = sourceObj.eGet((EStructuralFeature)feature);
            if (sourceValue == null) {
                return;
            }
            Object copiedValue = sourceValue;
            MethodElement methodElement = copiedOwner = copiedObj instanceof MethodElement ? (MethodElement)copiedObj : null;
            if (feature.isContainment()) {
                if (feature.isMany()) {
                    List sourceList = (List)sourceValue;
                    List copiedList = (List)copiedObj.eGet((EStructuralFeature)feature);
                    for (EObject sobj : sourceList) {
                        EObject cobj = this.deepCopy(sobj, copiedOwner);
                        copiedList.add(cobj);
                    }
                    return;
                }
                copiedValue = this.deepCopy((EObject)sourceValue, copiedOwner);
            } else if (feature.isMany()) {
                List sourceList = (List)sourceValue;
                List copiedList = (List)copiedObj.eGet((EStructuralFeature)feature);
                Iterator iterator = sourceList.iterator();
                while (iterator.hasNext()) {
                    Object sobj;
                    Object cobj = sobj = iterator.next();
                    if (sobj instanceof CustomCategory) {
                        cobj = (CustomCategory)this.deepCopy((EObject)((CustomCategory)sobj), copiedOwner);
                        CustomCategory ccobj = (CustomCategory)cobj;
                        this.customCategoryPkg.getContentElements().add(ccobj);
                    }
                    copiedList.add(cobj);
                }
                return;
            }
            copiedObj.eSet((EStructuralFeature)feature, copiedValue);
        }

        @Override
        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(AuthoringUIResources.deepCopy_text);
        }

        private void initDeepCopy(CustomCategory source, CustomCategory targetParent) {
            MethodPlugin srcPlugin = UmaUtil.getMethodPlugin((EObject)source);
            MethodPlugin tgtPlugin = UmaUtil.getMethodPlugin((EObject)targetParent);
            this.customCategoryPkg = UmaUtil.findContentPackage((MethodPlugin)tgtPlugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
            this.nameHandler = new UniqueNamePNameHandler((Collection)this.customCategoryPkg.getContentElements());
            if (srcPlugin != tgtPlugin) {
                this.scanner = new ResourceScanner(srcPlugin, tgtPlugin);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReassignDialog
    extends AssignDialog {
        private CustomCategory parentElement;

        protected ReassignDialog(Shell parentShell, Collection elements, MethodElement parentElement) {
            super(parentShell, elements);
            this.parentElement = (CustomCategory)parentElement;
        }

        @Override
        protected Collection<Resource> doWorkBeforeSave() {
            Collection<Resource> resouresToSave = super.doWorkBeforeSave();
            resouresToSave.add(this.parentElement.eResource());
            UnassignAction.unassign(this.getShell(), this.getElements().get(0), this.parentElement, new ArrayList());
            return resouresToSave;
        }

        @Override
        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(AuthoringUIResources.AssignDialog_reassign_text);
        }
    }
}

