/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.providers.VariabilityElementLabelProvider;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MoveInConfigurationCommand;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ConfigurationOrderDialog
extends Dialog {
    private Composite baseComposite;
    private Button ctrl_up;
    private Button ctrl_down;
    private Table ctrl_views;
    private TableViewer viewsTableViewer;
    private IStructuredContentProvider viewsViewerContentProvider;
    private ILabelProvider viewsViewerLabelProvider;
    private MethodConfiguration config;
    private IActionManager actionManager;
    private ArrayList commands = new ArrayList();

    public ConfigurationOrderDialog(Shell parent, MethodConfiguration config, IActionManager actionManager) {
        super(parent);
        this.config = config;
        this.actionManager = actionManager;
    }

    protected Control createDialogArea(Composite parent) {
        this.baseComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.baseComposite.setLayout((Layout)gridLayout);
        this.baseComposite.setLayoutData((Object)new GridData());
        this.createLabel(this.baseComposite, " ", 4);
        this.createLabel(this.baseComposite, " ", 1);
        this.createLabel(this.baseComposite, AuthoringUIResources.ConfigurationOrderDialog_NavigationViews, 3);
        this.createLabel(this.baseComposite, " ", 1);
        this.ctrl_views = new Table(this.baseComposite, 2050);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        gridData.heightHint = 400;
        this.ctrl_views.setLayoutData((Object)gridData);
        this.initProviders();
        this.viewsTableViewer = new TableViewer(this.ctrl_views);
        this.viewsTableViewer.setContentProvider((IContentProvider)this.viewsViewerContentProvider);
        this.viewsTableViewer.setLabelProvider((IBaseLabelProvider)this.viewsViewerLabelProvider);
        Composite orderButtonPane = new Composite(this.baseComposite, 0);
        GridData gridData2 = new GridData(68);
        gridData2.horizontalSpan = 1;
        orderButtonPane.setLayoutData((Object)gridData2);
        orderButtonPane.setLayout((Layout)new GridLayout());
        this.ctrl_up = this.createButton(orderButtonPane, AuthoringUIText.UP_BUTTON_TEXT);
        this.ctrl_up.setLayoutData((Object)new GridData(768));
        this.ctrl_down = this.createButton(orderButtonPane, AuthoringUIText.DOWN_BUTTON_TEXT);
        this.ctrl_down.setLayoutData((Object)new GridData(768));
        this.ctrl_up.setEnabled(false);
        this.ctrl_down.setEnabled(false);
        this.createLabel(this.baseComposite, " ", 4);
        this.createLine(this.baseComposite, 4);
        super.getShell().setText(AuthoringUIResources.ConfigurationOrderDialog_description);
        this.addListeners();
        this.loadData();
        return this.baseComposite;
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    private Label createLabel(Composite parent, String text, int nCol) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = nCol;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        button.setText(label);
        return button;
    }

    private void initProviders() {
        this.viewsViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return ConfigurationOrderDialog.this.config.getProcessViews().toArray();
            }
        };
        this.viewsViewerLabelProvider = new VariabilityElementLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public boolean isExternal(Object element) {
                return !ConfigurationOrderDialog.this.config.getProcessViews().contains(element);
            }
        };
    }

    public void addListeners() {
        this.viewsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ConfigurationOrderDialog.this.viewsTableViewer.getSelection();
                if (selection.size() > 0) {
                    if (ConfigurationOrderDialog.this.viewsTableViewer.getTable().getSelectionIndex() > 0 && selection.size() == 1) {
                        ConfigurationOrderDialog.this.ctrl_up.setEnabled(true);
                    } else {
                        ConfigurationOrderDialog.this.ctrl_up.setEnabled(false);
                    }
                    if (ConfigurationOrderDialog.this.viewsTableViewer.getTable().getSelectionIndex() < ConfigurationOrderDialog.this.viewsTableViewer.getTable().getItemCount() - 1 && selection.size() == 1) {
                        ConfigurationOrderDialog.this.ctrl_down.setEnabled(true);
                    } else {
                        ConfigurationOrderDialog.this.ctrl_down.setEnabled(false);
                    }
                }
            }
        });
        this.ctrl_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ConfigurationOrderDialog.this.viewsTableViewer.getSelection();
                ArrayList moveUpItems = new ArrayList();
                moveUpItems.addAll(selection.toList());
                EReference feature = UmaPackage.eINSTANCE.getMethodConfiguration_ProcessViews();
                MoveInConfigurationCommand cmd = new MoveInConfigurationCommand(ConfigurationOrderDialog.this.config, moveUpItems, (EStructuralFeature)feature, 1);
                ConfigurationOrderDialog.this.actionManager.execute((IResourceAwareCommand)cmd);
                ConfigurationOrderDialog.this.commands.add(cmd);
                ConfigurationOrderDialog.this.viewsTableViewer.refresh();
                if (ConfigurationOrderDialog.this.viewsTableViewer.getTable().getSelectionIndex() > 0) {
                    ConfigurationOrderDialog.this.ctrl_up.setEnabled(true);
                } else {
                    ConfigurationOrderDialog.this.ctrl_up.setEnabled(false);
                }
                if (ConfigurationOrderDialog.this.viewsTableViewer.getTable().getSelectionIndex() < ConfigurationOrderDialog.this.viewsTableViewer.getTable().getItemCount() - 1) {
                    ConfigurationOrderDialog.this.ctrl_down.setEnabled(true);
                } else {
                    ConfigurationOrderDialog.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ConfigurationOrderDialog.this.viewsTableViewer.getSelection();
                ArrayList moveDownItems = new ArrayList();
                moveDownItems.addAll(selection.toList());
                EReference feature = UmaPackage.eINSTANCE.getMethodConfiguration_ProcessViews();
                MoveInConfigurationCommand cmd = new MoveInConfigurationCommand(ConfigurationOrderDialog.this.config, moveDownItems, (EStructuralFeature)feature, 0);
                ConfigurationOrderDialog.this.actionManager.execute((IResourceAwareCommand)cmd);
                ConfigurationOrderDialog.this.commands.add(cmd);
                ConfigurationOrderDialog.this.viewsTableViewer.refresh();
                if (ConfigurationOrderDialog.this.viewsTableViewer.getTable().getSelectionIndex() > 0) {
                    ConfigurationOrderDialog.this.ctrl_up.setEnabled(true);
                } else {
                    ConfigurationOrderDialog.this.ctrl_up.setEnabled(false);
                }
                if (ConfigurationOrderDialog.this.viewsTableViewer.getTable().getSelectionIndex() < ConfigurationOrderDialog.this.viewsTableViewer.getTable().getItemCount() - 1) {
                    ConfigurationOrderDialog.this.ctrl_down.setEnabled(true);
                } else {
                    ConfigurationOrderDialog.this.ctrl_down.setEnabled(false);
                }
            }
        });
    }

    private void loadData() {
        this.viewsTableViewer.setInput((Object)this.config);
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void cancelPressed() {
        if (!this.commands.isEmpty()) {
            int i = this.commands.size() - 1;
            while (i > -1) {
                Object cmd = this.commands.get(i);
                if (cmd instanceof MoveInConfigurationCommand) {
                    ((MoveInConfigurationCommand)cmd).undo();
                }
                --i;
            }
        }
        super.cancelPressed();
    }
}

